/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.daemon;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.markup.ErrorStripeRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.ide.document.DocumentExKt;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.editor.TextControlModelExKt;
import com.jetbrains.rd.ide.model.BackendDaemonStateEnum;
import com.jetbrains.rd.ide.model.BackendHighlightingProgressStateEnum;
import com.jetbrains.rd.ide.model.RdDaemonModel;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdDocumentModel;
import com.jetbrains.rd.ide.model.RdMarkupKey;
import com.jetbrains.rd.ide.model.RdMarkupModel;
import com.jetbrains.rd.ide.model.RdMarkupModelBase;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.platform.client.SessionUtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdserver.daemon.BackendDaemonStatusHostKt;
import com.jetbrains.rdserver.document.BackendDocumentHost;
import com.jetbrains.rdserver.document.BackendDocumentHostListener;
import com.jetbrains.rdserver.fileEditors.GuestFileEditorManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0083@\u00a2\u0006\u0002\u0010\u000eJ0\u0010\u000f\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\n0\u0013H\u0002J\u000e\u0010\u0016\u001a\u0004\u0018\u00010\u0014*\u00020\rH\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u00182\u0006\u0010\u0019\u001a\u00020\u0014H\u0002J\u0018\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0001H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/rdserver/daemon/BackendDaemonStatusHost;", "", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/client/ClientProjectSession;Lkotlinx/coroutines/CoroutineScope;)V", "updateStatusEventFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "updateModelForFileEditor", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "(Lcom/intellij/openapi/fileEditor/FileEditor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "foreachDaemonModel", "fileEditors", "", "action", "Lkotlin/Function2;", "Lcom/intellij/openapi/editor/Editor;", "Lcom/jetbrains/rd/ide/model/RdDaemonModel;", "asEditor", "collectMarkupModelsFor", "", "editor", "restartDaemon", "document", "Lcom/intellij/openapi/editor/Document;", "reason", "Companion", "DocumentListener", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendDaemonStatusHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendDaemonStatusHost.kt\ncom/jetbrains/rdserver/daemon/BackendDaemonStatusHost\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,225:1\n540#2:226\n525#2,6:227\n129#3:233\n158#3,3:234\n13#4:237\n*S KotlinDebug\n*F\n+ 1 BackendDaemonStatusHost.kt\ncom/jetbrains/rdserver/daemon/BackendDaemonStatusHost\n*L\n187#1:226\n187#1:227,6\n188#1:233\n188#1:234,3\n50#1:237\n*E\n"})
public final class BackendDaemonStatusHost {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientProjectSession session;
    @NotNull
    private final MutableSharedFlow<Unit> updateStatusEventFlow;
    @NotNull
    private static final Logger LOG;

    public BackendDaemonStatusHost(@NotNull ClientProjectSession session, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.session = session;
        this.updateStatusEventFlow = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ BackendDaemonStatusHost this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)FlowKt.debounce-HG0u8IE((Flow)((Flow)this.this$0.updateStatusEventFlow), (long)DurationKt.toDuration((int)300, (DurationUnit)DurationUnit.MILLISECONDS)), (Function2)((Function2)new Function2<Unit, Continuation<? super Unit>, Object>(this.this$0, null){
                            Object L$0;
                            Object L$1;
                            int label;
                            final /* synthetic */ BackendDaemonStatusHost this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        var2_3 = GuestFileEditorManager.Companion.getInstance(BackendDaemonStatusHost.access$getSession$p(this.this$0)).getAllEditors().iterator();
lbl6:
                                        // 3 sources

                                        while (var2_3.hasNext()) {
                                            fileEditor = var2_3.next();
                                            this.L$0 = var2_3;
                                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)fileEditor);
                                            this.label = 1;
                                            v0 = BackendDaemonStatusHost.access$updateModelForFileEditor(this.this$0, fileEditor, (Continuation)this);
                                            if (v0 != var4_2) continue;
                                            return var4_2;
                                        }
                                        break;
                                    }
                                    case 1: {
                                        fileEditor = (FileEditor)this.L$1;
                                        var2_3 = (Iterator<FileEditor>)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
                                        ** GOTO lbl6
                                    }
                                }
                                return Unit.INSTANCE;
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Unit p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        MessageBusConnection connection = this.session.getProject().getMessageBus().connect((Disposable)this.session);
        Topic topic = DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"DAEMON_EVENT_TOPIC");
        connection.subscribe(topic, (Object)new DaemonCodeAnalyzer.DaemonListener(){

            public void daemonStarting(Collection<? extends FileEditor> files2) {
                Intrinsics.checkNotNullParameter(files2, (String)"files");
                this.foreachDaemonModel(files2, (Function2<? super Editor, ? super RdDaemonModel, Unit>)2::daemonStarting$lambda$0);
                updateStatusEventFlow.tryEmit((Object)Unit.INSTANCE);
            }

            public void daemonFinished(Collection<? extends FileEditor> files2) {
                Intrinsics.checkNotNullParameter(files2, (String)"files");
                ActionsKt.runInEdt$default(null, () -> 2.daemonFinished$lambda$1(this, files2), (int)1, null);
            }

            private static final Unit daemonStarting$lambda$0(Editor editor, RdDaemonModel it) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"<unused var>");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.getHighlightingProgressState().set((Object)BackendHighlightingProgressStateEnum.LOCAL_STAGES);
                return Unit.INSTANCE;
            }

            private static final Unit daemonFinished$lambda$1$0(Editor editor, RdDaemonModel it) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"<unused var>");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.getHighlightingProgressState().set((Object)BackendHighlightingProgressStateEnum.OFF);
                return Unit.INSTANCE;
            }

            private static final Unit daemonFinished$lambda$1(BackendDaemonStatusHost this$0, Collection $files) {
                this$0.foreachDaemonModel($files, (Function2<? super Editor, ? super RdDaemonModel, Unit>)2::daemonFinished$lambda$1$0);
                this$0.updateStatusEventFlow.tryEmit((Object)Unit.INSTANCE);
                return Unit.INSTANCE;
            }
        });
        HeavyProcessLatch.INSTANCE.addListener((Disposable)this.session, new HeavyProcessLatch.HeavyProcessListener(){

            public void processFinished(HeavyProcessLatch.Operation op) {
                Intrinsics.checkNotNullParameter((Object)op, (String)"op");
                updateStatusEventFlow.tryEmit((Object)Unit.INSTANCE);
            }

            public void processStarted(HeavyProcessLatch.Operation op) {
                Intrinsics.checkNotNullParameter((Object)op, (String)"op");
                updateStatusEventFlow.tryEmit((Object)Unit.INSTANCE);
            }
        });
    }

    @RequiresBackgroundThread
    private final Object updateModelForFileEditor(FileEditor fileEditor, Continuation<? super Unit> $completion) {
        ThreadingAssertions.assertBackgroundThread();
        Object object = CoroutinesKt.readAction(() -> BackendDaemonStatusHost.updateModelForFileEditor$lambda$0(this, fileEditor), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void foreachDaemonModel(Collection<? extends FileEditor> fileEditors, Function2<? super Editor, ? super RdDaemonModel, Unit> action) {
        for (FileEditor fileEditor : fileEditors) {
            Editor editor;
            if (this.asEditor(fileEditor) == null) continue;
            for (RdDaemonModel model2 : this.collectMarkupModelsFor(editor)) {
                action.invoke((Object)editor, (Object)model2);
            }
        }
    }

    private final Editor asEditor(FileEditor $this$asEditor) {
        TextEditor textEditor = $this$asEditor instanceof TextEditor ? (TextEditor)$this$asEditor : null;
        return textEditor != null ? textEditor.getEditor() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<RdDaemonModel> collectMarkupModelsFor(Editor editor) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map.Entry it;
        void $this$filterTo$iv$iv;
        Map $this$filter$iv;
        BackendDocumentHost documentHost = BackendDocumentHost.Companion.getInstance(this.session.getAppSession());
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        DocumentSynchronizer documentSynchronizer = documentHost.tryGetSynchronizer(document);
        if (documentSynchronizer == null) {
            return CollectionsKt.emptyList();
        }
        DocumentSynchronizer documentSynchronizer2 = documentSynchronizer;
        RdDocumentModel documentModel = documentSynchronizer2.getModelDocument();
        Map map2 = (Map)DocumentExKt.getMarkups((RdDocumentModel)documentModel);
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Object object = $this$filterTo$iv$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = object.next();
            boolean bl = false;
            Project project = editor.getProject();
            if (!Intrinsics.areEqual((Object)((RdMarkupKey)it.getKey()).getProjectId(), (Object)(project != null ? ProjectUtilKt.getRdProjectId((Project)project) : null))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            it = item$iv$iv;
            Object object2 = destination$iv$iv;
            boolean bl = false;
            object2.add((RdMarkupModelBase)it.getValue());
        }
        RdMarkupModelBase documentMarkup = (RdMarkupModelBase)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
        if (!(documentMarkup instanceof RdMarkupModel)) {
            return CollectionsKt.emptyList();
        }
        List result = new ArrayList();
        ((Collection)result).add(((RdMarkupModel)documentMarkup).getDaemon());
        for (TextControlModel textControl : documentModel.getTextControls().values()) {
            RdMarkupModel textControlMarkup;
            object = TextControlModelExKt.getMarkup((TextControlModel)textControl).getValueOrNull();
            if ((object instanceof RdMarkupModel ? (RdMarkupModel)object : null) == null) continue;
            textControlMarkup = textControlMarkup;
            ((Collection)result).add(textControlMarkup.getDaemon());
        }
        return result;
    }

    private final void restartDaemon(Document document, Object reason) {
        Project project = this.session.getProject();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        PsiFile psiFile = psiDocumentManager.getPsiFile(document);
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)project);
        Intrinsics.checkNotNull((Object)daemonCodeAnalyzer, (String)"null cannot be cast to non-null type com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl");
        DaemonCodeAnalyzerImpl daemonCodeAnalyzer2 = (DaemonCodeAnalyzerImpl)daemonCodeAnalyzer;
        if (ApplicationKt.getApplication().isUnitTestMode()) {
            psiDocumentManager.commitDocument(document);
            FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(psiFile2.getVirtualFile());
            Intrinsics.checkNotNull((Object)fileEditor, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.TextEditor");
            TextEditor textEditor = (TextEditor)fileEditor;
            daemonCodeAnalyzer2.runPasses(psiFile2, document, textEditor, new int[0], false, null);
        } else {
            daemonCodeAnalyzer2.restart(psiFile2, reason);
        }
    }

    private static final Unit updateModelForFileEditor$lambda$0(BackendDaemonStatusHost this$0, FileEditor $fileEditor) {
        TrafficLightRenderer.DaemonCodeAnalyzerStatus status;
        Editor editor = this$0.asEditor($fileEditor);
        if (editor == null) {
            return Unit.INSTANCE;
        }
        Editor editor2 = editor;
        if (editor2.isDisposed()) {
            return Unit.INSTANCE;
        }
        MarkupModel markupModel = editor2.getMarkupModel();
        Intrinsics.checkNotNull((Object)markupModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorMarkupModelImpl");
        ErrorStripeRenderer errorStripeRenderer = ((EditorMarkupModelImpl)markupModel).getErrorStripeRenderer();
        TrafficLightRenderer trafficLightRenderer = errorStripeRenderer instanceof TrafficLightRenderer ? (TrafficLightRenderer)errorStripeRenderer : null;
        TrafficLightRenderer.DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status = trafficLightRenderer != null ? trafficLightRenderer.getDaemonCodeAnalyzerStatus() : null;
        if (status == null) {
            return Unit.INSTANCE;
        }
        for (RdDaemonModel daemon : this$0.collectMarkupModelsFor(editor2)) {
            if (status.reasonWhySuspended != null) {
                daemon.getState().set((Object)BackendDaemonStateEnum.SUSPENDED);
                daemon.getMessage().set((Object)status.reasonWhySuspended);
                HeavyProcessLatch.Type type = status.heavyProcessType;
                daemon.getHeavyProcessType().set(type != null ? BackendDaemonStatusHostKt.access$toModel(type) : null);
                continue;
            }
            if (status.reasonWhyDisabled != null) {
                daemon.getState().set((Object)BackendDaemonStateEnum.DISABLED);
                daemon.getMessage().set((Object)status.reasonWhySuspended);
                continue;
            }
            if (status.errorAnalyzingFinished) {
                daemon.getState().set((Object)BackendDaemonStateEnum.UP_TO_DATE);
                continue;
            }
            daemon.getState().set((Object)BackendDaemonStateEnum.IN_PROGRESS_LOCAL);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$updateModelForFileEditor(BackendDaemonStatusHost $this, FileEditor fileEditor, Continuation $completion) {
        return $this.updateModelForFileEditor(fileEditor, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ ClientProjectSession access$getSession$p(BackendDaemonStatusHost $this) {
        return $this.session;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BackendDaemonStatusHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rdserver/daemon/BackendDaemonStatusHost$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rdserver/daemon/BackendDaemonStatusHost;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nBackendDaemonStatusHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendDaemonStatusHost.kt\ncom/jetbrains/rdserver/daemon/BackendDaemonStatusHost$Companion\n+ 2 Components.kt\ncom/jetbrains/rd/platform/util/ComponentsKt\n*L\n1#1,225:1\n23#2:226\n*S KotlinDebug\n*F\n+ 1 BackendDaemonStatusHost.kt\ncom/jetbrains/rdserver/daemon/BackendDaemonStatusHost$Companion\n*L\n51#1:226\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BackendDaemonStatusHost getInstance(@NotNull ClientProjectSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ClientSession $this$service$iv = (ClientSession)session;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(BackendDaemonStatusHost.class);
            if (object == null) {
                throw new IllegalStateException(("Can't find service for " + $this$service$iv).toString());
            }
            return (BackendDaemonStatusHost)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J8\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rdserver/daemon/BackendDaemonStatusHost$DocumentListener;", "Lcom/jetbrains/rdserver/document/BackendDocumentHostListener;", "<init>", "()V", "documentBound", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "model", "Lcom/jetbrains/rd/ide/model/RdDocumentModel;", "document", "Lcom/intellij/openapi/editor/Document;", "onMarkupAdded", "markupLifetime", "protocolMarkupModel", "Lcom/jetbrains/rd/ide/model/RdMarkupModelBase;", "key", "Lcom/jetbrains/rd/ide/model/RdMarkupKey;", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nBackendDaemonStatusHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendDaemonStatusHost.kt\ncom/jetbrains/rdserver/daemon/BackendDaemonStatusHost$DocumentListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,225:1\n60#2,5:226\n60#2,5:231\n*S KotlinDebug\n*F\n+ 1 BackendDaemonStatusHost.kt\ncom/jetbrains/rdserver/daemon/BackendDaemonStatusHost$DocumentListener\n*L\n120#1:226,5\n126#1:231,5\n*E\n"})
    public static final class DocumentListener
    implements BackendDocumentHostListener {
        @Override
        public void documentBound(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull RdDocumentId documentId, @NotNull RdDocumentModel model2, @NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            DocumentExKt.getMarkups((RdDocumentModel)model2).view(lifetime, (arg_0, arg_1, arg_2) -> DocumentListener.documentBound$lambda$0(this, documentId, session, document, arg_0, arg_1, arg_2));
        }

        private final void onMarkupAdded(Lifetime markupLifetime, RdMarkupModelBase protocolMarkupModel, RdDocumentId documentId, RdMarkupKey key, ClientAppSession session, Document document) {
            if (!(protocolMarkupModel instanceof RdMarkupModel)) {
                Logger $this$debug_u24default$iv = LOG;
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("No frontend markup model for " + DocumentExKt.toDebugString((RdDocumentId)documentId), t$iv);
                }
                return;
            }
            ClientProjectSession projectSession = SessionUtilKt.getProjectSession((ClientAppSession)session, (RdProjectId)key.getProjectId());
            if (projectSession == null) {
                Logger $this$debug_u24default$iv = LOG;
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("No project session for " + key.getProjectId(), t$iv);
                }
                return;
            }
            ((RdMarkupModel)protocolMarkupModel).getDaemon().getRestart().advise(markupLifetime, arg_0 -> DocumentListener.onMarkupAdded$lambda$2(projectSession, document, arg_0));
        }

        private static final Unit documentBound$lambda$0(DocumentListener this$0, RdDocumentId $documentId, ClientAppSession $session, Document $document, Lifetime markupLifetime, RdMarkupKey key, RdMarkupModelBase protocolMarkupModel) {
            Intrinsics.checkNotNullParameter((Object)markupLifetime, (String)"markupLifetime");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)protocolMarkupModel, (String)"protocolMarkupModel");
            this$0.onMarkupAdded(markupLifetime, protocolMarkupModel, $documentId, key, $session, $document);
            return Unit.INSTANCE;
        }

        private static final Unit onMarkupAdded$lambda$2(ClientProjectSession $projectSession, Document $document, Unit it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Companion.getInstance($projectSession).restartDaemon($document, "BackendDaemonStatusHost.DocumentListener.onMarkupAdded");
            return Unit.INSTANCE;
        }
    }
}

