/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.daemon;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.SlowOperations;
import com.jetbrains.rd.ide.document.DocumentExKt;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.editor.TextControlModelExKt;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdDocumentModel;
import com.jetbrains.rd.ide.model.RdMarkupKey;
import com.jetbrains.rd.ide.model.RdMarkupModel;
import com.jetbrains.rd.ide.model.RdMarkupModelBase;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.platform.client.SessionUtilKt;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rdserver.daemon.BackendEditorMarkupModelContributor;
import com.jetbrains.rdserver.daemon.BackendMarkupModelContributor;
import com.jetbrains.rdserver.daemon.BackendMarkupSuppressor;
import com.jetbrains.rdserver.daemon.BackendMarkupSuppressors;
import com.jetbrains.rdserver.daemon.BackendProtocolMarkupModelExtensionHandler;
import com.jetbrains.rdserver.daemon.BackendRangeMarkerStorage;
import com.jetbrains.rdserver.document.BackendDocumentHost;
import com.jetbrains.rdserver.document.BackendDocumentHostListener;
import com.jetbrains.rdserver.editors.BackendEditorHost;
import com.jetbrains.rdserver.editors.BackendEditorHostListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 ,2\u00020\u0001:\u0003,-.B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0010J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\nJ\u001a\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dJ2\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!H\u0002J(\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0014\u001a\u00020\fH\u0002J \u0010&\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J \u0010)\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u001f\u001a\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007RF\u0010\b\u001a:\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\tj\u001c\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\tj\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/jetbrains/rdserver/daemon/BackendMarkupHost;", "", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "projectIdToMap", "Ljava/util/HashMap;", "Lcom/jetbrains/rd/ide/model/RdProjectId;", "", "Lcom/intellij/openapi/editor/Document;", "Lcom/jetbrains/rdserver/daemon/BackendMarkupModelContributor;", "Lkotlin/collections/HashMap;", "editorLevelContributors", "Lcom/intellij/openapi/editor/Editor;", "Lcom/jetbrains/rdserver/daemon/BackendEditorMarkupModelContributor;", "getContributor", "editor", "document", "projectId", "project", "Lcom/intellij/openapi/project/Project;", "suppressRangeMarkers", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "reason", "", "addUniqueDocumentContributor", "contributor", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "createDocumentMarkupContributor", "documentLifetime", "documentModel", "Lcom/jetbrains/rd/ide/model/RdDocumentModel;", "createEditorMarkupContributor", "textControlModel", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "initMarkupExtensions", "protocolMarkupModel", "Lcom/jetbrains/rd/ide/model/RdMarkupModel;", "Companion", "MyDocumentHostListener", "MyEditorHostListener", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendMarkupHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendMarkupHost.kt\ncom/jetbrains/rdserver/daemon/BackendMarkupHost\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,173:1\n383#2,7:174\n1#3:181\n13#4:182\n*S KotlinDebug\n*F\n+ 1 BackendMarkupHost.kt\ncom/jetbrains/rdserver/daemon/BackendMarkupHost\n*L\n58#1:174,7\n36#1:182\n*E\n"})
public final class BackendMarkupHost {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private final HashMap<RdProjectId, Map<Document, BackendMarkupModelContributor>> projectIdToMap;
    @NotNull
    private final HashMap<Editor, BackendEditorMarkupModelContributor> editorLevelContributors;
    @NotNull
    private static final Logger LOG;

    public BackendMarkupHost(@NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.projectIdToMap = new HashMap();
        this.editorLevelContributors = new HashMap();
    }

    @NotNull
    public final ClientAppSession getSession() {
        return this.session;
    }

    @Nullable
    public final BackendEditorMarkupModelContributor getContributor(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return this.editorLevelContributors.get(editor);
    }

    @Nullable
    public final BackendMarkupModelContributor getContributor(@NotNull Document document, @Nullable RdProjectId projectId) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Map<Document, BackendMarkupModelContributor> map2 = this.projectIdToMap.get(projectId);
        return map2 != null ? map2.get(document) : null;
    }

    @Nullable
    public final BackendMarkupModelContributor getContributor(@NotNull Document document, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Project project2 = project;
        return this.getContributor(document, (RdProjectId)(project2 != null ? ProjectUtilKt.getRdProjectId((Project)project2) : null));
    }

    public final void suppressRangeMarkers(@NotNull Lifetime lifetime, @NotNull Editor editor, @NotNull String reason) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            BackendMarkupModelContributor contributor = this.getContributor(document, editor.getProject());
            Object object = contributor;
            if (object == null || (object = ((BackendMarkupModelContributor)object).getSuppressor()) == null) break block0;
            ((BackendMarkupSuppressor)object).suppress(lifetime, reason);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addUniqueDocumentContributor(Lifetime lifetime, Document document, RdProjectId projectId, BackendMarkupModelContributor contributor, RdDocumentId documentId) {
        Object object;
        void $this$getOrPut$iv;
        Map map2 = this.projectIdToMap;
        RdProjectId key$iv = projectId;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Map answer$iv = new ConcurrentHashMap();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Map map3 = (Map)object;
        CollectionExKt.addUnique((Map)map3, (Lifetime)lifetime, (Object)document, (Object)contributor);
        RdProjectId rdProjectId = projectId;
        LOG.trace("Backend markup model contributor created for " + DocumentExKt.toDebugString((RdDocumentId)documentId) + " (project " + (rdProjectId != null ? rdProjectId.getValue() : null) + ")");
    }

    private final void createDocumentMarkupContributor(Lifetime documentLifetime, RdDocumentId documentId, RdDocumentModel documentModel, Document document) {
        DocumentExKt.getMarkups((RdDocumentModel)documentModel).view(documentLifetime, (arg_0, arg_1, arg_2) -> BackendMarkupHost.createDocumentMarkupContributor$lambda$0(documentId, this, document, arg_0, arg_1, arg_2));
    }

    private final void createEditorMarkupContributor(Lifetime lifetime, TextControlModel textControlModel, Editor editor) {
        SourceExKt.adviseOnce((ISource)((ISource)TextControlModelExKt.getMarkup((TextControlModel)textControlModel)), (Lifetime)lifetime, arg_0 -> BackendMarkupHost.createEditorMarkupContributor$lambda$0(editor, this, lifetime, arg_0));
    }

    private final void initMarkupExtensions(Lifetime lifetime, RdMarkupModel protocolMarkupModel, BackendMarkupModelContributor contributor) {
        BackendProtocolMarkupModelExtensionHandler.Companion.getEP_NAME().forEachExtensionSafe(arg_0 -> BackendMarkupHost.initMarkupExtensions$lambda$1(arg_0 -> BackendMarkupHost.initMarkupExtensions$lambda$0(lifetime, protocolMarkupModel, contributor, arg_0), arg_0));
    }

    private static final Unit createDocumentMarkupContributor$lambda$0(RdDocumentId $documentId, BackendMarkupHost this$0, Document $document, Lifetime markupLifetime, RdMarkupKey key, RdMarkupModelBase protocolMarkupModel) {
        ClientProjectSession projectSession;
        Intrinsics.checkNotNullParameter((Object)markupLifetime, (String)"markupLifetime");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)protocolMarkupModel, (String)"protocolMarkupModel");
        if (!(protocolMarkupModel instanceof RdMarkupModel)) {
            LOG.info("No frontend markup model for " + DocumentExKt.toDebugString((RdDocumentId)$documentId));
            return Unit.INSTANCE;
        }
        ClientProjectSession clientProjectSession = projectSession = SessionUtilKt.getProjectSession((ClientAppSession)this$0.session, (RdProjectId)key.getProjectId());
        MarkupModelEx documentMarkupModel = (MarkupModelEx)DocumentMarkupModel.forDocument((Document)$document, (Project)(clientProjectSession != null ? clientProjectSession.getProject() : null), (boolean)true);
        if (documentMarkupModel == null) {
            LOG.info("No document markup model for " + DocumentExKt.toDebugString((RdDocumentId)$documentId));
            return Unit.INSTANCE;
        }
        DocumentSynchronizer documentSynchronizer = BackendDocumentHost.Companion.getInstance(this$0.session).tryGetSynchronizer($documentId);
        if (documentSynchronizer == null) {
            LOG.info("No document synchronizer for " + DocumentExKt.toDebugString((RdDocumentId)$documentId));
            return Unit.INSTANCE;
        }
        BackendMarkupSuppressor suppressor = BackendMarkupSuppressors.createSuppressor$default(BackendMarkupSuppressors.Companion.getInstance(this$0.session), markupLifetime, null, null, 6, null);
        BackendRangeMarkerStorage storage = new BackendRangeMarkerStorage(markupLifetime, $document);
        BackendMarkupModelContributor contributor = new BackendMarkupModelContributor(this$0.session, projectSession, $document, documentSynchronizer, suppressor, (RdMarkupModel)protocolMarkupModel, storage);
        this$0.initMarkupExtensions(markupLifetime, (RdMarkupModel)protocolMarkupModel, contributor);
        this$0.addUniqueDocumentContributor(markupLifetime, $document, key.getProjectId(), contributor, $documentId);
        ((RdMarkupModel)protocolMarkupModel).isReady().set((Object)true);
        return Unit.INSTANCE;
    }

    private static final Unit createEditorMarkupContributor$lambda$0(Editor $editor, BackendMarkupHost this$0, Lifetime $lifetime, RdMarkupModelBase it) {
        ClientProjectSession clientProjectSession;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!(it instanceof RdMarkupModel)) {
            return Unit.INSTANCE;
        }
        TextControlId textControlId = BackendEditorHost.Companion.textControlIdForSession($editor, this$0.session);
        if (textControlId == null || (textControlId = textControlId.getDocumentId()) == null) {
            return Unit.INSTANCE;
        }
        TextControlId documentId = textControlId;
        Project project = $editor.getProject();
        if (project != null) {
            Project project2 = project;
            boolean bl = false;
            clientProjectSession = this$0.session.getProjectSession(project2);
        } else {
            clientProjectSession = null;
        }
        ClientProjectSession projectSession = clientProjectSession;
        DocumentSynchronizer documentSynchronizer = BackendDocumentHost.Companion.getInstance(this$0.session).tryGetSynchronizer((RdDocumentId)documentId);
        if (documentSynchronizer == null) {
            LOG.info("No document synchronizer for " + DocumentExKt.toDebugString((RdDocumentId)documentId));
            return Unit.INSTANCE;
        }
        Document document = documentSynchronizer.getDocument();
        BackendMarkupModelContributor backendMarkupModelContributor = this$0.getContributor(document, $editor.getProject());
        if (backendMarkupModelContributor == null) {
            Project project3;
            throw new RuntimeException("No backend markup model contributor for " + DocumentExKt.toDebugString((RdDocumentId)documentId) + " (project " + ((project3 = $editor.getProject()) != null && (project3 = ProjectUtilKt.getRdProjectId((Project)project3)) != null ? project3.getValue() : null) + ")");
        }
        BackendMarkupModelContributor documentContributor = backendMarkupModelContributor;
        BackendMarkupSuppressor parentSuppressor = documentContributor.getSuppressor();
        BackendMarkupSuppressors suppressors = BackendMarkupSuppressors.Companion.getInstance(this$0.session);
        BackendMarkupSuppressor suppressor = suppressors.createSuppressor($lifetime, "document suppressor", parentSuppressor);
        BackendRangeMarkerStorage storage = new BackendRangeMarkerStorage($lifetime, document);
        BackendEditorMarkupModelContributor contributor = new BackendEditorMarkupModelContributor(this$0.session, projectSession, $editor, documentSynchronizer, suppressor, (RdMarkupModel)it, storage);
        this$0.initMarkupExtensions($lifetime, (RdMarkupModel)it, contributor);
        ((RdMarkupModel)it).isReady().set((Object)true);
        CollectionExKt.addUnique((Map)this$0.editorLevelContributors, (Lifetime)$lifetime, (Object)$editor, (Object)contributor);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit initMarkupExtensions$lambda$0(Lifetime $lifetime, RdMarkupModel $protocolMarkupModel, BackendMarkupModelContributor $contributor, BackendProtocolMarkupModelExtensionHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        AutoCloseable autoCloseable = (AutoCloseable)SlowOperations.knownIssue((String)"IJPL-162773");
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            handler.consume($lifetime, $protocolMarkupModel.getExtensions(), $contributor);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return Unit.INSTANCE;
    }

    private static final void initMarkupExtensions$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BackendMarkupHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rdserver/daemon/BackendMarkupHost$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rdserver/daemon/BackendMarkupHost;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nBackendMarkupHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendMarkupHost.kt\ncom/jetbrains/rdserver/daemon/BackendMarkupHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,173:1\n30#2,2:174\n*S KotlinDebug\n*F\n+ 1 BackendMarkupHost.kt\ncom/jetbrains/rdserver/daemon/BackendMarkupHost$Companion\n*L\n34#1:174,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BackendMarkupHost getInstance(@NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ComponentManager $this$service$iv = (ComponentManager)session;
            boolean $i$f$service = false;
            Class<BackendMarkupHost> serviceClass$iv = BackendMarkupHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (BackendMarkupHost)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rdserver/daemon/BackendMarkupHost$MyDocumentHostListener;", "Lcom/jetbrains/rdserver/document/BackendDocumentHostListener;", "<init>", "()V", "documentBound", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "model", "Lcom/jetbrains/rd/ide/model/RdDocumentModel;", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.platform.backend.split"})
    public static final class MyDocumentHostListener
    implements BackendDocumentHostListener {
        @Override
        public void documentBound(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull RdDocumentId documentId, @NotNull RdDocumentModel model2, @NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Companion.getInstance(session).createDocumentMarkupContributor(lifetime, documentId, model2, document);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rdserver/daemon/BackendMarkupHost$MyEditorHostListener;", "Lcom/jetbrains/rdserver/editors/BackendEditorHostListener;", "<init>", "()V", "editorBound", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "appSession", "Lcom/intellij/openapi/client/ClientAppSession;", "projectSession", "Lcom/intellij/openapi/client/ClientProjectSession;", "textControlId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "editorModel", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.platform.backend.split"})
    public static final class MyEditorHostListener
    implements BackendEditorHostListener {
        @Override
        public void editorBound(@NotNull Lifetime lifetime, @NotNull ClientAppSession appSession, @Nullable ClientProjectSession projectSession, @NotNull TextControlId textControlId, @NotNull TextControlModel editorModel, @NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)appSession, (String)"appSession");
            Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
            Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Companion.getInstance(appSession).createEditorMarkupContributor(lifetime, editorModel, editor);
            ClientProjectSession clientProjectSession = projectSession;
            if (clientProjectSession == null || (clientProjectSession = clientProjectSession.getProject()) == null) {
                return;
            }
            ClientProjectSession project = clientProjectSession;
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
            if (virtualFile == null) {
                return;
            }
            VirtualFile virtualFile2 = virtualFile;
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile2);
            if (psiFile != null) {
                DaemonCodeAnalyzer.getInstance((Project)project).restart((Object)"BackendMarkupHost.editorBound");
            }
        }
    }
}

