/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.debugger;

import com.intellij.ide.DataManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.ide.model.uiautomation.BeneluxDebugToolwindowView;
import com.jetbrains.ide.model.uiautomation.BeneluxView;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdserver.debugger.BackendDebuggerHost;
import com.jetbrains.rdserver.lux.adapter.LuxPanelAdapter;
import com.jetbrains.rdserver.lux.util.BeneluxViewProvider;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/debugger/DebugToolwindowBeneluxViewProvider;", "Lcom/jetbrains/rdserver/lux/util/BeneluxViewProvider;", "<init>", "()V", "createBeneluxView", "Lcom/jetbrains/ide/model/uiautomation/BeneluxView;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "component", "Ljava/awt/Component;", "luxAdapter", "Lcom/jetbrains/rdserver/lux/adapter/LuxPanelAdapter;", "intellij.platform.backend.split"})
public final class DebugToolwindowBeneluxViewProvider
implements BeneluxViewProvider {
    @Override
    @Nullable
    public BeneluxView createBeneluxView(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull Component component, @NotNull LuxPanelAdapter luxAdapter) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)luxAdapter, (String)"luxAdapter");
        XDebugSession xDebugSession = (XDebugSession)DataManager.getInstance().getDataContext(component).getData(XDebugSession.DATA_KEY);
        if (xDebugSession == null) {
            return null;
        }
        XDebugSession debugSession = xDebugSession;
        Project project = debugSession.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ClientProjectSession clientProjectSession = session.getProjectSession(project);
        if (clientProjectSession == null) {
            return null;
        }
        ClientProjectSession projectSession = clientProjectSession;
        int luxId = luxAdapter.getLuxId();
        BackendDebuggerHost backendDebuggerHost = BackendDebuggerHost.Companion.getInstance(projectSession);
        XDebugProcess xDebugProcess = debugSession.getDebugProcess();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugProcess, (String)"getDebugProcess(...)");
        backendDebuggerHost.sendDebuggerLuxComponent(lifetime, luxId, xDebugProcess);
        return (BeneluxView)new BeneluxDebugToolwindowView(ProjectUtilKt.getRdProjectId((Project)projectSession.getProject()), luxId);
    }
}

