/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.lux.adapter;

import com.intellij.openapi.actionSystem.impl.PopupShowingTimeTracker;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.ide.model.LuxLayoutSource;
import com.jetbrains.rd.ide.model.LxAbstractComponentInfo;
import com.jetbrains.rd.ide.model.LxPanel;
import com.jetbrains.rd.ide.model.LxSize;
import com.jetbrains.rd.ide.model.LxWindow;
import com.jetbrains.rd.ide.model.LxWindowInfo;
import com.jetbrains.rd.ide.model.LxWindowRef;
import com.jetbrains.rd.platform.codeWithMe.lux.UtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdserver.lux.adapter.LuxComponentAdapter;
import com.jetbrains.rdserver.lux.services.LuxHostService;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \r2\u00020\u0001:\u0001\rB!\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/lux/adapter/LuxWindowAdapter;", "Lcom/jetbrains/rdserver/lux/adapter/LuxComponentAdapter;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "windowModel", "Lcom/jetbrains/rd/ide/model/LxWindow;", "window", "Ljava/awt/Window;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/ide/model/LxWindow;Ljava/awt/Window;)V", "updateMinimumSize", "", "updateFocusableWindowState", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nLuxWindowAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuxWindowAdapter.kt\ncom/jetbrains/rdserver/lux/adapter/LuxWindowAdapter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,47:1\n67#2,4:48\n74#2,4:52\n*S KotlinDebug\n*F\n+ 1 LuxWindowAdapter.kt\ncom/jetbrains/rdserver/lux/adapter/LuxWindowAdapter\n*L\n41#1:48,4\n42#1:52,4\n*E\n"})
public class LuxWindowAdapter
extends LuxComponentAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LxWindow windowModel;

    protected LuxWindowAdapter(@NotNull Lifetime lifetime, @NotNull LxWindow windowModel, @NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)windowModel, (String)"windowModel");
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        super(lifetime, (LxPanel)windowModel, window);
        this.windowModel = windowModel;
        this.updateMinimumSize();
        this.updateFocusableWindowState();
    }

    public final void updateMinimumSize() {
        Logger logger;
        Dimension dimension = this.getWindow().getMinimumSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getMinimumSize(...)");
        LxSize size = UtilKt.toLx((Dimension)dimension);
        Logger $this$trace$iv = this.getLogger();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Set minimumSize. Old value: " + this.getModel().getMinimumSize().getValueOrNull() + ". New value: " + size + ". Node: " + this.getModel().getLocation());
        }
        Logger $this$traceThrowable$iv = this.getParanoidLogger();
        boolean $i$f$traceThrowable = false;
        if ($this$traceThrowable$iv.isTraceEnabled()) {
            logger = $this$traceThrowable$iv;
            boolean bl = false;
            logger.trace(new Throwable());
        }
        this.windowModel.getMinimumSize().set((Object)size);
    }

    public final void updateFocusableWindowState() {
        this.windowModel.getFocusableWindowState().set((Object)this.getWindow().getFocusableWindowState());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/lux/adapter/LuxWindowAdapter$Companion;", "", "<init>", "()V", "create", "Lcom/jetbrains/rdserver/lux/adapter/LuxWindowAdapter;", "window", "Ljava/awt/Window;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LuxWindowAdapter create(@NotNull Window window) {
            Intrinsics.checkNotNullParameter((Object)window, (String)"window");
            LxWindowRef parentRef = LuxHostService.Companion.getInstance().wrapWindowToLxRef(window.getOwner());
            RootPaneContainer rootPaneContainer = window instanceof RootPaneContainer ? (RootPaneContainer)((Object)window) : null;
            Container container = rootPaneContainer != null ? rootPaneContainer.getContentPane() : null;
            String creationStack = com.jetbrains.rdserver.lux.util.UtilKt.getCreationStack(container instanceof JComponent ? (JComponent)container : null);
            String string = window.getClass().getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
            LxWindowInfo info2 = new LxWindowInfo(creationStack, string);
            boolean measureShowingTime = PopupShowingTimeTracker.INSTANCE.isTrackedPopupWindow(window);
            LxWindow model2 = new LxWindow(parentRef, measureShowingTime, LuxLayoutSource.Backend, true, (LxAbstractComponentInfo)info2);
            return new LuxWindowAdapter(LuxHostService.Companion.getInstance().getLifetime(), model2, window);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

