/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.portForwarding.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.rdserver.portForwarding.utils.LsofInfoUtil;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u0005H\u0082@\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rdserver/portForwarding/utils/LsofInfoUtil;", "", "<init>", "()V", "isLsofAvailable", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getPidsUsingPort", "", "", "port", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getOutputInOneMinute", "", "command", "getOutputInNSeconds", "seconds", "", "intellij.platform.backend.split"})
@ApiStatus.Experimental
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLsofInfoUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LsofInfoUtil.kt\ncom/jetbrains/rdserver/portForwarding/utils/LsofInfoUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,110:1\n23#2:111\n23#2:112\n23#2:113\n23#2:114\n23#2:115\n23#2:116\n23#2:117\n231#3:118\n232#3:121\n1088#4,2:119\n*S KotlinDebug\n*F\n+ 1 LsofInfoUtil.kt\ncom/jetbrains/rdserver/portForwarding/utils/LsofInfoUtil\n*L\n28#1:111\n37#1:112\n42#1:113\n93#1:114\n99#1:115\n102#1:116\n105#1:117\n76#1:118\n76#1:121\n76#1:119,2\n*E\n"})
public final class LsofInfoUtil {
    @NotNull
    public static final LsofInfoUtil INSTANCE = new LsofInfoUtil();

    private LsofInfoUtil() {
    }

    /*
     * Unable to fully structure code
     */
    private final Object isLsofAvailable(Continuation<? super Boolean> $completion) {
        if (!($completion instanceof isLsofAvailable.1)) ** GOTO lbl-1000
        var9_2 = $completion;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ LsofInfoUtil this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return LsofInfoUtil.access$isLsofAvailable(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                runtime = Runtime.getRuntime();
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)runtime);
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Integer>, Object>(runtime, null){
                    int label;
                    final /* synthetic */ Runtime $runtime;
                    {
                        this.$runtime = $runtime;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                Process process2 = this.$runtime.exec("lsof -v");
                                boolean isExited = process2.waitFor(60L, TimeUnit.SECONDS);
                                if (!isExited) {
                                    boolean bl = false;
                                    String string = "lsof detection command hanged for more than 60 seconds";
                                    throw new IllegalArgumentException(string.toString());
                                }
                                return Boxing.boxInt((int)process2.exitValue());
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Integer> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v0 != var10_4) goto lbl20
lbl19:
                // 1 sources

                return var10_4;
lbl20:
                // 1 sources

                ** GOTO lbl27
            }
            case 1: {
                runtime = (Runtime)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl27:
                    // 2 sources

                    var4_7 = ((Number)v0).intValue();
                }
                catch (IOException e) {
                    $this$thisLogger$iv = this;
                    $i$f$thisLogger = false;
                    v1 = Logger.getInstance(LsofInfoUtil.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getInstance(...)");
                    v1.warn("lsof detection failed with exception", (Throwable)e);
                    var4_7 = 1;
                }
                exitValue = var4_7;
                return Boxing.boxBoolean((boolean)(exitValue == 0));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getPidsUsingPort(int port, @NotNull Continuation<? super List<Integer>> $completion) {
        if (!($completion instanceof getPidsUsingPort.1)) ** GOTO lbl-1000
        var7_3 = $completion;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                int I$0;
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ LsofInfoUtil this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getPidsUsingPort(0, (Continuation<? super List<Integer>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!SystemInfo.isLinux) {
                    $this$thisLogger$iv = this;
                    $i$f$thisLogger = false;
                    v0 = Logger.getInstance(LsofInfoUtil.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getInstance(...)");
                    v0.info("Not running Linux, will not try to detect pids using port");
                    return null;
                }
                $continuation.I$0 = port;
                $continuation.label = 1;
                v1 = this.isLsofAvailable((Continuation<? super Boolean>)$continuation);
                if (v1 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl29
            }
            case 1: {
                port = $continuation.I$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl29:
                // 2 sources

                if (!((Boolean)v1).booleanValue()) {
                    $this$thisLogger$iv = this;
                    $i$f$thisLogger = false;
                    v2 = Logger.getInstance(LsofInfoUtil.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getInstance(...)");
                    v2.info("Lsof is not available, will not try to detect pids using port");
                    return null;
                }
                command = "lsof -ni :" + port;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)command);
                $continuation.I$0 = port;
                $continuation.label = 2;
                v3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(command, null){
                    int label;
                    final /* synthetic */ String $command;
                    {
                        this.$command = $command;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                return LsofInfoUtil.access$getOutputInOneMinute(LsofInfoUtil.INSTANCE, this.$command);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v3 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl49
            }
            case 2: {
                port = $continuation.I$0;
                command = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl49:
                // 2 sources

                v4 = (String)v3;
                if (v4 == null) {
                    return null;
                }
                output = v4;
                var5_13 = new String[]{"\n"};
                return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)StringsKt.split$default((CharSequence)output, (String[])var5_13, (boolean)false, (int)0, (int)6, null)), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getPidsUsingPort$lambda$0(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Boolean;)()), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getPidsUsingPort$lambda$1(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)()), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getPidsUsingPort$lambda$2(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)()), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getPidsUsingPort$lambda$3(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Boolean;)()), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getPidsUsingPort$lambda$4(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Integer;)()));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final String getOutputInOneMinute(String command) {
        return this.getOutputInNSeconds(command, 60L);
    }

    private final String getOutputInNSeconds(String command, long seconds) {
        String string;
        Runtime runtime = Runtime.getRuntime();
        Process process2 = runtime.exec(command);
        if (!process2.waitFor(seconds, TimeUnit.SECONDS)) {
            LsofInfoUtil $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(LsofInfoUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to get " + command + " output in " + seconds + " seconds");
            string = null;
        } else {
            int exitCode = process2.exitValue();
            if (exitCode != 0) {
                LsofInfoUtil $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(LsofInfoUtil.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn(command + " exited with non-zero code " + exitCode);
            }
            byte[] byArray = process2.getInputStream().readAllBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
            String output2 = StringsKt.decodeToString((byte[])byArray);
            LsofInfoUtil $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(LsofInfoUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info(command + " output: " + output2);
            byte[] byArray2 = process2.getErrorStream().readAllBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"readAllBytes(...)");
            String errors = StringsKt.decodeToString((byte[])byArray2);
            LsofInfoUtil $this$thisLogger$iv2 = this;
            boolean $i$f$thisLogger2 = false;
            Logger logger2 = Logger.getInstance(LsofInfoUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.info(command + " stderr has length " + errors.length() + ", contents=" + errors);
            string = output2;
        }
        return string;
    }

    private static final boolean getPidsUsingPort$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.contains$default((CharSequence)it, (CharSequence)"LISTEN", (boolean)false, (int)2, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final String getPidsUsingPort$lambda$1(String it) {
        Object element$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CharSequence charSequence = it;
        Regex regex = new Regex("\\s+");
        int n = 0;
        Iterable $this$first$iv = regex.split(charSequence, n);
        boolean $i$f$first = false;
        Iterator iterator = $this$first$iv.iterator();
        do {
            if (!iterator.hasNext()) throw new NoSuchElementException("Collection contains no element matching the predicate.");
            element$iv = iterator.next();
            String column = (String)element$iv;
            boolean bl2 = false;
            if (((CharSequence)column).length() > 0) {
                boolean bl3;
                block4: {
                    CharSequence $this$all$iv = column;
                    boolean $i$f$all = false;
                    for (int i = 0; i < $this$all$iv.length(); ++i) {
                        char element$iv2;
                        char c = element$iv2 = $this$all$iv.charAt(i);
                        boolean bl4 = false;
                        if (Character.isDigit(c)) continue;
                        bl3 = false;
                        break block4;
                    }
                    bl3 = true;
                }
                if (bl3) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        return (String)element$iv;
    }

    private static final String getPidsUsingPort$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trim((CharSequence)it)).toString();
    }

    private static final boolean getPidsUsingPort$lambda$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !StringsKt.isBlank((CharSequence)it);
    }

    private static final Integer getPidsUsingPort$lambda$4(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.toIntOrNull((String)it);
    }

    public static final /* synthetic */ Object access$isLsofAvailable(LsofInfoUtil $this, Continuation $completion) {
        return $this.isLsofAvailable((Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ String access$getOutputInOneMinute(LsofInfoUtil $this, String command) {
        return $this.getOutputInOneMinute(command);
    }
}

