/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.portForwarding.utils;

import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ListeningPort;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortType;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001c\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rdserver/portForwarding/utils/PortForwardingStdoutPortListener;", "Lcom/intellij/execution/process/ProcessListener;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "onPortReady", "Lkotlin/Function1;", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/ListeningPort;", "", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lkotlin/jvm/functions/Function1;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getOnPortReady", "()Lkotlin/jvm/functions/Function1;", "listeningLocalPortRegex", "Lkotlin/text/Regex;", "lightListeningLocalPortRegex", "startNotified", "event", "Lcom/intellij/execution/process/ProcessEvent;", "processTerminated", "onTextAvailable", "outputType", "Lcom/intellij/openapi/util/Key;", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nPortForwardingStdoutPortListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PortForwardingStdoutPortListener.kt\ncom/jetbrains/rdserver/portForwarding/utils/PortForwardingStdoutPortListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,53:1\n1586#2:54\n1661#2,3:55\n1915#2,2:58\n13#3:60\n*S KotlinDebug\n*F\n+ 1 PortForwardingStdoutPortListener.kt\ncom/jetbrains/rdserver/portForwarding/utils/PortForwardingStdoutPortListener\n*L\n33#1:54\n33#1:55,3\n48#1:58,2\n16#1:60\n*E\n"})
public final class PortForwardingStdoutPortListener
implements ProcessListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Function1<ListeningPort, Unit> onPortReady;
    @NotNull
    private final Regex listeningLocalPortRegex;
    @NotNull
    private final Regex lightListeningLocalPortRegex;
    @NotNull
    private static final Logger logger;

    public PortForwardingStdoutPortListener(@NotNull Lifetime lifetime, @NotNull Function1<? super ListeningPort, Unit> onPortReady) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(onPortReady, (String)"onPortReady");
        this.lifetime = lifetime;
        this.onPortReady = onPortReady;
        this.listeningLocalPortRegex = new Regex("(https?|tcp|wss?)://(localhost|127.0.0.1|0.0.0.0):([0-9]{4,5})");
        this.lightListeningLocalPortRegex = new Regex("(localhost|127.0.0.1|0.0.0.0):([0-9]{4,5})");
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final Function1<ListeningPort, Unit> getOnPortReady() {
        return this.onPortReady;
    }

    public void startNotified(@NotNull ProcessEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    public void processTerminated(@NotNull ProcessEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    /*
     * WARNING - void declaration
     */
    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        String text = event.getText();
        Intrinsics.checkNotNull((Object)text);
        List matches = SequencesKt.toList((Sequence)Regex.findAll$default((Regex)this.listeningLocalPortRegex, (CharSequence)text, (int)0, (int)2, null));
        if (matches.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = matches;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ListeningPort listeningPort;
            Collection collection;
            block4: {
                int n;
                void it;
                MatchResult matchResult = (MatchResult)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                try {
                    n = Integer.parseInt((String)it.getGroupValues().get(3));
                }
                catch (NumberFormatException e) {
                    logger.warn("Failed to parse port from text: \"" + it.getGroupValues().get(0) + "\"");
                    listeningPort = null;
                    break block4;
                }
                int port = n;
                String networkInterface = (String)it.getGroupValues().get(2);
                PortType portType = PortType.TCP;
                listeningPort = new ListeningPort(new InetSocketAddress(networkInterface, port), portType, null);
            }
            collection.add(listeningPort);
        }
        List result = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        ApplicationKt.getApplication().invokeLater(() -> PortForwardingStdoutPortListener.onTextAvailable$lambda$1(result, this));
    }

    private static final void onTextAvailable$lambda$1(List $result, PortForwardingStdoutPortListener this$0) {
        Iterable $this$forEach$iv = $result;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ListeningPort it = (ListeningPort)element$iv;
            boolean bl = false;
            this$0.onPortReady.invoke((Object)it);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PortForwardingStdoutPortListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        PortForwardingStdoutPortListener.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdserver/portForwarding/utils/PortForwardingStdoutPortListener$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

