/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.screenForwarding.vnc;

import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.openapi.progress.ProgressIndicator;
import com.jetbrains.rd.platform.codeWithMe.util.NetUtil;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdserver.SplitBackendBundle;
import com.jetbrains.rdserver.screenForwarding.ScreenForwardingTargetEnvironmentRequestBase;
import com.jetbrains.rdserver.screenForwarding.vnc.VncScreenForwardingTargetEnvironmentConfiguration;
import com.jetbrains.rdserver.screenForwarding.vnc.VncUtilKt;
import java.net.InetAddress;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rdserver/screenForwarding/vnc/VncScreenForwardingTargetEnvironmentRequest;", "Lcom/jetbrains/rdserver/screenForwarding/ScreenForwardingTargetEnvironmentRequestBase;", "config", "Lcom/jetbrains/rdserver/screenForwarding/vnc/VncScreenForwardingTargetEnvironmentConfiguration;", "<init>", "(Lcom/jetbrains/rdserver/screenForwarding/vnc/VncScreenForwardingTargetEnvironmentConfiguration;)V", "createServerProcesses", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "freeDisplay", "", "availablePort", "screenForwardingLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "intellij.platform.backend.split"})
public final class VncScreenForwardingTargetEnvironmentRequest
extends ScreenForwardingTargetEnvironmentRequestBase {
    @NotNull
    private final VncScreenForwardingTargetEnvironmentConfiguration config;

    public VncScreenForwardingTargetEnvironmentRequest(@NotNull VncScreenForwardingTargetEnvironmentConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        this.config = config;
    }

    @Override
    @NotNull
    protected String createServerProcesses(@NotNull ProgressIndicator progressIndicator, int freeDisplay, int availablePort, @NotNull Lifetime screenForwardingLifetime) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)screenForwardingLifetime, (String)"screenForwardingLifetime");
        progressIndicator.setText(SplitBackendBundle.INSTANCE.message("screen.forwarding.starting.xpra.server", new Object[0]));
        KillableProcessHandler xvfbProcess = VncUtilKt.startXvfb(progressIndicator, freeDisplay, this.config.getScreenSize(), 10000);
        InetAddress inetAddress = InetAddress.getLoopbackAddress();
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getLoopbackAddress(...)");
        int vncFreePort = NetUtil.findFirstAvailablePort$default((NetUtil)NetUtil.INSTANCE, (InetAddress)inetAddress, (int)6800, (int)0, (int)4, null);
        KillableProcessHandler x11vncProcess = VncUtilKt.startX11Vnc(progressIndicator, freeDisplay, vncFreePort, (float)this.config.getScaleFactor(), 10000);
        KillableProcessHandler noVncProcess = VncUtilKt.startNoVnc(progressIndicator, vncFreePort, availablePort);
        KillableProcessHandler wmProcess = VncUtilKt.startWM(progressIndicator, this.config.getWindowManagerCommand(), freeDisplay);
        screenForwardingLifetime.onTermination(() -> VncScreenForwardingTargetEnvironmentRequest.createServerProcesses$lambda$0(x11vncProcess, wmProcess, xvfbProcess, noVncProcess));
        return "vnc.html?autoconnect=true&reconnect=false";
    }

    private static final Unit createServerProcesses$lambda$0(KillableProcessHandler $x11vncProcess, KillableProcessHandler $wmProcess, KillableProcessHandler $xvfbProcess, KillableProcessHandler $noVncProcess) {
        $x11vncProcess.killProcess();
        $wmProcess.killProcess();
        $xvfbProcess.killProcess();
        $noVncProcess.killProcess();
        return Unit.INSTANCE;
    }
}

