/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.rd.util.CoroutineHelpersKt;
import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.rd.framework.IRdEndpoint;
import com.jetbrains.rd.ide.model.ImageIconModel;
import com.jetbrains.rd.ide.model.ImageIconModelId;
import com.jetbrains.rd.ide.model.ImageIconSources;
import com.jetbrains.rd.ide.model.ShellModel;
import com.jetbrains.rd.protocol.RootExtListener;
import com.jetbrains.rd.ui.icons.converters.ImageIconConverter;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdserver.ui.BackendImageIconConverter;
import java.util.concurrent.ConcurrentMap;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R3\u0010\b\u001a'\u0012\u000e\u0012\f0\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\f\u0012\u000e\u0012\f0\r\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\f0\t\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rdserver/ui/BackendImageIconConverterService;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "imageIconCache", "Ljava/util/concurrent/ConcurrentMap;", "", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lcom/intellij/ui/icons/CachedImageIcon;", "loadIconSources", "Lcom/jetbrains/rd/ide/model/ImageIconSources;", "iconId", "Lcom/jetbrains/rd/ide/model/ImageIconModelId;", "cacheIcon", "", "model", "Lcom/jetbrains/rd/ide/model/ImageIconModel;", "icon", "MyProtocolListener", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendImageIconConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendImageIconConverter.kt\ncom/jetbrains/rdserver/ui/BackendImageIconConverterService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,64:1\n13#2:65\n13#2:66\n67#2,4:67\n*S KotlinDebug\n*F\n+ 1 BackendImageIconConverter.kt\ncom/jetbrains/rdserver/ui/BackendImageIconConverterService\n*L\n43#1:65\n51#1:66\n51#1:67,4\n*E\n"})
final class BackendImageIconConverterService {
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final ConcurrentMap<Long, CachedImageIcon> imageIconCache;

    public BackendImageIconConverterService(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentSoftValueMap(...)");
        this.imageIconCache = concurrentMap;
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    @Nullable
    public final ImageIconSources loadIconSources(@NotNull ImageIconModelId iconId) {
        Intrinsics.checkNotNullParameter((Object)iconId, (String)"iconId");
        CachedImageIcon iconFromCache = (CachedImageIcon)this.imageIconCache.get(iconId.getIdentity());
        if (iconFromCache != null) {
            return ImageIconConverter.Companion.createImageSources(iconId.getIdentity(), iconFromCache);
        }
        Icon iconById = ImageIconConverter.Companion.findLocalIcon(iconId);
        if (iconById instanceof CachedImageIcon && ((CachedImageIcon)iconById).getUrl() != null) {
            return ImageIconConverter.Companion.createImageSources(iconId.getIdentity(), (CachedImageIcon)iconById);
        }
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BackendImageIconConverter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("Can't find icon sources for " + iconId);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final void cacheIcon(@NotNull ImageIconModel model2, @NotNull CachedImageIcon icon2) {
        void $this$trace$iv;
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        Icon iconById = ImageIconConverter.Companion.findLocalIcon(model2.getId());
        if (iconById instanceof CachedImageIcon && ((CachedImageIcon)iconById).getUrl() != null) {
            return;
        }
        boolean $i$f$logger22 = false;
        Logger logger = Logger.getInstance(BackendImageIconConverter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger $i$f$logger22 = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            void var7_7 = $this$trace$iv;
            boolean bl = false;
            var7_7.trace("Storing icon loader for " + model2.getId());
        }
        this.imageIconCache.putIfAbsent(model2.getId().getIdentity(), icon2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rdserver/ui/BackendImageIconConverterService$MyProtocolListener;", "Lcom/jetbrains/rd/protocol/RootExtListener;", "Lcom/jetbrains/rd/ide/model/ShellModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "model", "intellij.platform.backend.split"})
    public static final class MyProtocolListener
    implements RootExtListener<ShellModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull ShellModel model2) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            CoroutineHelpersKt.setSuspendPreserveClientId$default((IRdEndpoint)((IRdEndpoint)model2.getLoadIconSources()), (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, null, null, (Function3)((Function3)new Function3<Lifetime, ImageIconModelId, Continuation<? super ImageIconSources>, Object>(model2, null){
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ ShellModel $model;
                {
                    this.$model = $model;
                    super(3, $completion);
                }

                /*
                 * WARNING - void declaration
                 */
                public final Object invokeSuspend(Object $result) {
                    ImageIconModelId imageIconModelId = (ImageIconModelId)this.L$0;
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            void iconId;
                            void $this$trace$iv;
                            ResultKt.throwOnFailure((Object)$result);
                            boolean $i$f$logger22 = false;
                            Logger logger = Logger.getInstance(BackendImageIconConverter.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                            Logger $i$f$logger22 = logger;
                            ShellModel shellModel = this.$model;
                            boolean $i$f$trace = false;
                            if ($this$trace$iv.isTraceEnabled()) {
                                void var7_8 = $this$trace$iv;
                                boolean bl = false;
                                var7_8.trace("Requested sources for " + shellModel);
                            }
                            boolean $i$f$service = false;
                            Class<BackendImageIconConverterService> serviceClass$iv = BackendImageIconConverterService.class;
                            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                            if (object == null) {
                                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                            }
                            return ((BackendImageIconConverterService)object).loadIconSources((ImageIconModelId)iconId);
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Object invoke(Lifetime p1, ImageIconModelId p2, Continuation<? super ImageIconSources> p3) {
                    var var4_4 = new /* invalid duplicate definition of identical inner class */;
                    var4_4.L$0 = p2;
                    return var4_4.invokeSuspend(Unit.INSTANCE);
                }
            }), (int)14, null);
        }
    }
}

