/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.ui.converters;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.ui.ShowingContainer;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.editor.ClientEditorManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.ide.model.uiautomation.BeIdeaEditorSettings;
import com.jetbrains.ide.model.uiautomation.BeKeyEvent;
import com.jetbrains.ide.model.uiautomation.BeKeyEventType;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdserver.ui.converters.BackendEditorCopyListener;
import com.jetbrains.rdserver.ui.converters.EditorFoldingSynchronizer;
import com.jetbrains.rdserver.ui.converters.EditorInlaySynchronizer;
import com.jetbrains.rdserver.ui.converters.EditorMarkupSynchronizer;
import java.awt.Component;
import java.awt.event.KeyEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0002\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\u0001H\u0002\u001a\u0012\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\n\u0010\u0011\u001a\u00020\u0012*\u00020\u0013\u00a8\u0006\u0014"}, d2={"copyEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "fromEditor", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "copySettings", "", "toEditor", "toBeSettings", "Lcom/jetbrains/ide/model/uiautomation/BeIdeaEditorSettings;", "toKeyEvent", "Ljava/awt/event/KeyEvent;", "Lcom/jetbrains/ide/model/uiautomation/BeKeyEvent;", "source", "Ljava/awt/Component;", "toInt", "", "Lcom/jetbrains/ide/model/uiautomation/BeKeyEventType;", "intellij.platform.backend.split"})
public final class EditorComponentImplConverterKt {
    @NotNull
    public static final EditorEx copyEditor(@NotNull ClientAppSession session, @NotNull EditorEx fromEditor, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)fromEditor, (String)"fromEditor");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        EditorImpl copyEditor = (EditorImpl)ClientId.Companion.withClientId(session.getClientId(), () -> EditorComponentImplConverterKt.copyEditor$lambda$0(fromEditor));
        ClientEditorManager.Companion.addCopiedEditor((Editor)fromEditor, (Editor)copyEditor);
        lifetime.onTermination(() -> EditorComponentImplConverterKt.copyEditor$lambda$1(session, copyEditor, fromEditor));
        copyEditor.setContextMenuGroupId(fromEditor.getContextMenuGroupId());
        copyEditor.setViewer(fromEditor.isViewer());
        EditorComponentImplConverterKt.copySettings(fromEditor, (EditorEx)copyEditor);
        new EditorMarkupSynchronizer(fromEditor, (EditorEx)copyEditor, lifetime);
        new EditorInlaySynchronizer(fromEditor, (EditorEx)copyEditor, lifetime);
        new EditorFoldingSynchronizer(fromEditor, (EditorEx)copyEditor, lifetime);
        ShowingContainer showingContainer = ShowingContainer.Companion.getInstance(fromEditor.getProject());
        if (showingContainer != null) {
            showingContainer.add((Component)copyEditor.getComponent());
        }
        ((BackendEditorCopyListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(BackendEditorCopyListener.Companion.getTOPIC())).editorCopyCreated(fromEditor, (EditorEx)copyEditor, lifetime);
        return (EditorEx)copyEditor;
    }

    private static final void copySettings(EditorEx fromEditor, EditorEx toEditor) {
        EditorSettings editorSettings = fromEditor.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"getSettings(...)");
        EditorSettings from = editorSettings;
        EditorSettings editorSettings2 = toEditor.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettings2, (String)"getSettings(...)");
        EditorSettings to = editorSettings2;
        to.setAdditionalColumnsCount(from.getAdditionalColumnsCount());
        to.setAdditionalLinesCount(from.getAdditionalLinesCount());
        to.setCaretRowShown(from.isCaretRowShown());
        to.setFoldingOutlineShown(from.isFoldingOutlineShown());
        to.setIndentGuidesShown(from.isIndentGuidesShown());
        to.setLineMarkerAreaShown(from.isLineMarkerAreaShown());
        to.setLineNumbersShown(from.isLineNumbersShown());
        to.setUseSoftWraps(from.isUseSoftWraps());
        to.setWhitespacesShown(from.isWhitespacesShown());
        to.setShowingSpecialChars(from.isShowingSpecialChars());
        to.setRightMarginShown(from.isRightMarginShown());
        to.setAdditionalPageAtBottom(from.isAdditionalPageAtBottom());
        to.setAllowSingleLogicalLineFolding(from.isAllowSingleLogicalLineFolding());
        toEditor.getGutterComponentEx().setPaintBackground(fromEditor.getGutterComponentEx().isPaintBackground());
        toEditor.setOneLineMode(fromEditor.isOneLineMode());
    }

    private static final BeIdeaEditorSettings toBeSettings(EditorEx $this$toBeSettings) {
        EditorSettings editorSettings = $this$toBeSettings.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"getSettings(...)");
        EditorSettings settings = editorSettings;
        return new BeIdeaEditorSettings(settings.getAdditionalColumnsCount(), settings.getAdditionalLinesCount(), settings.getRightMargin($this$toBeSettings.getProject()), settings.getLineCursorWidth(), settings.isCaretRowShown(), settings.isFoldingOutlineShown(), settings.isIndentGuidesShown(), settings.isLineMarkerAreaShown(), settings.isLineNumbersShown(), settings.isUseSoftWraps(), settings.isWhitespacesShown(), $this$toBeSettings.getGutterComponentEx().isPaintBackground(), settings.isShowingSpecialChars(), $this$toBeSettings.isOneLineMode(), settings.isRightMarginShown(), settings.isVirtualSpace(), settings.isWheelFontChangeEnabled(), settings.isAdditionalPageAtBottom(), $this$toBeSettings.getScrollPane().getHorizontalScrollBarPolicy() == 32 || $this$toBeSettings.getScrollPane().getHorizontalScrollBarPolicy() == 30, $this$toBeSettings.getScrollPane().getVerticalScrollBarPolicy() == 22 || $this$toBeSettings.getScrollPane().getVerticalScrollBarPolicy() == 20);
    }

    @NotNull
    public static final KeyEvent toKeyEvent(@NotNull BeKeyEvent $this$toKeyEvent, @NotNull Component source) {
        Intrinsics.checkNotNullParameter((Object)$this$toKeyEvent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return new KeyEvent(source, EditorComponentImplConverterKt.toInt($this$toKeyEvent.getType()), System.currentTimeMillis(), $this$toKeyEvent.getModifiers(), $this$toKeyEvent.getKeyCode(), $this$toKeyEvent.getKeyChar(), $this$toKeyEvent.getKeyLocation());
    }

    public static final int toInt(@NotNull BeKeyEventType $this$toInt) {
        Intrinsics.checkNotNullParameter((Object)$this$toInt, (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toInt.ordinal()]) {
            case 1 -> 400;
            case 2 -> 401;
            case 3 -> 402;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final Unit copyEditor$lambda$1$0$0(EditorImpl $copyEditor, EditorEx $fromEditor) {
        block1: {
            if (!$copyEditor.isDisposed()) {
                EditorFactory.getInstance().releaseEditor((Editor)$copyEditor);
            }
            ShowingContainer showingContainer = ShowingContainer.Companion.getInstance($fromEditor.getProject());
            if (showingContainer == null) break block1;
            showingContainer.remove((Component)$copyEditor.getComponent());
        }
        return Unit.INSTANCE;
    }

    private static final void copyEditor$lambda$1$0(ClientAppSession $session, EditorImpl $copyEditor, EditorEx $fromEditor) {
        ClientId.Companion.withExplicitClientId($session.getClientId(), () -> EditorComponentImplConverterKt.copyEditor$lambda$1$0$0($copyEditor, $fromEditor));
    }

    private static final EditorImpl copyEditor$lambda$0(EditorEx $fromEditor) {
        Editor editor = EditorFactory.getInstance().createEditor((Document)$fromEditor.getDocument(), $fromEditor.getProject(), $fromEditor.getEditorKind());
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        return (EditorImpl)editor;
    }

    private static final Unit copyEditor$lambda$1(ClientAppSession $session, EditorImpl $copyEditor, EditorEx $fromEditor) {
        UIUtil.invokeLaterIfNeeded(() -> EditorComponentImplConverterKt.copyEditor$lambda$1$0($session, $copyEditor, $fromEditor));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ BeIdeaEditorSettings access$toBeSettings(EditorEx $receiver) {
        return EditorComponentImplConverterKt.toBeSettings($receiver);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BeKeyEventType.values().length];
            try {
                nArray[BeKeyEventType.Typed.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeKeyEventType.Pressed.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeKeyEventType.Released.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

