/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.undo;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.command.impl.UndoReportHandler;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.ide.model.ReportKind;
import com.jetbrains.rdserver.undo.BackendUndoReportHost;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J7\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J*\u0010\u000f\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J*\u0010\u0010\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\"\u0010\u0011\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J*\u0010\u0014\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0015\u001a\u00020\t2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\fH\u0016J?\u0010\u0016\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u00182\r\u0010\u0015\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\u00192\u0006\u0010\u000e\u001a\u00020\u0005H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rdserver/undo/BackendUndoReportHandler;", "Lcom/intellij/openapi/command/impl/UndoReportHandler;", "<init>", "()V", "reportNonUndoable", "", "project", "Lcom/intellij/openapi/project/Project;", "operationName", "", "Lorg/jetbrains/annotations/Nls;", "problemFiles", "", "Lcom/intellij/openapi/command/undo/DocumentReference;", "isUndo", "reportClashingDocuments", "reportCannotAdjust", "reportException", "exception", "Lcom/intellij/openapi/command/undo/UnexpectedUndoException;", "reportGeneric", "message", "sendToClient", "kind", "Lcom/jetbrains/rd/ide/model/ReportKind;", "", "intellij.platform.backend.split"})
public final class BackendUndoReportHandler
implements UndoReportHandler {
    public boolean reportNonUndoable(@Nullable Project project, @NotNull String operationName, @NotNull Collection<? extends DocumentReference> problemFiles, boolean isUndo) {
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        Intrinsics.checkNotNullParameter(problemFiles, (String)"problemFiles");
        return this.sendToClient(project, ReportKind.NON_UNDOABLE, operationName, problemFiles, isUndo);
    }

    public boolean reportClashingDocuments(@Nullable Project project, @NotNull Collection<? extends DocumentReference> problemFiles, boolean isUndo) {
        Intrinsics.checkNotNullParameter(problemFiles, (String)"problemFiles");
        return this.sendToClient(project, ReportKind.CLASHING_DOCUMENTS, null, problemFiles, isUndo);
    }

    public boolean reportCannotAdjust(@Nullable Project project, @NotNull Collection<? extends DocumentReference> problemFiles, boolean isUndo) {
        Intrinsics.checkNotNullParameter(problemFiles, (String)"problemFiles");
        return this.sendToClient(project, ReportKind.CANNOT_ADJUST, null, problemFiles, isUndo);
    }

    public boolean reportException(@Nullable Project project, @NotNull UnexpectedUndoException exception, boolean isUndo) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        return this.sendToClient(project, ReportKind.EXCEPTION, exception.getMessage(), CollectionsKt.emptyList(), isUndo);
    }

    public boolean reportGeneric(@Nullable Project project, @NotNull String message, @NotNull Collection<? extends DocumentReference> problemFiles) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(problemFiles, (String)"problemFiles");
        return this.sendToClient(project, ReportKind.GENERIC, message, problemFiles, true);
    }

    private final boolean sendToClient(Project project, ReportKind kind, String message, Collection<? extends DocumentReference> problemFiles, boolean isUndo) {
        if (project == null || ClientId.Companion.isCurrentlyUnderLocalId()) {
            return false;
        }
        BackendUndoReportHost.Companion.getInstance(project).fireReport(kind, message, problemFiles, isUndo);
        return true;
    }
}

