/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.profiles;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.profiles.InlinedCountingConditionProfile;
import com.oracle.truffle.api.profiles.Profile;

public final class CountingConditionProfile
extends Profile {
    private static final CountingConditionProfile DISABLED;
    @CompilerDirectives.CompilationFinal
    private int trueCount;
    @CompilerDirectives.CompilationFinal
    private int falseCount;
    static final int MAX_VALUE = 0x3FFFFFFF;

    private CountingConditionProfile() {
    }

    public boolean profile(boolean value) {
        int t = this.trueCount;
        int f = this.falseCount;
        boolean val = value;
        if (val) {
            if (t == 0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            if (f == 0) {
                val = true;
            }
            if (CompilerDirectives.inInterpreter() && t < 0x3FFFFFFF) {
                this.trueCount = t + 1;
            }
        } else {
            if (f == 0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            if (t == 0) {
                val = false;
            }
            if (CompilerDirectives.inInterpreter() && f < 0x3FFFFFFF) {
                this.falseCount = f + 1;
            }
        }
        if (CompilerDirectives.inInterpreter()) {
            return val;
        }
        if (this == DISABLED) {
            return val;
        }
        int sum = t + f;
        return CompilerDirectives.injectBranchProbability((double)t / (double)sum, val);
    }

    @Override
    public void disable() {
        if (this.trueCount == 0) {
            this.trueCount = 1;
        }
        if (this.falseCount == 0) {
            this.falseCount = 1;
        }
    }

    @Override
    public void reset() {
        if (this == DISABLED) {
            return;
        }
        this.trueCount = 0;
        this.falseCount = 0;
    }

    int getTrueCount() {
        return this.trueCount;
    }

    int getFalseCount() {
        return this.falseCount;
    }

    public String toString() {
        if (this == DISABLED) {
            return this.toStringDisabled();
        }
        int t = this.trueCount;
        int f = this.falseCount;
        int sum = t + f;
        String details = String.format("trueProbability=%s (trueCount=%s, falseCount=%s)", (double)t / (double)sum, t, f);
        return this.toString(CountingConditionProfile.class, sum == 0, false, details);
    }

    public static CountingConditionProfile getUncached() {
        return DISABLED;
    }

    @NeverDefault
    public static CountingConditionProfile create() {
        if (CountingConditionProfile.isProfilingEnabled()) {
            return new CountingConditionProfile();
        }
        return DISABLED;
    }

    public static InlinedCountingConditionProfile inline(InlineSupport.InlineTarget target) {
        return InlinedCountingConditionProfile.inline(target);
    }

    static {
        CountingConditionProfile profile = new CountingConditionProfile();
        profile.trueCount = Integer.MAX_VALUE;
        profile.falseCount = Integer.MAX_VALUE;
        DISABLED = profile;
    }
}

