/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.frontend.split.debugger;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.platform.execution.frontend.split.debugger.ThinClientDebuggerEvaluatorKt;
import com.intellij.platform.execution.frontend.split.debugger.ThinClientNamedValue;
import com.intellij.platform.execution.frontend.split.debugger.ThinExpression;
import com.intellij.platform.execution.frontend.split.debugger.ThinExpressionKt;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.jetbrains.codeWithMe.model.GetExpressionInfoAtOffsetArg;
import com.jetbrains.codeWithMe.model.StackFrameModel;
import com.jetbrains.codeWithMe.model.ValueModel;
import com.jetbrains.rd.framework.RdTaskResult;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdTextRange;
import com.jetbrains.rd.platform.codeWithMe.PlatformSplitBundle;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.util.idea.RangeUtilKt;
import com.jetbrains.thinclient.PlatformFrontendSplitBundle;
import com.jetbrains.thinclient.services.ThinClientPermissionHost;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J.\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/platform/execution/frontend/split/debugger/ThinClientDebuggerEvaluator;", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "frameModel", "Lcom/jetbrains/codeWithMe/model/StackFrameModel;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/xdebugger/XDebugSession;Lcom/jetbrains/codeWithMe/model/StackFrameModel;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getSession", "()Lcom/intellij/xdebugger/XDebugSession;", "evaluate", "", "expression", "Lcom/intellij/xdebugger/XExpression;", "callback", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator$XEvaluationCallback;", "expressionPosition", "Lcom/intellij/xdebugger/XSourcePosition;", "", "thinExpression", "Lcom/intellij/platform/execution/frontend/split/debugger/ThinExpression;", "getExpressionInfoAtOffsetAsync", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/xdebugger/evaluation/ExpressionInfo;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "sideEffectsAllowed", "", "isEvaluationEnabled", "intellij.platform.execution.frontend.split"})
@SourceDebugExtension(value={"SMAP\nThinClientDebuggerEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThinClientDebuggerEvaluator.kt\ncom/intellij/platform/execution/frontend/split/debugger/ThinClientDebuggerEvaluator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1#2:103\n*E\n"})
public final class ThinClientDebuggerEvaluator
extends XDebuggerEvaluator {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final XDebugSession session;
    @NotNull
    private final StackFrameModel frameModel;

    public ThinClientDebuggerEvaluator(@NotNull Lifetime lifetime, @NotNull XDebugSession session, @NotNull StackFrameModel frameModel) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)frameModel, (String)"frameModel");
        this.lifetime = lifetime;
        this.session = session;
        this.frameModel = frameModel;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final XDebugSession getSession() {
        return this.session;
    }

    public void evaluate(@NotNull XExpression expression, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        if (expression instanceof ThinExpression) {
            this.evaluate((ThinExpression)expression, callback);
            ThinExpressionKt.setNew((ThinExpression)expression, false);
        } else {
            String string = expression.getExpression();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExpression(...)");
            this.evaluate(string, callback, expressionPosition);
        }
    }

    public void evaluate(@NotNull String expression, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.evaluate(new ThinExpression(expression, null, EvaluationMode.EXPRESSION), callback);
    }

    private final void evaluate(ThinExpression thinExpression, XDebuggerEvaluator.XEvaluationCallback callback) {
        if (!this.isEvaluationEnabled()) {
            callback.errorOccurred(PlatformSplitBundle.INSTANCE.message("debugger.evaluation.no.access", new Object[0]));
            return;
        }
        this.frameModel.getEvaluateExpression().start(this.lifetime, (Object)ThinClientDebuggerEvaluatorKt.toCodeWithMeEvaluateArg(thinExpression, this.session)).getResult().advise(this.lifetime, arg_0 -> ThinClientDebuggerEvaluator.evaluate$lambda$0(callback, this, arg_0));
    }

    @NotNull
    public Promise<ExpressionInfo> getExpressionInfoAtOffsetAsync(@NotNull Project project, @NotNull Document document, int offset, boolean sideEffectsAllowed) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        AsyncPromise result = new AsyncPromise();
        RdDocumentId documentId = DocumentExKt.getDocumentId((Document)document, (Project)project);
        if (documentId == null || !this.isEvaluationEnabled()) {
            result.setResult(null);
            return (Promise)result;
        }
        this.frameModel.getGetExpressionInfoAtOffset().start((Object)new GetExpressionInfoAtOffsetArg(documentId, offset, sideEffectsAllowed)).getResult().advise(this.lifetime, arg_0 -> ThinClientDebuggerEvaluator.getExpressionInfoAtOffsetAsync$lambda$0(result, arg_0));
        return (Promise)result;
    }

    private final boolean isEvaluationEnabled() {
        ThinClientPermissionHost permissionHost = ThinClientPermissionHost.Companion.getInstance();
        return permissionHost.hasWriteAccess();
    }

    private static final Unit evaluate$lambda$0(XDebuggerEvaluator.XEvaluationCallback $callback, ThinClientDebuggerEvaluator this$0, RdTaskResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        RdTaskResult rdTaskResult = result;
        if (rdTaskResult instanceof RdTaskResult.Success) {
            Lifetime lifetime = this$0.lifetime;
            XDebugSession xDebugSession = this$0.session;
            Object object = ((RdTaskResult.Success)result).getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.jetbrains.codeWithMe.model.ValueModel");
            $callback.evaluated((XValue)new ThinClientNamedValue(lifetime, xDebugSession, (ValueModel)object));
        } else if (rdTaskResult instanceof RdTaskResult.Fault) {
            $callback.errorOccurred(((RdTaskResult.Fault)result).getError().getReasonMessage());
        } else if (rdTaskResult instanceof RdTaskResult.Cancelled) {
            $callback.errorOccurred(PlatformFrontendSplitBundle.INSTANCE.message("debugger.task.canceled", new Object[0]));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit getExpressionInfoAtOffsetAsync$lambda$0(AsyncPromise $result, RdTaskResult callResult) {
        Intrinsics.checkNotNullParameter((Object)callResult, (String)"callResult");
        if (callResult instanceof RdTaskResult.Success) {
            ExpressionInfo expressionInfo;
            RdTextRange rdTextRange = (RdTextRange)((RdTaskResult.Success)callResult).getValue();
            TextRange textRange = rdTextRange != null ? RangeUtilKt.toIdeaRange((RdTextRange)rdTextRange) : null;
            AsyncPromise asyncPromise = $result;
            TextRange textRange2 = textRange;
            if (textRange2 != null) {
                void it;
                TextRange textRange3 = textRange2;
                AsyncPromise asyncPromise2 = asyncPromise;
                boolean bl = false;
                expressionInfo = new ExpressionInfo((TextRange)it, null, null, 6, null);
                asyncPromise = asyncPromise2;
            } else {
                expressionInfo = null;
            }
            asyncPromise.setResult(expressionInfo);
        } else {
            $result.setResult(null);
        }
        return Unit.INSTANCE;
    }
}

