/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.contexts.model.AnnotationSpringModelImpl;
import com.intellij.spring.contexts.model.CombinedSpringModelImpl;
import com.intellij.spring.contexts.model.SpringLocalModelUtils;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.contexts.model.XmlSpringModelImpl;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.profiles.SpringProfilesService;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringCombinedModelFactory {
    @Nullable
    public static SpringModel createModel(@Nullable SpringFileSet set, @NotNull Module module) {
        if (module == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(0);
        }
        LinkedHashSet<AnnotationSpringModelImpl> mixed = new LinkedHashSet<AnnotationSpringModelImpl>(2);
        Set<XmlFile> xmlConfigs = SpringCombinedModelFactory.getXmlConfigs(set, module.getProject());
        Set<PsiClass> codeConfigurations = SpringCombinedModelFactory.getCodeConfigs(set, module.getProject());
        if (!xmlConfigs.isEmpty()) {
            XmlSpringModel xmlModel = SpringCombinedModelFactory.createXmlModel(xmlConfigs, module, set);
            if (codeConfigurations.isEmpty()) {
                return xmlModel;
            }
            ContainerUtil.addIfNotNull(mixed, (Object)xmlModel);
        }
        if (!codeConfigurations.isEmpty()) {
            AnnotationSpringModelImpl annotationSpringModel = new AnnotationSpringModelImpl(codeConfigurations, module, set);
            if (xmlConfigs.isEmpty()) {
                return annotationSpringModel;
            }
            mixed.add(annotationSpringModel);
        }
        return new CombinedSpringModelImpl(mixed, module, set);
    }

    @NotNull
    private static Set<XmlFile> getXmlConfigs(@Nullable SpringFileSet set, @NotNull Project project) {
        if (project == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(1);
        }
        if (set == null) {
            Set<XmlFile> set2 = Collections.emptySet();
            if (set2 == null) {
                SpringCombinedModelFactory.$$$reportNull$$$0(2);
            }
            return set2;
        }
        Set files = ContainerUtil.map2LinkedSet((Collection)set.getXmlFiles(), pointer -> pointer.getFile());
        Set set3 = SpringLocalModelUtils.getXmlFiles((Project)project, (Set)files);
        if (set3 == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(3);
        }
        return set3;
    }

    @NotNull
    private static Set<PsiClass> getCodeConfigs(@Nullable SpringFileSet set, @NotNull Project project) {
        if (project == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(4);
        }
        if (set == null) {
            Set<PsiClass> set2 = Collections.emptySet();
            if (set2 == null) {
                SpringCombinedModelFactory.$$$reportNull$$$0(5);
            }
            return set2;
        }
        Set files = set.getCodeConfigurationFiles().stream().map(pointer -> pointer.getFile()).filter(Objects::nonNull).collect(Collectors.toSet());
        Set set3 = SpringLocalModelUtils.getConfigClasses((Project)project, files);
        if (set3 == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(6);
        }
        return set3;
    }

    @Nullable
    public static XmlSpringModel createXmlModel(Collection<XmlFile> configs, Module module, @NotNull Set<String> activeProfiles) {
        if (activeProfiles == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(7);
        }
        return SpringCombinedModelFactory.createXmlModel(configs, module, null, (NullableFactory<Set<String>>)((NullableFactory)() -> activeProfiles));
    }

    @Nullable
    private static XmlSpringModel createXmlModel(Collection<XmlFile> configs, @NotNull Module module, @Nullable SpringFileSet set) {
        if (module == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(8);
        }
        return SpringCombinedModelFactory.createXmlModel(configs, module, set, (NullableFactory<Set<String>>)((NullableFactory)() -> set == null ? SpringProfilesService.getInstance((Project)module.getProject()).getActiveProfiles(module) : set.getActiveProfiles()));
    }

    @Nullable
    private static XmlSpringModel createXmlModel(@NotNull Collection<XmlFile> configs, @NotNull Module module, @Nullable SpringFileSet set, final @NotNull NullableFactory<Set<String>> activeProfilesFactory) {
        if (configs == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(9);
        }
        if (module == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(10);
        }
        if (activeProfilesFactory == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(11);
        }
        LinkedHashSet<XmlFile> files = new LinkedHashSet<XmlFile>(configs.size());
        for (XmlFile psiFile : configs) {
            if (!SpringDomUtils.isSpringXml((XmlFile)psiFile)) continue;
            files.add(psiFile);
        }
        if (files.isEmpty()) {
            return null;
        }
        return new XmlSpringModelImpl(files, module, set){

            public Set<String> getActiveProfiles() {
                return (Set)activeProfilesFactory.create();
            }
        };
    }

    @Nullable
    static SpringModel createSingleModel(@NotNull PsiFile psiFile, @NotNull Module module) {
        PsiFile originalFile;
        if (psiFile == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(12);
        }
        if (module == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(13);
        }
        if ((originalFile = psiFile.getOriginalFile()) instanceof XmlFile) {
            return SpringCombinedModelFactory.createSingleXmlModel((XmlFile)originalFile, module);
        }
        if (originalFile instanceof PsiClassOwner) {
            return SpringCombinedModelFactory.createSingleAnnotationModel((PsiClassOwner)originalFile, module);
        }
        return null;
    }

    @Nullable
    private static SpringModel createSingleXmlModel(@NotNull XmlFile psiFile, @NotNull Module module) {
        if (psiFile == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(14);
        }
        if (module == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(15);
        }
        if (module.isDisposed()) {
            return null;
        }
        if (!SpringDomUtils.isSpringXml((XmlFile)psiFile)) {
            return null;
        }
        return new XmlSpringModelImpl(Collections.singleton(psiFile), module, null);
    }

    @Nullable
    private static SpringModel createSingleAnnotationModel(@NotNull PsiClassOwner psiClassOwner, @NotNull Module module) {
        Set configurations;
        if (psiClassOwner == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(16);
        }
        if (module == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(17);
        }
        if ((configurations = SpringLocalModelUtils.getConfigurationPsiClasses((PsiClassOwner)psiClassOwner)).isEmpty()) {
            return null;
        }
        return new AnnotationSpringModelImpl(configurations, module, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/impl/SpringCombinedModelFactory";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configs";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfilesFactory";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClassOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/impl/SpringCombinedModelFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlConfigs";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeConfigs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getXmlConfigs";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCodeConfigs";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createXmlModel";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createSingleModel";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createSingleXmlModel";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createSingleAnnotationModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6 -> new IllegalStateException(string);
        };
    }
}

