/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.events.annotator;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.impl.PsiTargetPresentationRenderer;
import com.intellij.microservices.jvm.gutter.DumbAwareLineMarkerUtilsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbModeBlockedFunctionality;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.semantic.SemService;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.gutter.SpringDumbModeLineMarkers;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.spring.model.events.beans.PublishEventPointDescriptor;
import com.intellij.spring.model.events.jam.SpringEventListener;
import com.intellij.spring.model.events.jam.SpringEventModelUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

final class SpringEventListenerAnnotator
extends RelatedItemLineMarkerProvider
implements DumbAware {
    SpringEventListenerAnnotator() {
    }

    public String getId() {
        return "SpringEventListenerAnnotator";
    }

    public String getName() {
        return SpringBundle.message("spring.core.event.listener.annotator.name", new Object[0]);
    }

    public Icon getIcon() {
        return SpringApiIcons.Listener;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        PsiElement first;
        if (elements == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(1);
        }
        if ((first = (PsiElement)ContainerUtil.getFirstItem(elements)) == null) {
            return;
        }
        boolean isDumb = DumbService.isDumb((Project)first.getProject());
        Module module = DumbAwareLineMarkerUtilsKt.findModuleForElement((PsiElement)first, (boolean)isDumb);
        if (isDumb) {
            SpringEventListenerAnnotator.annotateInDumbMode(module, elements, result2);
        } else {
            super.collectSlowLineMarkers(elements, result2);
        }
    }

    private static void annotateInDumbMode(@Nullable Module module, @NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        if (elements == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(3);
        }
        if (module == null || !SpringCommonUtils.isSpringConfigured((Module)module)) {
            return;
        }
        for (PsiElement psiElement : elements) {
            UClass uClass;
            UMethod uMethod;
            ProgressManager.checkCanceled();
            UElement uParent = DumbAwareLineMarkerUtilsKt.getUParentForIdentifierDumbAware((PsiElement)psiElement, (boolean)true);
            if (!(uParent instanceof UMethod) || !DumbAwareLineMarkerUtilsKt.isAnnotatedInDumbMode((UDeclaration)(uMethod = (UMethod)uParent), SpringDumbModeLineMarkers.EVENT_LISTENER_ANNOTATION_SHORTNAMES) || (uClass = UastUtils.getContainingUClass((UElement)uMethod)) == null || !DumbAwareLineMarkerUtilsKt.isAnnotatedInDumbMode((UDeclaration)uClass, SpringDumbModeLineMarkers.COMPONENT_ANNOTATION_SHORTNAMES)) continue;
            result2.add(new LineMarkerInfo(psiElement, psiElement.getTextRange(), SpringApiIcons.Gutter.Listener, e -> SpringBundle.message("spring.event.publisher.tooltip.text", new Object[0]), SpringDumbModeLineMarkers.getDumbNavigationHandler(DumbModeBlockedFunctionality.GotoEventPublisher), SpringGutterIconBuilder.DEFAULT_GUTTER_ICON_ALIGNMENT, SpringBundle.messagePointer("spring.event.publisher.tooltip.text", new Object[0])));
        }
    }

    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result2, boolean forNavigation) {
        PsiElement psiElement;
        if (elements == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(4);
        }
        if (result2 == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(5);
        }
        if ((psiElement = (PsiElement)ContainerUtil.getFirstItem(elements)) == null || !SpringCommonUtils.isSpringConfigured((Project)psiElement.getProject())) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (module != null && !SpringLibraryUtil.isAtLeastVersion((Module)module, (SpringLibraryUtil.SpringVersion)SpringLibraryUtil.SpringVersion.V_4_2)) {
            return;
        }
        super.collectNavigationMarkers(elements, result2, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result2) {
        UElement uElement;
        if (psiElement == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(6);
        }
        if (result2 == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(7);
        }
        if ((uElement = UastContextKt.toUElementOfExpectedTypes((PsiElement)psiElement, (Class[])new Class[]{UMethod.class, UCallExpression.class, UQualifiedReferenceExpression.class})) == null) {
            return;
        }
        if (uElement instanceof UMethod) {
            UMethod uMethod = (UMethod)uElement;
            PsiMethod psiMethod = (PsiMethod)UElementKt.getAsJavaPsiElement((UElement)uMethod, PsiMethod.class);
            if (psiMethod == null) {
                return;
            }
            if (psiMethod.hasModifierProperty("static") || psiMethod.isConstructor()) {
                return;
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
            if (module == null) {
                return;
            }
            SemService semService = SemService.getSemService((Project)psiElement.getProject());
            for (SpringEventListener eventListener : semService.getSemElements(SpringEventListener.EVENT_LISTENER_ROOT_JAM_KEY, (PsiElement)psiMethod)) {
                PsiElement identifier;
                PsiAnnotation psiAnnotation = eventListener.getAnnotation();
                if (psiAnnotation != null) {
                    SpringEventListenerAnnotator.annotateEventListenerMethod(() -> SpringEventModelUtils.findPublishPoints(module, eventListener), uMethod, result2);
                } else if (eventListener.getPsiElement() != null && "onApplicationEvent".equals(psiMethod.getName())) {
                    SpringEventListenerAnnotator.annotateOnApplicationEventMethod(() -> SpringEventModelUtils.findPublishPoints(module, eventListener), uMethod, result2);
                }
                PsiType returnType = SpringEventModelUtils.getEventType(psiMethod.getReturnType(), module);
                if (uMethod.getReturnTypeReference() == null || returnType == null || PsiTypes.voidType().equals((Object)returnType) || (identifier = UElementKt.getSourcePsiElement((UElement)uMethod.getUastAnchor())) == null) continue;
                SpringEventListenerAnnotator.annotatePublishPoints(module.getProject(), module, result2, returnType, identifier);
            }
        } else {
            UCallExpression callExpression = (UCallExpression)UastContextKt.toUElement((PsiElement)psiElement, UCallExpression.class);
            if (callExpression != null && callExpression.getSourcePsi() == psiElement && (SpringEventModelUtils.isPublishEventExpression(callExpression) || SpringEventModelUtils.isMulticastEventExpression(callExpression))) {
                SpringEventListenerAnnotator.annotateMethodCallExpression(callExpression, result2);
            }
        }
    }

    private static void annotateOnApplicationEventMethod(@NotNull Supplier<Collection<PublishEventPointDescriptor>> supplier, @NotNull UMethod uMethod, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result2) {
        PsiElement identifier;
        if (supplier == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(8);
        }
        if (uMethod == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(9);
        }
        if (result2 == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(10);
        }
        if ((identifier = UElementKt.getSourcePsiElement((UElement)uMethod.getUastAnchor())) == null) {
            return;
        }
        result2.add(SpringEventListenerAnnotator.createEventListenerMarker(supplier, identifier));
    }

    private static void annotateEventListenerMethod(@NotNull Supplier<Collection<PublishEventPointDescriptor>> supplier, @NotNull UMethod uMethod, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result2) {
        PsiElement identifier;
        if (supplier == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(11);
        }
        if (uMethod == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(12);
        }
        if (result2 == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(13);
        }
        if ((identifier = UElementKt.getSourcePsiElement((UElement)uMethod.getUastAnchor())) == null) {
            return;
        }
        result2.add(SpringEventListenerAnnotator.createEventListenerMarker(supplier, identifier));
    }

    private static RelatedItemLineMarkerInfo<?> createEventListenerMarker(@NotNull Supplier<Collection<PublishEventPointDescriptor>> supplier, @NotNull PsiElement identifier) {
        if (supplier == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(14);
        }
        if (identifier == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(15);
        }
        SpringGutterIconBuilder builder = SpringGutterIconBuilder.createBuilder((Icon)SpringApiIcons.Gutter.Listener, Converters.PUBLISH_EVENT_CONVERTOR, null);
        builder.setTargets(NotNullLazyValue.lazy(() -> {
            if (DumbService.isDumb((Project)identifier.getProject())) {
                return Collections.emptyList();
            }
            return (Collection)supplier.get();
        })).setPopupTitle(SpringBundle.message("spring.event.publisher.choose.title", new Object[0])).setTooltipText(SpringBundle.message("spring.event.publisher.tooltip.text", new Object[0])).setEmptyPopupText(SpringBundle.message("spring.event.publisher.empty.tooltip.text", new Object[0])).setTargetRenderer(SpringEventListenerAnnotator::getPublishEventRenderer);
        return builder.createSpringRelatedMergeableLineMarkerInfo(identifier);
    }

    private static PsiTargetPresentationRenderer<PsiElement> getPublishEventRenderer() {
        return new PsiTargetPresentationRenderer<PsiElement>(){

            protected Icon getIcon(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (UastContextKt.toUElement((PsiElement)element, UCallExpression.class) != null) {
                    return SpringApiIcons.Gutter.Publisher;
                }
                return super.getIcon(element);
            }

            public String getContainerText(@NotNull PsiElement element) {
                PsiMethod methodJavaPsi;
                PsiClass containingClass;
                UMethod uMethod;
                if (element == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (UastContextKt.toUElement((PsiElement)element, UCallExpression.class) != null && (uMethod = (UMethod)UastContextKt.getUastParentOfType((PsiElement)element, UMethod.class)) != null && (containingClass = (methodJavaPsi = uMethod.getJavaPsi()).getContainingClass()) != null) {
                    return SymbolPresentationUtil.getSymbolPresentableText((PsiElement)containingClass) + "." + SymbolPresentationUtil.getSymbolPresentableText((PsiElement)methodJavaPsi);
                }
                return super.getContainerText(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "element";
                objectArray2[1] = "com/intellij/spring/model/events/annotator/SpringEventListenerAnnotator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getIcon";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getContainerText";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    private static PsiTargetPresentationRenderer<PsiElement> getEventListenerRenderer() {
        return new PsiTargetPresentationRenderer<PsiElement>(){

            protected Icon getIcon(@NotNull PsiElement element) {
                UMethod uMethod;
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((uMethod = (UMethod)UastContextKt.toUElement((PsiElement)element, UMethod.class)) != null && uMethod.getSourcePsi() != null) {
                    return super.getIcon(uMethod.getSourcePsi());
                }
                return super.getIcon(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/events/annotator/SpringEventListenerAnnotator$2", "getIcon"));
            }
        };
    }

    private static void annotateMethodCallExpression(@NotNull UCallExpression expression, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result2) {
        PsiType publishedType;
        List expressions;
        if (expression == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(16);
        }
        if (result2 == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(17);
        }
        if (!(expressions = expression.getValueArguments()).isEmpty() && (publishedType = ((UExpression)expressions.get(0)).getExpressionType()) != null) {
            PsiElement sourcePsi = expression.getSourcePsi();
            if (sourcePsi == null) {
                return;
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)sourcePsi);
            PsiElement identifier = UElementKt.getSourcePsiElement((UElement)expression.getMethodIdentifier());
            if (identifier != null) {
                SpringEventListenerAnnotator.annotatePublishPoints(sourcePsi.getProject(), module, result2, publishedType, PsiTreeUtil.getDeepestFirst((PsiElement)identifier));
            }
        }
    }

    private static void annotatePublishPoints(@NotNull Project project, @Nullable Module module, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result2, @NotNull PsiType publishedType, @NotNull PsiElement element) {
        if (project == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(18);
        }
        if (result2 == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(19);
        }
        if (publishedType == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(20);
        }
        if (element == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(21);
        }
        SpringGutterIconBuilder builder = SpringGutterIconBuilder.createBuilder((Icon)SpringApiIcons.Gutter.Publisher, Converters.EVENT_LISTENER_CONVERTOR, null);
        builder.setTargets(NotNullLazyValue.lazy(() -> {
            if (DumbService.isDumb((Project)project)) {
                return Collections.emptyList();
            }
            return SpringEventModelUtils.getEventListeners(project, module, publishedType);
        })).setPopupTitle(SpringBundle.message("spring.event.listener.choose.title", new Object[0])).setTooltipText(SpringBundle.message("spring.event.listener.tooltip.text", new Object[0])).setEmptyPopupText(SpringBundle.message("spring.event.listener.empty.tooltip.text", new Object[0])).setTargetRenderer(SpringEventListenerAnnotator::getEventListenerRenderer);
        result2.add(builder.createSpringRelatedMergeableLineMarkerInfo(element));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uMethod";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publishedType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/events/annotator/SpringEventListenerAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectSlowLineMarkers";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateInDumbMode";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "collectNavigationMarkers";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateOnApplicationEventMethod";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateEventListenerMethod";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "createEventListenerMarker";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateMethodCallExpression";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "annotatePublishPoints";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Converters {
        static final NotNullFunction<PublishEventPointDescriptor, Collection<? extends PsiElement>> PUBLISH_EVENT_CONVERTOR = descriptor -> ContainerUtil.createMaybeSingletonList((Object)descriptor.getNavigatableElement());
        static final NotNullFunction<SpringEventListener, Collection<? extends PsiElement>> EVENT_LISTENER_CONVERTOR = descriptor -> ContainerUtil.createMaybeSingletonList((Object)descriptor.getPsiElement());

        private Converters() {
        }
    }
}

