/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven;

import com.intellij.ide.plugins.PluginManagerCoreKt;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.StringUtil;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.server.MavenServer;
import org.jetbrains.idea.maven.server.MavenServerManager;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u000bH\u0007J\u001e\u0010\r\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000e\u001a\u00020\bH\u0007J/\u0010\u000f\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012H\u0007\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/maven/MavenClasspathBuilder;", "", "<init>", "()V", "addDir", "", "classpath", "", "Ljava/nio/file/Path;", "dir", "filter", "Lkotlin/Function1;", "", "addMavenLibs", "mavenHome", "addMavenServerLibraries", "subdirs", "", "", "(Ljava/util/List;[Ljava/lang/String;)V", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenClasspathBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenClasspathBuilder.kt\norg/jetbrains/idea/maven/MavenClasspathBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,55:1\n1#2:56\n14060#3,2:57\n*S KotlinDebug\n*F\n+ 1 MavenClasspathBuilder.kt\norg/jetbrains/idea/maven/MavenClasspathBuilder\n*L\n49#1:57,2\n*E\n"})
public final class MavenClasspathBuilder {
    @NotNull
    public static final MavenClasspathBuilder INSTANCE = new MavenClasspathBuilder();

    private MavenClasspathBuilder() {
    }

    @JvmStatic
    public static final void addDir(@NotNull List<Path> classpath, @NotNull Path dir, @NotNull Function1<? super Path, Boolean> filter) {
        Intrinsics.checkNotNullParameter(classpath, (String)"classpath");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        List list = NioFiles.list((Path)dir);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"list(...)");
        List files2 = list;
        for (Path jar : files2) {
            if (!Files.isRegularFile(jar, new LinkOption[0]) || !StringsKt.endsWith$default((String)((Object)jar.getFileName()).toString(), (String)".jar", (boolean)false, (int)2, null)) continue;
            Intrinsics.checkNotNull((Object)jar);
            if (!((Boolean)filter.invoke((Object)jar)).booleanValue()) continue;
            classpath.add(jar);
        }
    }

    @JvmStatic
    public static final void addMavenLibs(@NotNull List<Path> classpath, @NotNull Path mavenHome) {
        Intrinsics.checkNotNullParameter(classpath, (String)"classpath");
        Intrinsics.checkNotNullParameter((Object)mavenHome, (String)"mavenHome");
        Path path = mavenHome.resolve("lib");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        MavenClasspathBuilder.addDir(classpath, path, (Function1<? super Path, Boolean>)((Function1)MavenClasspathBuilder::addMavenLibs$lambda$0));
        Path bootFolder = mavenHome.resolve("boot");
        List<Object> classworldsJars = NioFiles.list((Path)bootFolder).stream().filter(arg_0 -> MavenClasspathBuilder.addMavenLibs$lambda$2(MavenClasspathBuilder::addMavenLibs$lambda$1, arg_0)).toList();
        Intrinsics.checkNotNull(classworldsJars);
        classpath.addAll((Collection<Path>)classworldsJars);
    }

    @JvmStatic
    public static final void addMavenServerLibraries(@NotNull List<Path> classpath, String ... subdirs) {
        Intrinsics.checkNotNullParameter(classpath, (String)"classpath");
        Intrinsics.checkNotNullParameter((Object)subdirs, (String)"subdirs");
        Path pluginDir = PluginManagerCoreKt.getPluginDistDirByClass(MavenServerManager.class);
        if (pluginDir == null) {
            boolean $i$a$-checkNotNull-MavenClasspathBuilder$addMavenServerLibraries$22 = false;
            String $i$a$-checkNotNull-MavenClasspathBuilder$addMavenServerLibraries$22 = "Cannot resolve Maven plugin directory";
            throw new IllegalStateException($i$a$-checkNotNull-MavenClasspathBuilder$addMavenServerLibraries$22.toString());
        }
        Path libDir = pluginDir.resolve("lib");
        Path path = PathManager.getJarForClass(MavenId.class);
        Intrinsics.checkNotNull((Object)path);
        classpath.add(path);
        Path path2 = PathManager.getJarForClass(MavenServer.class);
        Intrinsics.checkNotNull((Object)path2);
        classpath.add(path2);
        classpath.add(MavenServerManager.Companion.getInstance().getMavenEventListenerPath());
        Path path3 = PathManager.getJarForClass(SpanExporter.class);
        Intrinsics.checkNotNull((Object)path3);
        classpath.add(path3);
        String[] $this$forEach$iv = subdirs;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            String element$iv;
            String it = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            Path path4 = libDir.resolve(it);
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
            MavenClasspathBuilder.addDir(classpath, path4, (Function1<? super Path, Boolean>)((Function1)MavenClasspathBuilder::addMavenServerLibraries$lambda$1$0));
        }
    }

    private static final boolean addMavenLibs$lambda$0(Path f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        return !StringsKt.contains$default((CharSequence)((Object)f.getFileName()).toString(), (CharSequence)"maven-slf4j-provider", (boolean)false, (int)2, null);
    }

    private static final boolean addMavenLibs$lambda$1(Path f) {
        Path path = f;
        Intrinsics.checkNotNull((Object)path);
        return StringUtil.contains((CharSequence)((Object)path.getFileName()).toString(), (CharSequence)"classworlds");
    }

    private static final boolean addMavenLibs$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean addMavenServerLibraries$lambda$1$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }
}

