/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.codeInsight.completion.BaseCompletionLookupArranger;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Processor;
import com.intellij.util.xml.DomElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencyManagement;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomShortArtifactCoordinates;
import org.jetbrains.idea.maven.indices.IndicesBundle;
import org.jetbrains.idea.maven.indices.MavenArtifactSearchResult;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenDependencyCompletionItem;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J(\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ*\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0007J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000fJ\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!H\u0007J\u001a\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#2\b\b\u0002\u0010$\u001a\u00020\u000fH\u0007J\u000e\u0010%\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#J\u0014\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010)H\u0007J\u000e\u0010*\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#J\u000e\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u001dJ\u0010\u0010,\u001a\u00020\u000f2\b\u0010-\u001a\u0004\u0018\u00010\u000f\u00a8\u0006."}, d2={"Lorg/jetbrains/idea/maven/dom/converters/MavenDependencyCompletionUtil;", "", "<init>", "()V", "isPlugin", "", "dependency", "Lorg/jetbrains/idea/maven/dom/model/MavenDomShortArtifactCoordinates;", "findManagedPlugin", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "domModel", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "project", "Lcom/intellij/openapi/project/Project;", "groupId", "", "artifactId", "findManagedDependency", "Lorg/jetbrains/idea/maven/dom/model/MavenDomDependency;", "isInsideManagedDependency", "invokeCompletion", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "completionType", "Lcom/intellij/codeInsight/completion/CompletionType;", "lookupElement", "Lcom/intellij/codeInsight/lookup/LookupElementBuilder;", "item", "Lorg/jetbrains/idea/maven/onlinecompletion/model/MavenDependencyCompletionItem;", "lookup", "getMaxIcon", "searchResult", "Lorg/jetbrains/idea/maven/indices/MavenArtifactSearchResult;", "info", "Lorg/jetbrains/idea/maven/onlinecompletion/model/MavenRepositoryArtifactInfo;", "presentableText", "getPresentableText", "getIcon", "Ljavax/swing/Icon;", "type", "Lorg/jetbrains/idea/maven/onlinecompletion/model/MavenDependencyCompletionItem$Type;", "getLookupString", "description", "removeDummy", "str", "intellij.maven"})
public final class MavenDependencyCompletionUtil {
    @NotNull
    public static final MavenDependencyCompletionUtil INSTANCE = new MavenDependencyCompletionUtil();

    private MavenDependencyCompletionUtil() {
    }

    public final boolean isPlugin(@NotNull MavenDomShortArtifactCoordinates dependency) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        return dependency instanceof MavenDomPlugin;
    }

    @Nullable
    public final MavenDomPlugin findManagedPlugin(@NotNull MavenDomProjectModel domModel, @NotNull Project project, @NotNull String groupId, @NotNull String artifactId) {
        Intrinsics.checkNotNullParameter((Object)domModel, (String)"domModel");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Ref ref = new Ref();
        MavenDomProjectProcessorUtils.processPluginsInPluginManagement(domModel, (Processor<? super MavenDomPlugin>)((Processor)arg_0 -> MavenDependencyCompletionUtil.findManagedPlugin$lambda$0(groupId, artifactId, ref, arg_0)), project);
        return (MavenDomPlugin)ref.get();
    }

    @JvmStatic
    @Nullable
    public static final MavenDomDependency findManagedDependency(@NotNull MavenDomProjectModel domModel, @NotNull Project project, @NotNull String groupId, @NotNull String artifactId) {
        Intrinsics.checkNotNullParameter((Object)domModel, (String)"domModel");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Ref ref = new Ref();
        MavenDomProjectProcessorUtils.processDependenciesInDependencyManagement(domModel, (Processor<? super MavenDomDependency>)((Processor)arg_0 -> MavenDependencyCompletionUtil.findManagedDependency$lambda$0(groupId, artifactId, ref, arg_0)), project);
        return (MavenDomDependency)ref.get();
    }

    @JvmStatic
    public static final boolean isInsideManagedDependency(@NotNull MavenDomShortArtifactCoordinates dependency) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        DomElement parent = dependency.getParent();
        if (!(parent instanceof MavenDomDependencies)) {
            return false;
        }
        return ((MavenDomDependencies)parent).getParent() instanceof MavenDomDependencyManagement;
    }

    @JvmStatic
    public static final void invokeCompletion(@NotNull InsertionContext context2, @NotNull CompletionType completionType) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)completionType, (String)"completionType");
        context2.setLaterRunnable(() -> MavenDependencyCompletionUtil.invokeCompletion$lambda$0(completionType, context2));
    }

    @NotNull
    public final LookupElementBuilder lookupElement(@NotNull MavenDependencyCompletionItem item, @NotNull String lookup) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((Object)item, (String)lookup).withIcon(MavenDependencyCompletionUtil.getIcon(item.getType()));
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withIcon(...)");
        return lookupElementBuilder;
    }

    @JvmStatic
    @NotNull
    public static final MavenDependencyCompletionItem getMaxIcon(@NotNull MavenArtifactSearchResult searchResult) {
        Intrinsics.checkNotNullParameter((Object)searchResult, (String)"searchResult");
        MavenDependencyCompletionItem[] mavenDependencyCompletionItemArray = searchResult.getSearchResults().getItems();
        MavenDependencyCompletionItem mavenDependencyCompletionItem = Collections.max(CollectionsKt.listOf((Object[])Arrays.copyOf(mavenDependencyCompletionItemArray, mavenDependencyCompletionItemArray.length)), Comparator.comparing(MavenDependencyCompletionUtil::getMaxIcon$lambda$0));
        Intrinsics.checkNotNullExpressionValue((Object)mavenDependencyCompletionItem, (String)"max(...)");
        return mavenDependencyCompletionItem;
    }

    @JvmOverloads
    @NotNull
    public final LookupElementBuilder lookupElement(@NotNull MavenRepositoryArtifactInfo info, @NotNull String presentableText) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)presentableText, (String)"presentableText");
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((Object)info, (String)this.getLookupString(info)).withPresentableText(presentableText);
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withPresentableText(...)");
        LookupElementBuilder elementBuilder = lookupElementBuilder;
        elementBuilder.putUserData(BaseCompletionLookupArranger.FORCE_MIDDLE_MATCH, new Object());
        if (info.getItems().length == 1) {
            LookupElementBuilder lookupElementBuilder2 = elementBuilder.withIcon(MavenDependencyCompletionUtil.getIcon(info.getItems()[0].getType()));
            Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder2, (String)"withIcon(...)");
            return lookupElementBuilder2;
        }
        return elementBuilder;
    }

    public static /* synthetic */ LookupElementBuilder lookupElement$default(MavenDependencyCompletionUtil mavenDependencyCompletionUtil, MavenRepositoryArtifactInfo mavenRepositoryArtifactInfo, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = mavenDependencyCompletionUtil.getPresentableText(mavenRepositoryArtifactInfo);
        }
        return mavenDependencyCompletionUtil.lookupElement(mavenRepositoryArtifactInfo, string);
    }

    @NotNull
    public final String getPresentableText(@NotNull MavenRepositoryArtifactInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (info.getItems().length == 1) {
            return this.getLookupString(info.getItems()[0]);
        }
        Object[] objectArray = new Object[]{info.getGroupId(), info.getArtifactId()};
        String string = IndicesBundle.message("maven.dependency.completion.presentable", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @JvmStatic
    @Nullable
    public static final Icon getIcon(@Nullable MavenDependencyCompletionItem.Type type) {
        if (type == MavenDependencyCompletionItem.Type.PROJECT) {
            return AllIcons.Nodes.Module;
        }
        return null;
    }

    @NotNull
    public final String getLookupString(@NotNull MavenRepositoryArtifactInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        MavenDependencyCompletionItem[] infoItems = info.getItems();
        if (!(infoItems.length == 0)) {
            return this.getLookupString(infoItems[0]);
        }
        return info.getGroupId() + ":" + info.getArtifactId();
    }

    @NotNull
    public final String getLookupString(@NotNull MavenDependencyCompletionItem description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        StringBuilder builder2 = new StringBuilder(description.getGroupId());
        if (description.getArtifactId() == null) {
            v0 = builder2.append(":...");
        } else {
            builder2.append(":").append(description.getArtifactId());
            if (description.getPackaging() != null) {
                builder2.append(":").append(description.getPackaging());
            }
            v0 = description.getVersion() != null ? builder2.append(":").append(description.getVersion()) : builder2.append(":...");
        }
        String string = builder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String removeDummy(@Nullable String str) {
        if (str == null) {
            return "";
        }
        String string = StringUtil.trim((String)StringsKt.replace$default((String)StringsKt.replace$default((String)str, (String)"IntellijIdeaRulezzz ", (String)"", (boolean)false, (int)4, null), (String)"IntellijIdeaRulezzz", (String)"", (boolean)false, (int)4, null));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trim(...)");
        return string;
    }

    @JvmOverloads
    @NotNull
    public final LookupElementBuilder lookupElement(@NotNull MavenRepositoryArtifactInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        return MavenDependencyCompletionUtil.lookupElement$default(this, info, null, 2, null);
    }

    private static final boolean findManagedPlugin$lambda$0(String $groupId, String $artifactId, Ref $ref, MavenDomPlugin plugin) {
        MavenDomPlugin mavenDomPlugin = plugin;
        Intrinsics.checkNotNull((Object)mavenDomPlugin);
        if (Intrinsics.areEqual((Object)$groupId, (Object)mavenDomPlugin.getGroupId().getStringValue()) && Intrinsics.areEqual((Object)$artifactId, (Object)plugin.getArtifactId().getStringValue()) && plugin.getVersion().getStringValue() != null) {
            $ref.set((Object)plugin);
            return true;
        }
        return false;
    }

    private static final boolean findManagedDependency$lambda$0(String $groupId, String $artifactId, Ref $ref, MavenDomDependency dependency) {
        MavenDomDependency mavenDomDependency = dependency;
        Intrinsics.checkNotNull((Object)mavenDomDependency);
        if (Intrinsics.areEqual((Object)$groupId, (Object)mavenDomDependency.getGroupId().getStringValue()) && Intrinsics.areEqual((Object)$artifactId, (Object)dependency.getArtifactId().getStringValue())) {
            $ref.set((Object)dependency);
            return true;
        }
        return false;
    }

    private static final void invokeCompletion$lambda$0(CompletionType $completionType, InsertionContext $context) {
        new CodeCompletionHandlerBase($completionType).invokeCompletion($context.getProject(), $context.getEditor());
    }

    private static final Integer getMaxIcon$lambda$0(MavenDependencyCompletionItem r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        if (r.getType() == null) {
            return Integer.MIN_VALUE;
        }
        MavenDependencyCompletionItem.Type type = r.getType();
        Intrinsics.checkNotNull((Object)type);
        return type.getWeight();
    }
}

