/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RemoteConnectionCreator;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.impl.SingleConfigurationConfigurable;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfile;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.ide.DataManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Transient;
import java.awt.Component;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenExternalParameters;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.execution.run.MavenCommandLineState;
import org.jetbrains.idea.maven.execution.run.MavenExtRemoteConnectionCreator;
import org.jetbrains.idea.maven.execution.run.MavenShCommandLineState;
import org.jetbrains.idea.maven.execution.run.MavenTargetShCommandLineState;
import org.jetbrains.idea.maven.execution.run.configuration.MavenRunConfigurationSettingsEditor;
import org.jetbrains.idea.maven.execution.target.MavenRuntimeTargetConfiguration;
import org.jetbrains.idea.maven.execution.target.MavenRuntimeType;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenRunConfiguration
extends LocatableConfigurationBase
implements ModuleRunProfile,
TargetEnvironmentAwareRunProfile {
    @NotNull
    private MavenSettings settings = new MavenSettings(this.getProject());

    protected MavenRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    @Nullable
    public MavenGeneralSettings getGeneralSettings() {
        return this.settings.getGeneralSettings();
    }

    public void setGeneralSettings(@Nullable MavenGeneralSettings settings) {
        this.settings.setGeneralSettings(settings);
    }

    @Nullable
    public MavenRunnerSettings getRunnerSettings() {
        return this.settings.getRunnerSettings();
    }

    public void setRunnerSettings(@Nullable MavenRunnerSettings settings) {
        this.settings.setRunnerSettings(settings);
    }

    @NotNull
    public MavenRunnerParameters getRunnerParameters() {
        MavenRunnerParameters mavenRunnerParameters = this.settings.getRunnerParameters();
        if (mavenRunnerParameters == null) {
            MavenRunConfiguration.$$$reportNull$$$0(0);
        }
        return mavenRunnerParameters;
    }

    public void setRunnerParameters(@NotNull MavenRunnerParameters parameters) {
        if (parameters == null) {
            MavenRunConfiguration.$$$reportNull$$$0(1);
        }
        this.settings.setRunnerParameters(parameters);
    }

    public MavenRunConfiguration clone() {
        MavenRunConfiguration clone = (MavenRunConfiguration)super.clone();
        clone.settings = this.settings.clone();
        clone.initializeSettings();
        return clone;
    }

    private void initializeSettings() {
        String rootProjectPath;
        if (StringUtil.isEmptyOrSpaces((String)this.settings.getRunnerParameters().getWorkingDirPath()) && (rootProjectPath = this.getRootProjectPath()) != null) {
            this.settings.getRunnerParameters().setWorkingDirPath(rootProjectPath);
        }
    }

    @Nullable
    private String getRootProjectPath() {
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.getProject());
        if (!projectsManager.isInitialized()) {
            return null;
        }
        MavenProject rootProject = (MavenProject)ContainerUtil.getFirstItem(projectsManager.getRootProjects());
        return (String)ObjectUtils.doIfNotNull((Object)rootProject, it -> it.getDirectory());
    }

    @ApiStatus.Internal
    public JavaRunConfigurationExtensionManager getExtensionsManager() {
        return JavaRunConfigurationExtensionManager.getInstance();
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditor<? extends RunConfiguration> settingsEditor = LazyEditorFactory.create(this);
        if (settingsEditor == null) {
            MavenRunConfiguration.$$$reportNull$$$0(2);
        }
        return settingsEditor;
    }

    @ApiStatus.Internal
    @Nullable
    public static String getTargetName(SettingsEditor<MavenRunConfiguration> mavenRunConfigurationSettingsEditor) {
        return (String)DataManager.getInstance().getDataContext((Component)mavenRunConfigurationSettingsEditor.getComponent()).getData(SingleConfigurationConfigurable.RUN_ON_TARGET_NAME_KEY);
    }

    public JavaParameters createJavaParameters(@NotNull Project project) throws ExecutionException {
        if (project == null) {
            MavenRunConfiguration.$$$reportNull$$$0(3);
        }
        return MavenExternalParameters.createJavaParameters(project, this.getRunnerParameters(), this.getGeneralSettings(), this.getRunnerSettings(), this);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        if (executor == null) {
            MavenRunConfiguration.$$$reportNull$$$0(4);
        }
        if (env == null) {
            MavenRunConfiguration.$$$reportNull$$$0(5);
        }
        if (Registry.is((String)"maven.use.scripts")) {
            if (env.getTargetEnvironmentRequest() instanceof LocalTargetEnvironmentRequest) {
                return new MavenShCommandLineState(env, this);
            }
            return new MavenTargetShCommandLineState(env, this);
        }
        return new MavenCommandLineState(env, this);
    }

    @NotNull
    public RemoteConnectionCreator createRemoteConnectionCreator(JavaParameters javaParameters) {
        return new MavenExtRemoteConnectionCreator(javaParameters, this);
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            MavenRunConfiguration.$$$reportNull$$$0(6);
        }
        super.readExternal(element);
        this.settings.readExternal(element);
        this.getExtensionsManager().readExternal((RunConfigurationBase)this, element);
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            MavenRunConfiguration.$$$reportNull$$$0(7);
        }
        super.writeExternal(element);
        this.settings.writeExternal(element);
        this.getExtensionsManager().writeExternal((RunConfigurationBase)this, element);
    }

    public String suggestedName() {
        return MavenRunConfigurationType.generateName(this.getProject(), this.getRunnerParameters());
    }

    public boolean canRunOn(@NotNull TargetEnvironmentConfiguration target) {
        if (target == null) {
            MavenRunConfiguration.$$$reportNull$$$0(8);
        }
        return target.getRuntimes().findByType(MavenRuntimeTargetConfiguration.class) != null;
    }

    @Nullable
    public LanguageRuntimeType<?> getDefaultLanguageRuntimeType() {
        return (LanguageRuntimeType)LanguageRuntimeType.EXTENSION_NAME.findExtension(MavenRuntimeType.class);
    }

    @Nullable
    public String getDefaultTargetName() {
        return this.getOptions().getRemoteTarget();
    }

    public void setDefaultTargetName(@Nullable String targetName) {
        this.getOptions().setRemoteTarget(targetName);
    }

    public void onNewConfigurationCreated() {
        super.onNewConfigurationCreated();
        if (!this.getName().equals(this.suggestedName())) {
            this.getOptions().setNameGenerated(false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/execution/MavenRunConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerParameters";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenRunConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setRunnerParameters";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createJavaParameters";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canRunOn";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }

    @ApiStatus.Internal
    public static class MavenSettings
    implements Cloneable {
        public static final String TAG = "MavenSettings";
        @Nullable
        public MavenGeneralSettings myGeneralSettings;
        @Nullable
        public MavenRunnerSettings myRunnerSettings;
        @Nullable
        public MavenRunnerParameters myRunnerParameters;

        public MavenSettings() {
        }

        public MavenSettings(Project project) {
            this.myRunnerParameters = new MavenRunnerParameters();
        }

        @Transient
        @Nullable
        public MavenGeneralSettings getGeneralSettings() {
            return this.myGeneralSettings;
        }

        public void setGeneralSettings(@Nullable MavenGeneralSettings generalSettings) {
            this.myGeneralSettings = generalSettings;
        }

        @Transient
        @Nullable
        public MavenRunnerSettings getRunnerSettings() {
            return this.myRunnerSettings;
        }

        public void setRunnerSettings(@Nullable MavenRunnerSettings runnerSettings) {
            this.myRunnerSettings = runnerSettings;
        }

        @Transient
        @NotNull
        public MavenRunnerParameters getRunnerParameters() {
            MavenRunnerParameters mavenRunnerParameters = Objects.requireNonNull(this.myRunnerParameters);
            if (mavenRunnerParameters == null) {
                MavenSettings.$$$reportNull$$$0(0);
            }
            return mavenRunnerParameters;
        }

        public void setRunnerParameters(@NotNull MavenRunnerParameters runnerParameters) {
            if (runnerParameters == null) {
                MavenSettings.$$$reportNull$$$0(1);
            }
            this.myRunnerParameters = runnerParameters;
        }

        protected MavenSettings clone() {
            try {
                MavenSettings clone = (MavenSettings)super.clone();
                clone.myGeneralSettings = (MavenGeneralSettings)ObjectUtils.doIfNotNull((Object)this.myGeneralSettings, MavenGeneralSettings::clone);
                clone.myRunnerSettings = (MavenRunnerSettings)ObjectUtils.doIfNotNull((Object)this.myRunnerSettings, MavenRunnerSettings::clone);
                clone.myRunnerParameters = (MavenRunnerParameters)ObjectUtils.doIfNotNull((Object)this.myRunnerParameters, MavenRunnerParameters::clone);
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new Error(e);
            }
        }

        public void readExternal(@NotNull Element element) {
            Element mavenSettingsElement;
            if (element == null) {
                MavenSettings.$$$reportNull$$$0(2);
            }
            if ((mavenSettingsElement = element.getChild(TAG)) != null) {
                MavenSettings settings = (MavenSettings)XmlSerializer.deserialize((Element)mavenSettingsElement, MavenSettings.class);
                if (settings.myRunnerParameters == null) {
                    settings.myRunnerParameters = new MavenRunnerParameters();
                }
                settings.myRunnerParameters.fixAfterLoadingFromOldFormat();
                this.myRunnerParameters = settings.myRunnerParameters;
                this.myGeneralSettings = settings.myGeneralSettings;
                this.myRunnerSettings = settings.myRunnerSettings;
            }
        }

        public void writeExternal(@NotNull Element element) throws WriteExternalException {
            if (element == null) {
                MavenSettings.$$$reportNull$$$0(3);
            }
            element.addContent(XmlSerializer.serialize((Object)this));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/maven/execution/MavenRunConfiguration$MavenSettings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnerParameters";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRunnerParameters";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenRunConfiguration$MavenSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setRunnerParameters";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "readExternal";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "writeExternal";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class LazyEditorFactory {
        private LazyEditorFactory() {
        }

        @NotNull
        static SettingsEditor<? extends RunConfiguration> create(@NotNull MavenRunConfiguration configuration) {
            if (configuration == null) {
                LazyEditorFactory.$$$reportNull$$$0(0);
            }
            return new MavenRunConfigurationSettingsEditor(configuration);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/idea/maven/execution/MavenRunConfiguration$LazyEditorFactory", "create"));
        }
    }
}

