/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.maven4;

import com.intellij.maven.server.telemetry.MavenServerTelemetryClasspathUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.text.StringUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.MavenClasspathBuilder;
import org.jetbrains.idea.maven.MavenVersionAwareSupportExtension;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.BundledMaven4;
import org.jetbrains.idea.maven.project.StaticResolvedMavenHomeType;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesCommunityRoot;
import org.jetbrains.intellij.build.impl.BundledMavenDownloader;

final class Maven4Support
implements MavenVersionAwareSupportExtension {
    @NonNls
    private static final String MAIN_CLASS40 = "com.intellij.maven.server.m40.RemoteMavenServer40";

    Maven4Support() {
    }

    @Override
    public boolean isSupportedByExtension(@NotNull Path mavenHome) {
        String version;
        if (mavenHome == null) {
            Maven4Support.$$$reportNull$$$0(0);
        }
        return StringUtil.compareVersionNumbers((String)(version = MavenUtil.getMavenVersion(mavenHome)), (String)"4") >= 0;
    }

    @Override
    @Nullable
    public Path getMavenHomeFile(@Nullable StaticResolvedMavenHomeType mavenHomeType) {
        if (mavenHomeType == null) {
            return null;
        }
        if (mavenHomeType == BundledMaven4.INSTANCE) {
            return MavenDistributionsCache.resolveEmbeddedMavenHome().getMavenHome();
        }
        return null;
    }

    @Override
    @NotNull
    public List<Path> collectClassPathAndLibsFolder(@NotNull MavenDistribution distribution) {
        if (distribution == null) {
            Maven4Support.$$$reportNull$$$0(1);
        }
        ArrayList<Path> classpath = new ArrayList<Path>();
        if (MavenUtil.isRunningFromSources()) {
            MavenLog.LOG.debug("collecting classpath for local run");
            Maven4Support.prepareClassPathForLocalRunAndUnitTests(distribution.getVersion(), classpath);
        } else {
            MavenLog.LOG.debug("collecting classpath for production");
            Maven4Support.prepareClassPathForProduction(classpath);
        }
        MavenClasspathBuilder.addMavenLibs(classpath, distribution.getMavenHome());
        MavenLog.LOG.debug("Collected classpath = ", new Object[]{classpath});
        ArrayList<Path> arrayList = classpath;
        if (arrayList == null) {
            Maven4Support.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static void prepareClassPathForProduction(List<Path> classpath) {
        MavenClasspathBuilder.addMavenServerLibraries(classpath, "intellij.maven.server4");
    }

    private static void prepareClassPathForLocalRunAndUnitTests(@NotNull String mavenVersion, List<Path> classpath) {
        if (mavenVersion == null) {
            Maven4Support.$$$reportNull$$$0(3);
        }
        BuildDependenciesCommunityRoot communityRoot = new BuildDependenciesCommunityRoot(Path.of(PathManager.getCommunityHomePath(), new String[0]));
        BundledMavenDownloader.INSTANCE.downloadMaven4LibsSync(communityRoot);
        classpath.add(PathManager.getJarForClass(MavenId.class));
        classpath.add(MavenUtil.locateModuleOutput("intellij.maven.server"));
        classpath.add(MavenUtil.locateModuleOutput("intellij.maven.server.telemetry"));
        classpath.addAll(MavenUtil.collectClasspath(MavenServerTelemetryClasspathUtil.TELEMETRY_CLASSES));
        Path parentPath = MavenUtil.getMavenPluginParentFile();
        MavenClasspathBuilder.addDir(classpath, parentPath.resolve("maven40-server-impl/lib"), (Function1<? super Path, Boolean>)((Function1)f -> true));
        classpath.add(MavenUtil.locateModuleOutput("intellij.maven.server.m40"));
    }

    @Override
    public String getMainClass(MavenDistribution distribution) {
        return MAIN_CLASS40;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenHome";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/maven4/Maven4Support";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/maven4/Maven4Support";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectClassPathAndLibsFolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedByExtension";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectClassPathAndLibsFolder";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareClassPathForLocalRunAndUnitTests";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

