/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAArtifact;
import com.intellij.openapi.externalSystem.dependency.analyzer.DADependency;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAModule;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAOmitted;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAProject;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAScope;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAWarning;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerContributor;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerDependency;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerProject;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.model.MavenArtifactState;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\r2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J,\u0010\u0017\u001a\u00020\u00072\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\r2\u0006\u0010\u001a\u001a\u00020\u00132\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0019H\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\r2\u0006\u0010\u001f\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/idea/maven/project/MavenDependencyAnalyzerContributor;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerContributor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "whenDataChanged", "", "listener", "Lkotlin/Function0;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "getProjects", "", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerProject;", "getDependencyScopes", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Scope;", "externalProject", "getDependencies", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency;", "createDependencyList", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "collectDependency", "nodes", "Lorg/jetbrains/idea/maven/model/MavenArtifactNode;", "parentDependency", "result", "", "getDependencyData", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Data;", "mavenArtifactNode", "getStatus", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Status;", "Companion", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenDependencyAnalyzerContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenDependencyAnalyzerContributor.kt\norg/jetbrains/idea/maven/project/MavenDependencyAnalyzerContributor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n1586#2:145\n1661#2,3:146\n*S KotlinDebug\n*F\n+ 1 MavenDependencyAnalyzerContributor.kt\norg/jetbrains/idea/maven/project/MavenDependencyAnalyzerContributor\n*L\n53#1:145\n53#1:146,3\n*E\n"})
public final class MavenDependencyAnalyzerContributor
implements DependencyAnalyzerContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Key<MavenId> MAVEN_ARTIFACT_ID;
    @NotNull
    private static final DAScope DEFAULT_SCOPE;
    @NotNull
    private static final List<String> STANDARD_SCOPES;

    public MavenDependencyAnalyzerContributor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public void whenDataChanged(@NotNull Function0<Unit> listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.project);
        projectsManager.addProjectsTreeListener(new MavenProjectsTree.Listener(listener2){
            final /* synthetic */ Function0<Unit> $listener;
            {
                this.$listener = $listener;
            }

            public void projectResolved(Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
                Intrinsics.checkNotNullParameter(projectWithChanges, (String)"projectWithChanges");
                this.$listener.invoke();
            }
        }, parentDisposable);
    }

    @NotNull
    public List<DependencyAnalyzerProject> getProjects() {
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(this.project);
        ArrayList<DAProject> externalProjects = new ArrayList<DAProject>();
        for (MavenProject mavenProject : mavenProjectsManager.getProjects()) {
            Module module;
            if ((Module)ActionsKt.runReadAction(() -> MavenDependencyAnalyzerContributor.getProjects$lambda$0(mavenProjectsManager, mavenProject)) == null) continue;
            externalProjects.add(new DAProject(module, mavenProject.getDisplayName()));
        }
        return externalProjects;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<DependencyAnalyzerDependency.Scope> getDependencyScopes(@NotNull DependencyAnalyzerProject externalProject) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)externalProject, (String)"externalProject");
        Iterable iterable = STANDARD_SCOPES;
        Companion companion = Companion;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(companion.scope((String)p0));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public List<DependencyAnalyzerDependency> getDependencies(@NotNull DependencyAnalyzerProject externalProject) {
        Intrinsics.checkNotNullParameter((Object)externalProject, (String)"externalProject");
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.project);
        MavenProject mavenProject = projectsManager.findProject(externalProject.getModule());
        if (mavenProject == null) {
            return CollectionsKt.emptyList();
        }
        MavenProject mavenProject2 = mavenProject;
        return this.createDependencyList(mavenProject2);
    }

    private final List<DependencyAnalyzerDependency> createDependencyList(MavenProject mavenProject) {
        DAModule root = new DAModule(mavenProject.getDisplayName());
        MavenId mavenId = mavenProject.getMavenId();
        root.putUserData(MAVEN_ARTIFACT_ID, (Object)new MavenId(mavenId.getGroupId(), mavenId.getArtifactId(), mavenId.getVersion()));
        DADependency rootDependency = new DADependency((DependencyAnalyzerDependency.Data)root, (DependencyAnalyzerDependency.Scope)DEFAULT_SCOPE, null, CollectionsKt.emptyList());
        List result = new ArrayList();
        this.collectDependency(mavenProject.getDependencyTree(), (DependencyAnalyzerDependency)rootDependency, result);
        return result;
    }

    private final void collectDependency(List<? extends MavenArtifactNode> nodes, DependencyAnalyzerDependency parentDependency, List<DependencyAnalyzerDependency> result) {
        for (MavenArtifactNode mavenArtifactNode : nodes) {
            DependencyAnalyzerDependency.Data data = this.getDependencyData(mavenArtifactNode);
            String string = mavenArtifactNode.getOriginalScope();
            if (string == null) {
                string = "compile";
            }
            DADependency dependency = new DADependency(data, (DependencyAnalyzerDependency.Scope)MavenDependencyAnalyzerContributor.Companion.scope(string), parentDependency, this.getStatus(mavenArtifactNode));
            result.add((DependencyAnalyzerDependency)dependency);
            if (mavenArtifactNode.getDependencies() == null) continue;
            List list = mavenArtifactNode.getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDependencies(...)");
            this.collectDependency(list, (DependencyAnalyzerDependency)dependency, result);
        }
    }

    private final DependencyAnalyzerDependency.Data getDependencyData(MavenArtifactNode mavenArtifactNode) {
        MavenProject mavenProject = MavenProjectsManager.getInstance(this.project).findProject(mavenArtifactNode.getArtifact());
        String string = mavenArtifactNode.getArtifact().getGroupId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGroupId(...)");
        String string2 = mavenArtifactNode.getArtifact().getArtifactId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getArtifactId(...)");
        String string3 = mavenArtifactNode.getArtifact().getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getVersion(...)");
        DAArtifact daArtifact = new DAArtifact(string, string2, string3);
        if (mavenProject != null) {
            DAModule daModule = new DAModule(mavenProject.getDisplayName());
            daModule.putUserData(MAVEN_ARTIFACT_ID, (Object)new MavenId(daArtifact.getGroupId(), daArtifact.getArtifactId(), daArtifact.getVersion()));
            return (DependencyAnalyzerDependency.Data)daModule;
        }
        return (DependencyAnalyzerDependency.Data)daArtifact;
    }

    private final List<DependencyAnalyzerDependency.Status> getStatus(MavenArtifactNode mavenArtifactNode) {
        List status = new ArrayList();
        if (mavenArtifactNode.getState() == MavenArtifactState.CONFLICT) {
            status.add(DAOmitted.INSTANCE);
            Object object = mavenArtifactNode.getRelatedArtifact();
            if (object != null && (object = object.getVersion()) != null) {
                Object object2;
                Object it = object2 = object;
                boolean bl = false;
                Object[] objectArray = new Object[]{it};
                String title = ExternalSystemBundle.message((String)"external.system.dependency.analyzer.warning.version.conflict.title", (Object[])objectArray);
                Object[] objectArray2 = new Object[]{it};
                String message = ExternalSystemBundle.message((String)"external.system.dependency.analyzer.warning.version.conflict", (Object[])objectArray2);
                Intrinsics.checkNotNull((Object)title);
                Intrinsics.checkNotNull((Object)message);
                status.add(new DAWarning(title, message));
            }
        } else if (mavenArtifactNode.getState() == MavenArtifactState.DUPLICATE) {
            status.add(DAOmitted.INSTANCE);
        }
        if (!mavenArtifactNode.getArtifact().isResolvedArtifact()) {
            String title = ExternalSystemBundle.message((String)"external.system.dependency.analyzer.warning.unresolved.title", (Object[])new Object[0]);
            String message = ExternalSystemBundle.message((String)"external.system.dependency.analyzer.warning.unresolved", (Object[])new Object[0]);
            Intrinsics.checkNotNull((Object)title);
            Intrinsics.checkNotNull((Object)message);
            status.add(new DAWarning(title, message));
        }
        return status;
    }

    private static final Module getProjects$lambda$0(MavenProjectsManager $mavenProjectsManager, MavenProject $mavenProject) {
        return $mavenProjectsManager.findModule($mavenProject);
    }

    static {
        Key key = Key.create((String)"MavenDependencyAnalyzerContributor.MavenId");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        MAVEN_ARTIFACT_ID = key;
        String string = ExternalSystemBundle.message((String)"external.system.dependency.analyzer.scope.default", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        DEFAULT_SCOPE = new DAScope(string, null, null, 6, null);
        Object[] objectArray = new String[]{"compile", "provided", "runtime", "system", "import", "test"};
        STANDARD_SCOPES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0010\u001a\u00020\n2\u000b\u0010\u0011\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000fH\u0002R\u0019\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/idea/maven/project/MavenDependencyAnalyzerContributor$Companion;", "", "<init>", "()V", "MAVEN_ARTIFACT_ID", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/idea/maven/model/MavenId;", "getMAVEN_ARTIFACT_ID", "()Lcom/intellij/openapi/util/Key;", "DEFAULT_SCOPE", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DAScope;", "getDEFAULT_SCOPE$intellij_maven", "()Lcom/intellij/openapi/externalSystem/dependency/analyzer/DAScope;", "STANDARD_SCOPES", "", "", "scope", "name", "Lorg/jetbrains/annotations/Nls;", "scopeType", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Scope$Type;", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<MavenId> getMAVEN_ARTIFACT_ID() {
            return MAVEN_ARTIFACT_ID;
        }

        @NotNull
        public final DAScope getDEFAULT_SCOPE$intellij_maven() {
            return DEFAULT_SCOPE;
        }

        private final DAScope scope(String name) {
            return new DAScope(name, null, this.scopeType(name), 2, null);
        }

        private final DependencyAnalyzerDependency.Scope.Type scopeType(String name) {
            return STANDARD_SCOPES.contains(name) ? DependencyAnalyzerDependency.Scope.Type.STANDARD : DependencyAnalyzerDependency.Scope.Type.CUSTOM;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

