/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import org.jetbrains.idea.maven.project.MavenProjectChangesBuilder;

public abstract class MavenProjectChanges {
    public static final MavenProjectChanges NONE = MavenProjectChanges.createNoneChanges();
    public static final MavenProjectChanges ALL = MavenProjectChanges.createAllChanges();

    public abstract boolean hasPackagingChanges();

    public abstract boolean hasOutputChanges();

    public abstract boolean hasSourceChanges();

    public abstract boolean hasDependencyChanges();

    public abstract boolean hasPluginsChanges();

    public abstract boolean hasPropertyChanges();

    public boolean hasChanges() {
        return this.hasPackagingChanges() || this.hasOutputChanges() || this.hasSourceChanges() || this.hasDependencyChanges() || this.hasPluginsChanges() || this.hasPropertyChanges();
    }

    private static MavenProjectChanges createNoneChanges() {
        return new MavenProjectChangesBuilder();
    }

    private static MavenProjectChanges createAllChanges() {
        MavenProjectChangesBuilder result = new MavenProjectChangesBuilder();
        result.setAllChanges(true);
        return result;
    }
}

