/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.handlers.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.codeInsight.handlers.fixers.FixersUtilKt;
import org.jetbrains.kotlin.idea.codeInsight.handlers.KotlinSmartEnterHandler;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtTypeParameterList;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/handlers/fixers/KotlinFunctionParametersFixer;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers$Fixer;", "Lorg/jetbrains/kotlin/idea/codeInsight/handlers/KotlinSmartEnterHandler;", "<init>", "()V", "apply", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "processor", "psiElement", "Lcom/intellij/psi/PsiElement;", "intellij.kotlin.base.codeInsight.minimal"})
public final class KotlinFunctionParametersFixer
extends SmartEnterProcessorWithFixers.Fixer<KotlinSmartEnterHandler> {
    public void apply(@NotNull Editor editor, @NotNull KotlinSmartEnterHandler processor, @NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)processor), (String)"processor");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        if (!(psiElement instanceof KtNamedFunction)) {
            return;
        }
        KtParameterList parameterList = ((KtNamedFunction)psiElement).getValueParameterList();
        if (parameterList == null) {
            PsiElement psiElement2 = ((KtNamedFunction)psiElement).getNameIdentifier();
            if (psiElement2 == null) {
                return;
            }
            PsiElement identifier = psiElement2;
            int n = FixersUtilKt.getEnd(FixersUtilKt.getRange(identifier));
            KtTypeParameterList ktTypeParameterList = ((KtNamedFunction)psiElement).getTypeParameterList();
            int n2 = ktTypeParameterList != null && (ktTypeParameterList = FixersUtilKt.getRange((PsiElement)ktTypeParameterList)) != null ? FixersUtilKt.getEnd((TextRange)ktTypeParameterList) : FixersUtilKt.getStart(FixersUtilKt.getRange(psiElement));
            int offset = Math.max(n, n2);
            editor.getDocument().insertString(offset, (CharSequence)"()");
            processor.registerUnresolvedError(offset + 1);
        } else {
            PsiElement psiElement3 = parameterList.getLastChild();
            if (psiElement3 == null) {
                return;
            }
            PsiElement rParen = psiElement3;
            if (!Intrinsics.areEqual((Object)")", (Object)rParen.getText())) {
                int n;
                List list = parameterList.getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParameters(...)");
                List params = list;
                if (params.isEmpty()) {
                    n = FixersUtilKt.getStart(FixersUtilKt.getRange((PsiElement)parameterList)) + 1;
                } else {
                    Object object = CollectionsKt.last((List)params);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"last(...)");
                    n = FixersUtilKt.getEnd(FixersUtilKt.getRange((PsiElement)object));
                }
                int offset = n;
                editor.getDocument().insertString(offset, (CharSequence)")");
            }
        }
    }
}

