/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.SlowOperationCanceledException;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.FList;
import com.intellij.util.ui.EDT;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SlowOperations {
    @ApiStatus.Internal
    public static final String FORBID_SLOW_OPS_PROPERTY = "intellij.idea.forbid.slow.ops";
    private static final Set<String> ourKnownIssues = ConcurrentHashMap.newKeySet();
    private static final String ERROR_EDT = "Slow operations are prohibited on EDT. See SlowOperations.assertSlowOperationsAreAllowed javadoc.";
    private static final String ERROR_RA = "Non-cancelable slow operations are prohibited inside read action. See SlowOperations.assertNonCancelableSlowOperationsAreAllowed javadoc.";
    @ApiStatus.Internal
    public static final String ACTION_UPDATE = "action.update";
    public static final String ACTION_PERFORM = "action.perform";
    private static final String KNOWN_ISSUE = "known-issues";
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final String GENERIC = "generic";
    @ApiStatus.Internal
    public static final String FORCE_ASSERT = "  force assert  ";
    @ApiStatus.Internal
    public static final String FORCE_THROW = "  force throw  ";
    @ApiStatus.Internal
    public static final String RESET = "  reset  ";
    @ApiStatus.Internal
    public static final String IDEA_PLUGIN_SANDBOX_MODE = "idea.plugin.in.sandbox.mode";
    private static int ourAlwaysAllow = -1;
    @NotNull
    private static @NotNull FList<@NotNull String> ourStack = FList.emptyList();
    private static String ourTargetClass;
    private static final Set<String> ourReportedClasses;

    private SlowOperations() {
    }

    public static void assertSlowOperationsAreAllowed() {
        if (!EDT.isCurrentThreadEdt()) {
            return;
        }
        if (SlowOperations.isAlwaysAllowed() || SlowOperations.isSlowOperationAllowed()) {
            return;
        }
        if (SlowOperations.isInSection(FORCE_THROW) && !Cancellation.isInNonCancelableSection()) {
            throw new SlowOperationCanceledException();
        }
        SlowOperations.logError(ERROR_EDT);
    }

    public static void assertNonCancelableSlowOperationsAreAllowed() {
        if (SlowOperations.isAlwaysAllowed()) {
            return;
        }
        if (EDT.isCurrentThreadEdt()) {
            if (SlowOperations.isSlowOperationAllowed()) {
                return;
            }
            SlowOperations.logError(ERROR_EDT);
        } else if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            SlowOperations.logError(ERROR_RA);
        }
    }

    private static boolean isSlowOperationAllowed() {
        String activity;
        boolean forceAssert = SlowOperations.isInSection(FORCE_ASSERT);
        if (forceAssert) {
            return false;
        }
        if (!Registry.is((String)"ide.slow.operations.assertion", (boolean)true)) {
            return true;
        }
        Application application = ApplicationManager.getApplication();
        if (application.isWriteAccessAllowed() && !Registry.is((String)"ide.slow.operations.assertion.write.action")) {
            return true;
        }
        if (ourStack.isEmpty() && !Registry.is((String)"ide.slow.operations.assertion.other", (boolean)false)) {
            return true;
        }
        Iterator iterator = ourStack.iterator();
        while (iterator.hasNext() && !RESET.equals(activity = (String)iterator.next())) {
            if (Registry.is((String)("ide.slow.operations.assertion." + activity), (boolean)true)) continue;
            return true;
        }
        return false;
    }

    private static void logError(@NotNull String message) {
        if (message == null) {
            SlowOperations.$$$reportNull$$$0(0);
        }
        if (!SlowOperations.isAlreadyReported()) {
            Holder.LOG.error(message);
        }
    }

    private static boolean isAlreadyReported() {
        if (ourTargetClass != null && !ourReportedClasses.add(ourTargetClass)) {
            return true;
        }
        Throwable throwable = new Throwable();
        return ThrowableInterner.intern((Throwable)throwable) != throwable;
    }

    @ApiStatus.Internal
    public static boolean isInSection(@NotNull String sectionName) {
        String activity;
        if (sectionName == null) {
            SlowOperations.$$$reportNull$$$0(1);
        }
        EDT.assertIsEdt();
        Iterator iterator = ourStack.iterator();
        while (iterator.hasNext() && !RESET.equals(activity = (String)iterator.next())) {
            if (!sectionName.equals(activity)) continue;
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public static boolean isAlwaysAllowed() {
        if (SystemProperties.getBooleanProperty((String)FORBID_SLOW_OPS_PROPERTY, (boolean)false)) {
            return false;
        }
        if (ourAlwaysAllow == 1) {
            return true;
        }
        if (ourAlwaysAllow == 0) {
            return false;
        }
        if (!LoadingState.APP_STARTED.isOccurred()) {
            return true;
        }
        Application application = ApplicationManager.getApplication();
        boolean result = System.getenv("TEAMCITY_VERSION") != null || application.isUnitTestMode() || application.isCommandLine() || !application.isEAP() && !application.isInternal() && !SystemProperties.getBooleanProperty((String)IDEA_PLUGIN_SANDBOX_MODE, (boolean)false);
        ourAlwaysAllow = result ? 1 : 0;
        return result;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static <T, E extends Throwable> T allowSlowOperations(@NotNull ThrowableComputable<T, E> computable) throws E {
        if (computable == null) {
            SlowOperations.$$$reportNull$$$0(2);
        }
        return (T)computable.compute();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static <E extends Throwable> void allowSlowOperations(@NotNull ThrowableRunnable<E> runnable) throws E {
        if (runnable == null) {
            SlowOperations.$$$reportNull$$$0(3);
        }
        try (AccessToken ignore = SlowOperations.startSection(GENERIC);){
            runnable.run();
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static AccessToken knownIssue(@NotNull String ytIssueId) {
        if (ytIssueId == null) {
            SlowOperations.$$$reportNull$$$0(4);
        }
        if (EDT.isCurrentThreadEdt()) {
            ourKnownIssues.add(ytIssueId);
        }
        return SlowOperations.startSection(KNOWN_ISSUE);
    }

    @ApiStatus.Internal
    @NotNull
    public static Set<String> reportKnownIssues() {
        HashSet<String> result = new HashSet<String>(ourKnownIssues);
        ourKnownIssues.clear();
        Set<String> set = result.stream().flatMap(ytCodes -> Arrays.stream(ytCodes.split(","))).map(t -> t.trim()).collect(Collectors.toSet());
        if (set == null) {
            SlowOperations.$$$reportNull$$$0(5);
        }
        return set;
    }

    @ApiStatus.Internal
    @NotNull
    public static AccessToken reportOnceIfViolatedFor(@NotNull Object target) {
        if (target == null) {
            SlowOperations.$$$reportNull$$$0(6);
        }
        if (!EDT.isCurrentThreadEdt()) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            if (accessToken == null) {
                SlowOperations.$$$reportNull$$$0(7);
            }
            return accessToken;
        }
        final String prev = ourTargetClass;
        ourTargetClass = target.getClass().getName();
        return new AccessToken(){

            public void finish() {
                ourTargetClass = prev;
            }
        };
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static AccessToken allowSlowOperations(@NotNull String activityName) {
        if (activityName == null) {
            SlowOperations.$$$reportNull$$$0(8);
        }
        return SlowOperations.startSection(activityName);
    }

    @ApiStatus.Internal
    @NotNull
    public static AccessToken startSection(@NotNull String sectionName) {
        if (sectionName == null) {
            SlowOperations.$$$reportNull$$$0(9);
        }
        if (!EDT.isCurrentThreadEdt()) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            if (accessToken == null) {
                SlowOperations.$$$reportNull$$$0(10);
            }
            return accessToken;
        }
        final FList<String> prev = ourStack;
        ourStack = prev.prepend((Object)sectionName);
        return new AccessToken(){

            public void finish() {
                ourStack = prev;
            }
        };
    }

    @ApiStatus.Internal
    public static boolean isMyMessage(@Nullable String error) {
        return Strings.areSameInstance((String)ERROR_EDT, (String)error) || Strings.areSameInstance((String)ERROR_RA, (String)error);
    }

    static {
        ourReportedClasses = new HashSet<String>();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sectionName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ytIssueId";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/SlowOperations";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/SlowOperations";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "reportKnownIssues";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "reportOnceIfViolatedFor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "startSection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "logError";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isInSection";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "allowSlowOperations";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "knownIssue";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "reportOnceIfViolatedFor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "startSection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Holder {
        private static final Logger LOG = Logger.getInstance(SlowOperations.class);

        private Holder() {
        }
    }
}

