/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.impl.TitleInfoProvider;
import com.intellij.openapi.wm.impl.simpleTitleParts.RegistryOption;
import com.intellij.openapi.wm.impl.simpleTitleParts.SimpleTitleInfoProvider;
import com.intellij.openapi.wm.impl.simpleTitleParts.TitleInfoOption;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.EDT;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J;\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2!\u0010\f\u001a\u001d\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\t0\rH\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/xdebugger/impl/ui/DebuggerTitleInfoProvider;", "Lcom/intellij/openapi/wm/impl/simpleTitleParts/SimpleTitleInfoProvider;", "<init>", "()V", "getHelper", "Lcom/intellij/xdebugger/impl/ui/DebuggerTitleInfoProvider$DebuggerTitleInfoProviderService;", "project", "Lcom/intellij/openapi/project/Project;", "addSubscription", "", "disp", "Lcom/intellij/openapi/Disposable;", "value", "Lkotlin/Function1;", "Lcom/intellij/openapi/wm/impl/TitleInfoProvider;", "Lkotlin/ParameterName;", "name", "provider", "isActive", "", "getValue", "", "updateSubscriptions", "DebuggerTitleInfoProviderService", "intellij.platform.debugger.impl"})
@SourceDebugExtension(value={"SMAP\nDebuggerTitleInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebuggerTitleInfoProvider.kt\ncom/intellij/xdebugger/impl/ui/DebuggerTitleInfoProvider\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,113:1\n30#2,2:114\n14060#3,2:116\n*S KotlinDebug\n*F\n+ 1 DebuggerTitleInfoProvider.kt\ncom/intellij/xdebugger/impl/ui/DebuggerTitleInfoProvider\n*L\n20#1:114,2\n24#1:116,2\n*E\n"})
public final class DebuggerTitleInfoProvider
extends SimpleTitleInfoProvider {
    public DebuggerTitleInfoProvider() {
        super((TitleInfoOption)new RegistryOption("ide.debug.in.title", null));
        this.getOption().setListener(() -> DebuggerTitleInfoProvider._init_$lambda$0(this));
    }

    private final DebuggerTitleInfoProviderService getHelper(Project project) {
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<DebuggerTitleInfoProviderService> serviceClass$iv = DebuggerTitleInfoProviderService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (DebuggerTitleInfoProviderService)object;
    }

    protected void addSubscription(@NotNull Project project, @NotNull Disposable disp, @NotNull Function1<? super TitleInfoProvider, Unit> value) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)disp, (String)"disp");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        super.addSubscription(project, disp, value);
        this.updateSubscriptions(project);
    }

    public boolean isActive(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.isEnabled() && this.getHelper(project).getDebuggerSessionStarted();
    }

    @NotNull
    public String getValue(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.getHelper(project).getDebuggerSessionStarted() ? "[Debugger]" : "";
    }

    private final void updateSubscriptions(Project project) {
        DebuggerTitleInfoProviderService helper = this.getHelper(project);
        helper.checkState(this);
        Disposable disposable = helper.getSubscriptionDisposable();
        if (!this.isEnabled()) {
            helper.setSubscriptionDisposable(null);
            if (disposable != null) {
                Disposer.dispose((Disposable)disposable);
            }
            return;
        }
        if (disposable == null) {
            helper.setSubscriptionDisposable(helper.addSubscription(this));
        }
    }

    private static final Unit _init_$lambda$0(DebuggerTitleInfoProvider this$0) {
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Object[] $this$forEach$iv = projectArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Project it = (Project)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this$0.updateSubscriptions(it);
        }
        this$0.updateNotify();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$isEnabled(DebuggerTitleInfoProvider $this) {
        return $this.isEnabled();
    }

    public static final /* synthetic */ void access$updateNotify(DebuggerTitleInfoProvider $this) {
        $this.updateNotify();
    }

    @Service(value={Service.Level.PROJECT})
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/intellij/xdebugger/impl/ui/DebuggerTitleInfoProvider$DebuggerTitleInfoProviderService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "debuggerSessionStarted", "", "getDebuggerSessionStarted", "()Z", "setDebuggerSessionStarted", "(Z)V", "subscriptionDisposable", "Lcom/intellij/openapi/Disposable;", "getSubscriptionDisposable", "()Lcom/intellij/openapi/Disposable;", "setSubscriptionDisposable", "(Lcom/intellij/openapi/Disposable;)V", "checkState", "", "provider", "Lcom/intellij/xdebugger/impl/ui/DebuggerTitleInfoProvider;", "addSubscription", "intellij.platform.debugger.impl"})
    private static final class DebuggerTitleInfoProviderService {
        @NotNull
        private final Project project;
        private boolean debuggerSessionStarted;
        @Nullable
        private Disposable subscriptionDisposable;

        public DebuggerTitleInfoProviderService(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        public final boolean getDebuggerSessionStarted() {
            return this.debuggerSessionStarted;
        }

        public final void setDebuggerSessionStarted(boolean bl) {
            this.debuggerSessionStarted = bl;
        }

        @Nullable
        public final Disposable getSubscriptionDisposable() {
            return this.subscriptionDisposable;
        }

        public final void setSubscriptionDisposable(@Nullable Disposable disposable) {
            this.subscriptionDisposable = disposable;
        }

        public final void checkState(@NotNull DebuggerTitleInfoProvider provider) {
            Intrinsics.checkNotNullParameter((Object)((Object)provider), (String)"provider");
            if (EDT.isCurrentThreadEdt()) {
                DebuggerTitleInfoProviderService.checkState$action(this, provider);
            } else {
                SwingUtilities.invokeLater(() -> DebuggerTitleInfoProviderService.checkState$action(this, provider));
            }
        }

        @NotNull
        public final Disposable addSubscription(@NotNull DebuggerTitleInfoProvider provider) {
            Intrinsics.checkNotNullParameter((Object)((Object)provider), (String)"provider");
            Disposable disposable = () -> DebuggerTitleInfoProviderService.addSubscription$lambda$0(this);
            Disposer.register((Disposable)((Disposable)this.project), (Disposable)disposable);
            MessageBusConnection messageBusConnection = this.project.getMessageBus().connect(disposable);
            Topic topic = XDebuggerManager.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, (Object)new XDebuggerManagerListener(this, provider){
                final /* synthetic */ DebuggerTitleInfoProviderService this$0;
                final /* synthetic */ DebuggerTitleInfoProvider $provider;
                {
                    this.this$0 = $receiver;
                    this.$provider = $provider;
                }

                public void processStarted(XDebugProcess debugProcess) {
                    Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
                    ThreadingAssertions.assertEventDispatchThread();
                    this.this$0.setDebuggerSessionStarted(true);
                    debugProcess.getSession().addSessionListener(new XDebugSessionListener(this.this$0, this.$provider){
                        final /* synthetic */ DebuggerTitleInfoProviderService this$0;
                        final /* synthetic */ DebuggerTitleInfoProvider $provider;
                        {
                            this.this$0 = $receiver;
                            this.$provider = $provider;
                        }

                        public void sessionStopped() {
                            this.this$0.checkState(this.$provider);
                        }
                    });
                }

                public void processStopped(XDebugProcess debugProcess) {
                    Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
                    this.this$0.checkState(this.$provider);
                }

                public void currentSessionChanged(XDebugSession previousSession, XDebugSession currentSession) {
                    this.this$0.checkState(this.$provider);
                }
            });
            return disposable;
        }

        /*
         * Unable to fully structure code
         */
        private static final void checkState$action(DebuggerTitleInfoProviderService this$0, DebuggerTitleInfoProvider $provider) {
            block3: {
                block2: {
                    ThreadingAssertions.assertEventDispatchThread();
                    v0 = this$0;
                    v1 = XDebuggerManager.getInstance((Project)this$0.project);
                    if (v1 == null) break block2;
                    var2_2 = v1;
                    var4_3 = v0;
                    $i$a$-let-DebuggerTitleInfoProvider$DebuggerTitleInfoProviderService$checkState$action$1 = false;
                    if (!DebuggerTitleInfoProvider.access$isEnabled($provider)) ** GOTO lbl-1000
                    v2 = it.getDebugSessions();
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getDebugSessions(...)");
                    if (((Object[])v2).length == 0 == false) {
                        v3 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = false;
                    }
                    var5_5 = v3;
                    v0 = var4_3;
                    v4 = var5_5;
                    break block3;
                }
                v4 = false;
            }
            v0.debuggerSessionStarted = v4;
            DebuggerTitleInfoProvider.access$updateNotify($provider);
        }

        private static final void addSubscription$lambda$0(DebuggerTitleInfoProviderService this$0) {
            this$0.subscriptionDisposable = null;
        }
    }
}

