/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.openapi.util.NlsSafe;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class RemoteRepositoryDescription {
    public static final RemoteRepositoryDescription MAVEN_CENTRAL = new RemoteRepositoryDescription("central", "Maven Central repository", "https://repo1.maven.org/maven2");
    public static final RemoteRepositoryDescription JBOSS_COMMUNITY = new RemoteRepositoryDescription("jboss.community", "JBoss Community repository", "https://repository.jboss.org/nexus/content/repositories/public/");
    public static final List<RemoteRepositoryDescription> DEFAULT_REPOSITORIES = List.of(MAVEN_CENTRAL, JBOSS_COMMUNITY);
    @NotNull
    private final String myId;
    @NotNull
    private final String myName;
    @NlsSafe
    @NotNull
    private final String myUrl;
    private final boolean myAllowSnapshots;

    public RemoteRepositoryDescription(@NonNls @NotNull String id, @NotNull String name, @NlsSafe @NotNull String url) {
        if (id == null) {
            RemoteRepositoryDescription.$$$reportNull$$$0(0);
        }
        if (name == null) {
            RemoteRepositoryDescription.$$$reportNull$$$0(1);
        }
        if (url == null) {
            RemoteRepositoryDescription.$$$reportNull$$$0(2);
        }
        this(id, name, url, true);
    }

    public RemoteRepositoryDescription(@NotNull String id, @NotNull String name, @NlsSafe @NotNull String url, boolean allowSnapshots) {
        if (id == null) {
            RemoteRepositoryDescription.$$$reportNull$$$0(3);
        }
        if (name == null) {
            RemoteRepositoryDescription.$$$reportNull$$$0(4);
        }
        if (url == null) {
            RemoteRepositoryDescription.$$$reportNull$$$0(5);
        }
        this.myId = id;
        this.myName = name;
        this.myUrl = url;
        this.myAllowSnapshots = allowSnapshots;
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            RemoteRepositoryDescription.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            RemoteRepositoryDescription.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            RemoteRepositoryDescription.$$$reportNull$$$0(8);
        }
        return string;
    }

    public boolean isAllowSnapshots() {
        return this.myAllowSnapshots;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteRepositoryDescription that = (RemoteRepositoryDescription)o;
        return this.myAllowSnapshots == that.myAllowSnapshots && this.myId.equals(that.myId) && this.myName.equals(that.myName) && this.myUrl.equals(that.myUrl);
    }

    public int hashCode() {
        return Objects.hash(this.myId, this.myName, this.myUrl, this.myAllowSnapshots);
    }

    public String toString() {
        return this.myId + ":" + this.myName + ":" + this.myUrl + " (snapshots=" + this.myAllowSnapshots + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jarRepository/RemoteRepositoryDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jarRepository/RemoteRepositoryDescription";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

