/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.library;

import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

record Libraries(Set<String> mavenLibraries, Map<String, String> jpsNameIndex) {
    boolean contains(@NotNull String mavenCoords) {
        if (mavenCoords == null) {
            Libraries.$$$reportNull$$$0(0);
        }
        if (this.mavenLibraries.contains(mavenCoords)) {
            return true;
        }
        if (this.jpsNameIndex.isEmpty()) {
            return false;
        }
        String libraryName = Libraries.getLibraryName(mavenCoords);
        if (libraryName == null) {
            return false;
        }
        String existingJpsLibraryName = this.jpsNameIndex.get(libraryName);
        if (existingJpsLibraryName == null) {
            return false;
        }
        return JavaLibraryUtil.matchLibraryName(existingJpsLibraryName, libraryName);
    }

    @Nullable
    private static String getLibraryName(@NotNull String mavenCoords) {
        if (mavenCoords == null) {
            Libraries.$$$reportNull$$$0(1);
        }
        return StringUtil.substringAfter((String)mavenCoords, (String)":");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "mavenCoords";
        objectArray2[1] = "com/intellij/java/library/Libraries";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getLibraryName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

