/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.run.localRun;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Arrays;

public class ScriptParser {
    private final String myPath;
    private final String myParameters;
    private final boolean myValid;

    public ScriptParser(String path, String parameters) {
        this.myPath = path;
        this.myParameters = parameters;
        this.myValid = true;
    }

    public ScriptParser(String script) {
        int scriptLength;
        for (int i = scriptLength = script.length(); i > 0; --i) {
            String path;
            File scriptFile;
            if (i != scriptLength && script.charAt(i) != ' ' || script.charAt(i - 1) == ' ' || !(scriptFile = new File(path = FileUtil.toSystemDependentName((String)script.substring(0, i)))).exists()) continue;
            this.myPath = path;
            this.myParameters = i == scriptLength ? "" : script.substring(i + 1);
            this.myValid = true;
            return;
        }
        this.myPath = script.trim();
        this.myParameters = "";
        this.myValid = false;
    }

    public String combine() {
        return StringUtil.join(Arrays.asList(this.myPath, this.myParameters), (String)" ");
    }

    public String getParameters() {
        return this.myParameters;
    }

    public String getPath() {
        return this.myPath;
    }

    public boolean isValid() {
        return this.myValid;
    }
}

