/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.searchEverywhereMl.ranking.core;

import ai.grazie.emb.FloatTextEmbedding;
import com.intellij.codeWithMe.ClientId;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereMixedListInfo;
import com.intellij.ide.actions.searcheverywhere.SearchRestartReason;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.searchEverywhereMl.SearchEverywhereTab;
import com.intellij.searchEverywhereMl.SearchEverywhereTabKt;
import com.intellij.searchEverywhereMl.TextEmbeddingProvider;
import com.intellij.searchEverywhereMl.ranking.core.SearchEverywhereFoundElementInfoWithMl;
import com.intellij.searchEverywhereMl.ranking.core.SearchEverywhereMLContextInfo;
import com.intellij.searchEverywhereMl.ranking.core.SearchEverywhereMLStatisticsCollector;
import com.intellij.searchEverywhereMl.ranking.core.SearchEverywhereMlSearchState;
import com.intellij.searchEverywhereMl.ranking.core.features.FeaturesProviderCache;
import com.intellij.searchEverywhereMl.ranking.core.features.FeaturesProviderCacheDataProvider;
import com.intellij.searchEverywhereMl.ranking.core.features.statistician.SearchEverywhereContributorStatisticianKt;
import com.intellij.searchEverywhereMl.ranking.core.features.statistician.SearchEverywhereStatisticianService;
import com.intellij.searchEverywhereMl.ranking.core.id.MissingKeyProviderCollector;
import com.intellij.searchEverywhereMl.ranking.core.id.SearchEverywhereMlOrderedItemIdProvider;
import com.intellij.searchEverywhereMl.ranking.core.model.SearchEverywhereModelProvider;
import com.intellij.searchEverywhereMl.ranking.core.performance.PerformanceTracker;
import com.intellij.searchEverywhereMl.ranking.core.utils.NaturalLanguageKt;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001aJN\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020.2\u0006\u0010+\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u001a2\f\u00102\u001a\b\u0012\u0004\u0012\u000204032\b\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u000208J*\u00109\u001a\u00020*2\u0006\u0010:\u001a\u00020;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u0001032\f\u00102\u001a\b\u0012\u0004\u0012\u00020403J\u0014\u0010=\u001a\u00020*2\f\u00102\u001a\b\u0012\u0004\u0012\u00020403J\u0006\u0010>\u001a\u00020*J\b\u0010?\u001a\u0004\u0018\u00010$J\u0018\u0010@\u001a\u0004\u0018\u00010\u001d2\u0006\u00101\u001a\u00020\u001a2\u0006\u0010A\u001a\u000208R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R3\u0010\u0018\u001a'\u0012\u000e\u0012\f0\u001a\u00a2\u0006\u0002\b\u001b\u00a2\u0006\u0002\b\u001c\u0012\u000e\u0012\f0\u001d\u00a2\u0006\u0002\b\u001b\u00a2\u0006\u0002\b\u001c0\u0019\u00a2\u0006\u0002\b\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0016\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010$0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/intellij/searchEverywhereMl/ranking/core/SearchEverywhereMLSearchSession;", "", "project", "Lcom/intellij/openapi/project/Project;", "mixedListInfo", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereMixedListInfo;", "sessionId", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereMixedListInfo;I)V", "getMixedListInfo", "()Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereMixedListInfo;", "itemIdProvider", "Lcom/intellij/searchEverywhereMl/ranking/core/id/SearchEverywhereMlOrderedItemIdProvider;", "getItemIdProvider", "()Lcom/intellij/searchEverywhereMl/ranking/core/id/SearchEverywhereMlOrderedItemIdProvider;", "sessionStartTime", "", "getSessionStartTime", "()J", "providersCache", "Lcom/intellij/searchEverywhereMl/ranking/core/features/FeaturesProviderCache;", "modelProviderWithCache", "Lcom/intellij/searchEverywhereMl/ranking/core/model/SearchEverywhereModelProvider;", "embeddingCache", "Ljava/util/concurrent/ConcurrentMap;", "", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lai/grazie/emb/FloatTextEmbedding;", "cachedContextInfo", "Lcom/intellij/searchEverywhereMl/ranking/core/SearchEverywhereMLContextInfo;", "getCachedContextInfo", "()Lcom/intellij/searchEverywhereMl/ranking/core/SearchEverywhereMLContextInfo;", "currentSearchState", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/searchEverywhereMl/ranking/core/SearchEverywhereMlSearchState;", "logger", "Lcom/intellij/searchEverywhereMl/ranking/core/SearchEverywhereMLStatisticsCollector;", "performanceTracker", "Lcom/intellij/searchEverywhereMl/ranking/core/performance/PerformanceTracker;", "onSessionStarted", "", "tabId", "onSearchRestart", "reason", "Lcom/intellij/ide/actions/searcheverywhere/SearchRestartReason;", "keysTyped", "backspacesTyped", "searchQuery", "searchResults", "", "Lcom/intellij/searchEverywhereMl/ranking/core/SearchEverywhereFoundElementInfoWithMl;", "searchScope", "Lcom/intellij/ide/util/scopeChooser/ScopeDescriptor;", "isSearchEverywhere", "", "onItemSelected", "indexes", "", "selectedItems", "onSearchFinished", "notifySearchResultsUpdated", "getCurrentSearchState", "getSearchQueryEmbedding", "split", "intellij.searchEverywhereMl.ranking.core"})
@SourceDebugExtension(value={"SMAP\nSearchEverywhereMLSearchSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchEverywhereMLSearchSession.kt\ncom/intellij/searchEverywhereMl/ranking/core/SearchEverywhereMLSearchSession\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,152:1\n42#2,3:153\n1915#3,2:156\n1915#3,2:158\n14081#4,2:160\n1#5:162\n*S KotlinDebug\n*F\n+ 1 SearchEverywhereMLSearchSession.kt\ncom/intellij/searchEverywhereMl/ranking/core/SearchEverywhereMLSearchSession\n*L\n99#1:153,3\n100#1:156,2\n105#1:158,2\n108#1:160,2\n*E\n"})
public final class SearchEverywhereMLSearchSession {
    @Nullable
    private final Project project;
    @NotNull
    private final SearchEverywhereMixedListInfo mixedListInfo;
    private final int sessionId;
    @NotNull
    private final SearchEverywhereMlOrderedItemIdProvider itemIdProvider;
    private final long sessionStartTime;
    @Nullable
    private final FeaturesProviderCache providersCache;
    @NotNull
    private final SearchEverywhereModelProvider modelProviderWithCache;
    @NotNull
    private final ConcurrentMap<String, FloatTextEmbedding> embeddingCache;
    @NotNull
    private final SearchEverywhereMLContextInfo cachedContextInfo;
    @NotNull
    private final AtomicReference<SearchEverywhereMlSearchState> currentSearchState;
    @NotNull
    private final SearchEverywhereMLStatisticsCollector logger;
    @NotNull
    private final PerformanceTracker performanceTracker;

    public SearchEverywhereMLSearchSession(@Nullable Project project, @NotNull SearchEverywhereMixedListInfo mixedListInfo, int sessionId) {
        Intrinsics.checkNotNullParameter((Object)mixedListInfo, (String)"mixedListInfo");
        this.project = project;
        this.mixedListInfo = mixedListInfo;
        this.sessionId = sessionId;
        this.itemIdProvider = new SearchEverywhereMlOrderedItemIdProvider((Function1<Object, Unit>)((Function1)SearchEverywhereMLSearchSession::itemIdProvider$lambda$0));
        this.sessionStartTime = System.currentTimeMillis();
        this.providersCache = new FeaturesProviderCacheDataProvider().getDataToCache(this.project);
        this.modelProviderWithCache = new SearchEverywhereModelProvider();
        ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentMap(...)");
        this.embeddingCache = concurrentMap;
        this.cachedContextInfo = new SearchEverywhereMLContextInfo(this.project);
        this.currentSearchState = new AtomicReference();
        this.logger = SearchEverywhereMLStatisticsCollector.INSTANCE;
        this.performanceTracker = new PerformanceTracker();
    }

    @NotNull
    public final SearchEverywhereMixedListInfo getMixedListInfo() {
        return this.mixedListInfo;
    }

    @NotNull
    public final SearchEverywhereMlOrderedItemIdProvider getItemIdProvider() {
        return this.itemIdProvider;
    }

    public final long getSessionStartTime() {
        return this.sessionStartTime;
    }

    @NotNull
    public final SearchEverywhereMLContextInfo getCachedContextInfo() {
        return this.cachedContextInfo;
    }

    public final void onSessionStarted(@NotNull String tabId) {
        Intrinsics.checkNotNullParameter((Object)tabId, (String)"tabId");
        SearchEverywhereTab tab = SearchEverywhereTab.Companion.getById(tabId);
        this.logger.onSessionStarted$intellij_searchEverywhereMl_ranking_core(this.project, this.sessionId, tab, this.sessionStartTime, this.cachedContextInfo.getFeatures(), this.mixedListInfo);
    }

    public final void onSearchRestart(@NotNull SearchRestartReason reason, @NotNull String tabId, int keysTyped, int backspacesTyped, @NotNull String searchQuery, @NotNull List<? extends SearchEverywhereFoundElementInfoWithMl> searchResults, @Nullable ScopeDescriptor searchScope, boolean isSearchEverywhere) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Intrinsics.checkNotNullParameter((Object)tabId, (String)"tabId");
        Intrinsics.checkNotNullParameter((Object)searchQuery, (String)"searchQuery");
        Intrinsics.checkNotNullParameter(searchResults, (String)"searchResults");
        SearchEverywhereTab tab = SearchEverywhereTab.Companion.getById(tabId);
        int prevTimeToResult = this.performanceTracker.getTimeElapsed();
        SearchEverywhereMlSearchState prevState = this.currentSearchState.getAndUpdate(arg_0 -> SearchEverywhereMLSearchSession.onSearchRestart$lambda$0(reason, this, tab, searchScope, isSearchEverywhere, keysTyped, backspacesTyped, searchQuery, arg_0));
        if (prevState != null && SearchEverywhereTabKt.isLoggingEnabled((SearchEverywhereTab)prevState.getTab())) {
            this.logger.onSearchRestarted$intellij_searchEverywhereMl_ranking_core(this.project, this.sessionId, prevState, this.mixedListInfo, searchResults, prevTimeToResult);
        }
    }

    public final void onItemSelected(@NotNull int[] indexes, @NotNull List<? extends Object> selectedItems, @NotNull List<? extends SearchEverywhereFoundElementInfoWithMl> searchResults) {
        Object it;
        Object element$iv;
        Intrinsics.checkNotNullParameter((Object)indexes, (String)"indexes");
        Intrinsics.checkNotNullParameter(selectedItems, (String)"selectedItems");
        Intrinsics.checkNotNullParameter(searchResults, (String)"searchResults");
        SearchEverywhereMlSearchState searchEverywhereMlSearchState = this.getCurrentSearchState();
        if (searchEverywhereMlSearchState == null) {
            return;
        }
        SearchEverywhereMlSearchState state = searchEverywhereMlSearchState;
        if (!SearchEverywhereTabKt.isLoggingEnabled((SearchEverywhereTab)state.getTab())) {
            return;
        }
        boolean $i$f$service = false;
        Class<SearchEverywhereStatisticianService> serviceClass$iv = SearchEverywhereStatisticianService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        SearchEverywhereStatisticianService statisticianService = (SearchEverywhereStatisticianService)object;
        Object $this$forEach$iv = selectedItems;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            it = element$iv = iterator.next();
            boolean bl = false;
            statisticianService.increaseUseCount(it);
        }
        if (Intrinsics.areEqual((Object)state.getTab(), (Object)SearchEverywhereTab.All.INSTANCE)) {
            $this$forEach$iv = CollectionsKt.slice(searchResults, (Iterable)ArraysKt.asIterable((int[])indexes));
            $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                it = (SearchEverywhereFoundElementInfoWithMl)((Object)element$iv);
                boolean bl = false;
                String string = ((SearchEverywhereFoundElementInfoWithMl)((Object)it)).contributor.getSearchProviderId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSearchProviderId(...)");
                SearchEverywhereContributorStatisticianKt.increaseContributorUseCount(string);
            }
        }
        $this$forEach$iv = indexes;
        $i$f$forEach = false;
        int n = ((Object)$this$forEach$iv).length;
        for (int i = 0; i < n; ++i) {
            Object element$iv2;
            Object selectedIndex = element$iv2 = $this$forEach$iv[i];
            boolean bl = false;
            this.logger.onItemSelected$intellij_searchEverywhereMl_ranking_core(this.project, this.sessionId, state.getIndex(), (int)selectedIndex);
        }
    }

    public final void onSearchFinished(@NotNull List<? extends SearchEverywhereFoundElementInfoWithMl> searchResults) {
        Intrinsics.checkNotNullParameter(searchResults, (String)"searchResults");
        SearchEverywhereMlSearchState searchEverywhereMlSearchState = this.getCurrentSearchState();
        if (searchEverywhereMlSearchState == null) {
            return;
        }
        SearchEverywhereMlSearchState state = searchEverywhereMlSearchState;
        long sessionEndTime = System.currentTimeMillis();
        int sessionDuration = (int)(sessionEndTime - this.sessionStartTime);
        if (SearchEverywhereTabKt.isLoggingEnabled((SearchEverywhereTab)state.getTab())) {
            this.logger.onSearchRestarted$intellij_searchEverywhereMl_ranking_core(this.project, this.sessionId, state, this.mixedListInfo, searchResults, this.performanceTracker.getTimeElapsed());
        }
        this.logger.onSessionFinished$intellij_searchEverywhereMl_ranking_core(this.project, this.sessionId, state.getTab(), sessionDuration);
        MissingKeyProviderCollector.INSTANCE.report(this.sessionId);
    }

    public final void notifySearchResultsUpdated() {
        this.performanceTracker.stop();
    }

    @Nullable
    public final SearchEverywhereMlSearchState getCurrentSearchState() {
        return this.currentSearchState.get();
    }

    @Nullable
    public final FloatTextEmbedding getSearchQueryEmbedding(@NotNull String searchQuery, boolean split) {
        Intrinsics.checkNotNullParameter((Object)searchQuery, (String)"searchQuery");
        FloatTextEmbedding floatTextEmbedding = (FloatTextEmbedding)this.embeddingCache.get(searchQuery);
        if (floatTextEmbedding == null) {
            FloatTextEmbedding floatTextEmbedding2;
            TextEmbeddingProvider textEmbeddingProvider = TextEmbeddingProvider.Companion.getProvider();
            if (textEmbeddingProvider != null && (floatTextEmbedding2 = textEmbeddingProvider.embed(split ? NaturalLanguageKt.convertNameToNaturalLanguage(searchQuery) : searchQuery)) != null) {
                FloatTextEmbedding floatTextEmbedding3;
                FloatTextEmbedding it = floatTextEmbedding3 = floatTextEmbedding2;
                boolean bl = false;
                ((Map)this.embeddingCache).put(searchQuery, it);
                floatTextEmbedding = floatTextEmbedding3;
            } else {
                floatTextEmbedding = null;
            }
        }
        return floatTextEmbedding;
    }

    private static final Unit itemIdProvider$lambda$0(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        MissingKeyProviderCollector.INSTANCE.addMissingProviderForClass(it.getClass());
        return Unit.INSTANCE;
    }

    private static final SearchEverywhereMlSearchState onSearchRestart$lambda$0(SearchRestartReason $reason, SearchEverywhereMLSearchSession this$0, SearchEverywhereTab $tab, ScopeDescriptor $searchScope, boolean $isSearchEverywhere, int $keysTyped, int $backspacesTyped, String $searchQuery, SearchEverywhereMlSearchState prevState) {
        SearchRestartReason searchReason = prevState == null ? SearchRestartReason.SEARCH_STARTED : $reason;
        SearchEverywhereMlSearchState searchEverywhereMlSearchState = prevState;
        int nextSearchIndex = (searchEverywhereMlSearchState != null ? searchEverywhereMlSearchState.getIndex() : 0) + 1;
        this$0.performanceTracker.start();
        return new SearchEverywhereMlSearchState(this$0.project, nextSearchIndex, $tab, $searchScope, $isSearchEverywhere, this$0.sessionStartTime, searchReason, $keysTyped, $backspacesTyped, $searchQuery, this$0.modelProviderWithCache, this$0.providersCache, this$0.mixedListInfo);
    }
}

