/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.local.generation;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.local.generation.LapTimer;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/completion/full/line/local/generation/LapTimerImpl;", "Lorg/jetbrains/completion/full/line/local/generation/LapTimer;", "<init>", "()V", "startTime", "", "lastLap", "endTime", "Ljava/lang/Long;", "laps", "", "Lorg/jetbrains/completion/full/line/local/generation/LapTimer$Lap;", "getLaps", "()Ljava/util/List;", "totalTime", "getTotalTime", "()J", "lap", "", "name", "", "end", "intellij.fullLine.local"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\norg/jetbrains/completion/full/line/local/generation/LapTimerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,224:1\n1#2:225\n*E\n"})
public final class LapTimerImpl
implements LapTimer {
    private long startTime;
    private long lastLap;
    @Nullable
    private Long endTime;
    @NotNull
    private final List<LapTimer.Lap> laps;

    public LapTimerImpl() {
        this.lastLap = this.startTime = System.currentTimeMillis();
        this.laps = new ArrayList();
    }

    @Override
    @NotNull
    public List<LapTimer.Lap> getLaps() {
        return this.laps;
    }

    @Override
    public long getTotalTime() {
        Long l = this.endTime;
        if (l == null) {
            throw new IllegalStateException("Timer hasn't been stopped yet");
        }
        long it = ((Number)l).longValue();
        boolean bl = false;
        return it - this.startTime;
    }

    @Override
    public void lap(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        long newLap = System.currentTimeMillis();
        this.getLaps().add(new LapTimer.Lap(name, newLap - this.lastLap));
        this.lastLap = newLap;
    }

    @Override
    public void end() {
        this.endTime = System.currentTimeMillis();
    }
}

