/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.local.generation.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.GenerationInfo;
import org.jetbrains.completion.full.line.local.generation.search.BeamSearchInfo;
import org.jetbrains.completion.full.line.local.generation.search.BeamSearchNode;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J6\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u0011H\u0002JD\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\f2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u00152\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u0011H\u0002J\f\u0010\u0017\u001a\u00020\u0005*\u00020\fH\u0002J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/completion/full/line/local/generation/search/TextBeamSearchRenderer;", "", "<init>", "()V", "render", "", "info", "Lorg/jetbrains/completion/full/line/local/generation/search/BeamSearchInfo;", "renderGraph", "", "nodes", "", "Lorg/jetbrains/completion/full/line/local/generation/search/BeamSearchNode;", "output", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "textGetter", "Lkotlin/Function1;", "renderDfs", "node", "maxStepLens", "", "", "detailedString", "escape", "raw", "intellij.fullLine.local"})
@SourceDebugExtension(value={"SMAP\nTextBeamSearchRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextBeamSearchRenderer.kt\norg/jetbrains/completion/full/line/local/generation/search/TextBeamSearchRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1080#2:44\n1512#2:45\n1538#2,3:46\n1541#2,3:56\n1266#2,2:61\n1586#2:63\n1661#2,3:64\n1269#2:68\n777#2:69\n873#2,2:70\n383#3,7:49\n466#3:59\n415#3:60\n1#4:67\n*S KotlinDebug\n*F\n+ 1 TextBeamSearchRenderer.kt\norg/jetbrains/completion/full/line/local/generation/search/TextBeamSearchRenderer\n*L\n8#1:44\n17#1:45\n17#1:46,3\n17#1:56,3\n17#1:61,2\n17#1:63\n17#1:64,3\n17#1:68\n18#1:69\n18#1:70,2\n17#1:49,7\n17#1:59\n17#1:60\n*E\n"})
public final class TextBeamSearchRenderer {
    @NotNull
    public final String render(@NotNull BeamSearchInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        StringBuilder output = new StringBuilder();
        output.append("Prefix: " + info.getPrefix()).append('\n');
        output.append("Stashed hypotheses:").append('\n');
        Iterable $this$sortedByDescending$iv = info.getStashedHypotheses();
        boolean $i$f$sortedByDescending = false;
        for (GenerationInfo hyp : CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                GenerationInfo it = (GenerationInfo)b;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getScore());
                it = (GenerationInfo)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getScore()));
            }
        })) {
            output.append("- " + this.escape(hyp.getText()) + " (" + hyp.getScore() + ")").append('\n');
        }
        output.append('\n');
        this.renderGraph(info.getGraph(), output, (Function1<? super BeamSearchNode, String>)((Function1)arg_0 -> TextBeamSearchRenderer.render$lambda$1(this, arg_0)));
        String string = output.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final void renderGraph(List<BeamSearchNode> nodes, StringBuilder output, Function1<? super BeamSearchNode, String> textGetter) {
        void $this$filterTo$iv$iv;
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object value$iv$iv$iv;
        Map.Entry $this$getOrPut$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv = nodes;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            BeamSearchNode it = (BeamSearchNode)element$iv$iv;
            boolean bl = false;
            Integer key$iv$iv = it.getStep();
            Map map = destination$iv$iv;
            Integer key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable iterable2 = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv;
            void it;
            void it$iv$iv;
            $this$getOrPut$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv$iv;
            boolean bl = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map2 = map;
            boolean bl3 = false;
            Iterable $this$map$iv = (Iterable)it.getValue();
            boolean $i$f$map = false;
            Iterable iterable3 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                destination$iv$iv2.add(textGetter.invoke(item$iv$iv));
            }
            Iterator iterator2 = ((Iterable)((List)destination$iv$iv2)).iterator();
            if (!iterator2.hasNext()) {
                throw new NoSuchElementException();
            }
            String it2 = (String)iterator2.next();
            boolean bl4 = false;
            int n = it2.length();
            while (iterator2.hasNext()) {
                String it3 = (String)iterator2.next();
                $i$a$-maxOf-TextBeamSearchRenderer$renderGraph$maxStepLens$2$1 = false;
                int n2 = it3.length();
                if (n >= n2) continue;
                n = n2;
            }
            Integer n3 = n;
            map2.put(k, n3);
        }
        Map maxStepLens = destination$iv$iv$iv;
        Iterable $this$filter$iv = nodes;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BeamSearchNode it = (BeamSearchNode)element$iv$iv;
            boolean bl = false;
            if (!(it.getStep() == 0)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        for (BeamSearchNode node : (List)destination$iv$iv3) {
            this.renderDfs(node, maxStepLens, output, textGetter);
        }
    }

    private final void renderDfs(BeamSearchNode node, Map<Integer, Integer> maxStepLens, StringBuilder output, Function1<? super BeamSearchNode, String> textGetter) {
        output.append(StringsKt.padEnd((String)((String)textGetter.invoke((Object)node)), (int)((Number)MapsKt.getValue(maxStepLens, (Object)node.getStep())).intValue(), (char)' '));
        if (node.getChildren().isEmpty()) {
            output.append(" = " + this.escape(node.getFullText()) + "\n");
            return;
        }
        output.append(" -> ");
        this.renderDfs((BeamSearchNode)CollectionsKt.first(node.getChildren()), maxStepLens, output, textGetter);
        String emptyLine = CollectionsKt.joinToString$default((Iterable)((Iterable)new IntRange(0, node.getStep())), (CharSequence)" -> ", null, null, (int)0, null, arg_0 -> TextBeamSearchRenderer.renderDfs$lambda$0(maxStepLens, arg_0), (int)30, null);
        for (BeamSearchNode child : CollectionsKt.drop((Iterable)node.getChildren(), (int)1)) {
            output.append(emptyLine + " -> ");
            this.renderDfs(child, maxStepLens, output, textGetter);
        }
    }

    private final String detailedString(BeamSearchNode $this$detailedString) {
        String string = $this$detailedString.getText();
        String string2 = "%.3f";
        Object[] objectArray = new Object[]{$this$detailedString.getScore()};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        string2 = "%.3f";
        objectArray = new Object[]{$this$detailedString.getCurProb()};
        String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        return this.escape(string + " (" + string3 + "|" + string4 + ")");
    }

    private final String escape(String raw) {
        return StringsKt.replace$default((String)raw, (String)"\n", (String)"\\n", (boolean)false, (int)4, null);
    }

    private static final String render$lambda$1(TextBeamSearchRenderer this$0, BeamSearchNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.detailedString(it);
    }

    private static final CharSequence renderDfs$lambda$0(Map $maxStepLens, int it) {
        return StringsKt.repeat((CharSequence)" ", (int)((Number)MapsKt.getValue((Map)$maxStepLens, (Object)it)).intValue());
    }
}

