/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.CollectionFactory;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaReader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0007J>\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0006\u0012\u0004\u0018\u00010\t0\bj\u0002`\n0\u00072\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\t0\bj\u0002`\nH\u0002J,\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0013\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\t0\bj\u0002`\nH\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0016R,\u0010\u0004\u001a \u0012\u0004\u0012\u00020\u0006\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0006\u0012\u0004\u0018\u00010\t0\bj\u0002`\n0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/jsonSchema/impl/JsonSchemaCacheManager;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "cache", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaCacheManager$CachedValue;", "Ljava/util/concurrent/CompletableFuture;", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaObject;", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaObjectFuture;", "computeSchemaObject", "schemaVirtualFile", "schemaPsiFile", "Lcom/intellij/psi/PsiFile;", "getUpToDateFuture", "newFuture", "completeSync", "", "future", "dispose", "CachedValue", "Companion", "intellij.json.backend"})
public final class JsonSchemaCacheManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<VirtualFile, CachedValue<CompletableFuture<JsonSchemaObject>>> cache;

    public JsonSchemaCacheManager() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakMap(...)");
        this.cache = concurrentMap;
    }

    @Deprecated(message="Must not be used with the new json object implementation turned on")
    @Nullable
    public final JsonSchemaObject computeSchemaObject(@NotNull VirtualFile schemaVirtualFile, @NotNull PsiFile schemaPsiFile) {
        Intrinsics.checkNotNullParameter((Object)schemaVirtualFile, (String)"schemaVirtualFile");
        Intrinsics.checkNotNullParameter((Object)schemaPsiFile, (String)"schemaPsiFile");
        if (_Assertions.ENABLED) {
            boolean $i$a$-assert-JsonSchemaCacheManager$computeSchemaObject$22 = false;
            String $i$a$-assert-JsonSchemaCacheManager$computeSchemaObject$22 = "Should not use cache with the new json object impl";
            throw new AssertionError((Object)$i$a$-assert-JsonSchemaCacheManager$computeSchemaObject$22);
        }
        CompletableFuture<JsonSchemaObject> newFuture = new CompletableFuture<JsonSchemaObject>();
        CachedValue<CompletableFuture<JsonSchemaObject>> cachedValue = this.getUpToDateFuture(schemaVirtualFile, schemaPsiFile, newFuture);
        CompletableFuture<JsonSchemaObject> cachedFuture = cachedValue.getValue();
        if (cachedFuture == newFuture) {
            this.completeSync(schemaVirtualFile, schemaPsiFile, cachedFuture);
        }
        try {
            return (JsonSchemaObject)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)cachedFuture, (ProgressIndicator)ProgressManager.getInstance().getProgressIndicator());
        }
        catch (ProcessCanceledException e) {
            ProgressManager.checkCanceled();
            this.cache.remove(schemaVirtualFile, cachedValue);
            return this.computeSchemaObject(schemaVirtualFile, schemaPsiFile);
        }
    }

    private final CachedValue<CompletableFuture<JsonSchemaObject>> getUpToDateFuture(VirtualFile schemaVirtualFile, PsiFile schemaPsiFile, CompletableFuture<JsonSchemaObject> newFuture) {
        CachedValue cachedValue = this.cache.compute(schemaVirtualFile, (arg_0, arg_1) -> JsonSchemaCacheManager.getUpToDateFuture$lambda$1((arg_0, arg_1) -> JsonSchemaCacheManager.getUpToDateFuture$lambda$0(schemaVirtualFile, schemaPsiFile, newFuture, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNull((Object)cachedValue);
        return cachedValue;
    }

    private final void completeSync(VirtualFile schemaVirtualFile, PsiFile schemaPsiFile, CompletableFuture<JsonSchemaObject> future) {
        try {
            future.complete(new JsonSchemaReader().read(schemaPsiFile));
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
    }

    public void dispose() {
        this.cache.clear();
    }

    private static final CachedValue getUpToDateFuture$lambda$0(VirtualFile $schemaVirtualFile, PsiFile $schemaPsiFile, CompletableFuture $newFuture, VirtualFile virtualFile, CachedValue prevValue) {
        long virtualFileModStamp = $schemaVirtualFile.getModificationStamp();
        long psiFileModStamp = $schemaPsiFile.getModificationStamp();
        return prevValue != null && prevValue.getVirtualFileModStamp() == virtualFileModStamp && prevValue.getPsiFileModStamp() == psiFileModStamp ? prevValue : new CachedValue($newFuture, virtualFileModStamp, psiFileModStamp);
    }

    private static final CachedValue getUpToDateFuture$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (CachedValue)$tmp0.invoke(p0, p1);
    }

    @JvmStatic
    @NotNull
    public static final JsonSchemaCacheManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000f\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J2\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0013J\u0014\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u00d6\u0083\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u00d6\u0081\u0004J\n\u0010\u0019\u001a\u00020\u001aH\u00d6\u0081\u0004R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/jsonSchema/impl/JsonSchemaCacheManager$CachedValue;", "T", "", "value", "virtualFileModStamp", "", "psiFileModStamp", "<init>", "(Ljava/lang/Object;JJ)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getVirtualFileModStamp", "()J", "getPsiFileModStamp", "component1", "component2", "component3", "copy", "(Ljava/lang/Object;JJ)Lcom/jetbrains/jsonSchema/impl/JsonSchemaCacheManager$CachedValue;", "equals", "", "other", "hashCode", "", "toString", "", "intellij.json.backend"})
    private static final class CachedValue<T> {
        private final T value;
        private final long virtualFileModStamp;
        private final long psiFileModStamp;

        public CachedValue(T value, long virtualFileModStamp, long psiFileModStamp) {
            this.value = value;
            this.virtualFileModStamp = virtualFileModStamp;
            this.psiFileModStamp = psiFileModStamp;
        }

        public final T getValue() {
            return this.value;
        }

        public final long getVirtualFileModStamp() {
            return this.virtualFileModStamp;
        }

        public final long getPsiFileModStamp() {
            return this.psiFileModStamp;
        }

        public final T component1() {
            return this.value;
        }

        public final long component2() {
            return this.virtualFileModStamp;
        }

        public final long component3() {
            return this.psiFileModStamp;
        }

        @NotNull
        public final CachedValue<T> copy(T value, long virtualFileModStamp, long psiFileModStamp) {
            return new CachedValue<T>(value, virtualFileModStamp, psiFileModStamp);
        }

        public static /* synthetic */ CachedValue copy$default(CachedValue cachedValue, Object object, long l, long l2, int n, Object object2) {
            if ((n & 1) != 0) {
                object = cachedValue.value;
            }
            if ((n & 2) != 0) {
                l = cachedValue.virtualFileModStamp;
            }
            if ((n & 4) != 0) {
                l2 = cachedValue.psiFileModStamp;
            }
            return cachedValue.copy(object, l, l2);
        }

        @NotNull
        public String toString() {
            return "CachedValue(value=" + this.value + ", virtualFileModStamp=" + this.virtualFileModStamp + ", psiFileModStamp=" + this.psiFileModStamp + ")";
        }

        public int hashCode() {
            int result = this.value == null ? 0 : this.value.hashCode();
            result = result * 31 + Long.hashCode(this.virtualFileModStamp);
            result = result * 31 + Long.hashCode(this.psiFileModStamp);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CachedValue)) {
                return false;
            }
            CachedValue cachedValue = (CachedValue)other;
            if (!Intrinsics.areEqual(this.value, cachedValue.value)) {
                return false;
            }
            if (this.virtualFileModStamp != cachedValue.virtualFileModStamp) {
                return false;
            }
            return this.psiFileModStamp == cachedValue.psiFileModStamp;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/jsonSchema/impl/JsonSchemaCacheManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaCacheManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.json.backend"})
    @SourceDebugExtension(value={"SMAP\nJsonSchemaCacheManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonSchemaCacheManager.kt\ncom/jetbrains/jsonSchema/impl/JsonSchemaCacheManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,93:1\n30#2,2:94\n*S KotlinDebug\n*F\n+ 1 JsonSchemaCacheManager.kt\ncom/jetbrains/jsonSchema/impl/JsonSchemaCacheManager$Companion\n*L\n88#1:94,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JsonSchemaCacheManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<JsonSchemaCacheManager> serviceClass$iv = JsonSchemaCacheManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (JsonSchemaCacheManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

