/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.ui.clone;

import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.collaboration.ui.util.ActionUtilKt;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.AbstractAction;
import javax.swing.JList;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gitlab.ui.clone.GitLabCloneException;
import org.jetbrains.plugins.gitlab.ui.clone.GitLabCloneListItem;
import org.jetbrains.plugins.gitlab.ui.clone.GitLabCloneListItemKt;
import org.jetbrains.plugins.gitlab.ui.clone.model.GitLabCloneRepositoriesListViewModel;
import org.jetbrains.plugins.gitlab.ui.clone.model.GitLabCloneViewModel;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ8\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0014J\u0011\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0015*\u00020\u0016H\u0002J\u0011\u0010\u0017\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0015*\u00020\u0016H\u0002J\u0018\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\n0\u0019*\u00020\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/gitlab/ui/clone/GitLabCloneListRenderer;", "Lcom/intellij/ui/ColoredListCellRenderer;", "Lorg/jetbrains/plugins/gitlab/ui/clone/GitLabCloneListItem;", "cloneVm", "Lorg/jetbrains/plugins/gitlab/ui/clone/model/GitLabCloneViewModel;", "vm", "Lorg/jetbrains/plugins/gitlab/ui/clone/model/GitLabCloneRepositoriesListViewModel;", "<init>", "(Lorg/jetbrains/plugins/gitlab/ui/clone/model/GitLabCloneViewModel;Lorg/jetbrains/plugins/gitlab/ui/clone/model/GitLabCloneRepositoriesListViewModel;)V", "customizeCellRenderer", "", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "hasFocus", "message", "", "Lorg/jetbrains/annotations/Nls;", "Lorg/jetbrains/plugins/gitlab/ui/clone/GitLabCloneException;", "name", "performAction", "Lkotlin/Function1;", "", "intellij.vcs.gitlab"})
public final class GitLabCloneListRenderer
extends ColoredListCellRenderer<GitLabCloneListItem> {
    @NotNull
    private final GitLabCloneViewModel cloneVm;
    @NotNull
    private final GitLabCloneRepositoriesListViewModel vm;

    public GitLabCloneListRenderer(@NotNull GitLabCloneViewModel cloneVm, @NotNull GitLabCloneRepositoriesListViewModel vm2) {
        Intrinsics.checkNotNullParameter((Object)cloneVm, (String)"cloneVm");
        Intrinsics.checkNotNullParameter((Object)vm2, (String)"vm");
        this.cloneVm = cloneVm;
        this.vm = vm2;
    }

    protected void customizeCellRenderer(@NotNull JList<? extends GitLabCloneListItem> list, @NotNull GitLabCloneListItem value, int index, boolean selected, boolean hasFocus) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.clear();
        GitLabCloneListItem gitLabCloneListItem = value;
        if (gitLabCloneListItem instanceof GitLabCloneListItem.Error) {
            GitLabCloneException cloneError = ((GitLabCloneListItem.Error)value).getError();
            AbstractAction action = ActionUtilKt.swingAction((String)this.name(cloneError), this.performAction(cloneError));
            this.append(this.message(cloneError), SimpleTextAttributes.ERROR_ATTRIBUTES);
            this.append(" ");
            this.append(this.name(cloneError), SimpleTextAttributes.LINK_ATTRIBUTES, action);
            v0 = Unit.INSTANCE;
        } else if (gitLabCloneListItem instanceof GitLabCloneListItem.Repository) {
            SimpleColoredComponent simpleColoredComponent = this.append(GitLabCloneListItemKt.presentation((GitLabCloneListItem.Repository)value));
            v0 = simpleColoredComponent;
            Intrinsics.checkNotNullExpressionValue((Object)simpleColoredComponent, (String)"append(...)");
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final String message(GitLabCloneException $this$message) {
        String string;
        GitLabCloneException gitLabCloneException = $this$message;
        if (gitLabCloneException instanceof GitLabCloneException.ConnectionError) {
            String string2 = CollaborationToolsBundle.message((String)"error.connection.error", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else if (gitLabCloneException instanceof GitLabCloneException.MissingAccessToken) {
            String string3 = CollaborationToolsBundle.message((String)"account.token.missing", (Object[])new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        } else if (gitLabCloneException instanceof GitLabCloneException.RevokedToken) {
            String string4 = CollaborationToolsBundle.message((String)"http.status.error.refresh.token", (Object[])new Object[0]);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        } else if (gitLabCloneException instanceof GitLabCloneException.Unknown) {
            string = ((GitLabCloneException.Unknown)$this$message).getMessage();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final String name(GitLabCloneException $this$name) {
        String string;
        GitLabCloneException gitLabCloneException = $this$name;
        if (gitLabCloneException instanceof GitLabCloneException.MissingAccessToken || gitLabCloneException instanceof GitLabCloneException.RevokedToken) {
            String string2 = CollaborationToolsBundle.message((String)"login.again.action.text", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else if (gitLabCloneException instanceof GitLabCloneException.ConnectionError || gitLabCloneException instanceof GitLabCloneException.Unknown) {
            String string3 = CollaborationToolsBundle.message((String)"clone.dialog.error.retry", (Object[])new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final Function1<Object, Unit> performAction(GitLabCloneException $this$performAction) {
        GitLabCloneException gitLabCloneException = $this$performAction;
        if (gitLabCloneException instanceof GitLabCloneException.MissingAccessToken || gitLabCloneException instanceof GitLabCloneException.RevokedToken) {
            return arg_0 -> GitLabCloneListRenderer.performAction$lambda$0(this, $this$performAction, arg_0);
        }
        if (gitLabCloneException instanceof GitLabCloneException.ConnectionError || gitLabCloneException instanceof GitLabCloneException.Unknown) {
            return arg_0 -> GitLabCloneListRenderer.performAction$lambda$1(this, $this$performAction, arg_0);
        }
        throw new NoWhenBranchMatchedException();
    }

    private static final Unit performAction$lambda$0(GitLabCloneListRenderer this$0, GitLabCloneException $this_performAction, Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.cloneVm.switchToLoginPanel($this_performAction.getAccount());
        return Unit.INSTANCE;
    }

    private static final Unit performAction$lambda$1(GitLabCloneListRenderer this$0, GitLabCloneException $this_performAction, Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.vm.reload($this_performAction.getAccount());
        return Unit.INSTANCE;
    }
}

