/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.JavaFXBundle;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.indexing.JavaFxControllerClassIndex;

public final class JavaFxRelatedItemLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    private static final Logger LOG = Logger.getInstance(JavaFxRelatedItemLineMarkerProvider.class);

    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        PsiClass containingClass;
        PsiField field;
        PsiElement f;
        if (element == null) {
            JavaFxRelatedItemLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            JavaFxRelatedItemLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiIdentifier && (f = element.getParent()) instanceof PsiField && JavaFxPsiUtil.isVisibleInFxml((PsiMember)(field = (PsiField)f)) && !field.hasModifierProperty("static") && !field.hasModifierProperty("final") && (containingClass = field.getContainingClass()) != null && containingClass.hasModifierProperty("public") && containingClass.getQualifiedName() != null) {
            PsiMethod[] constructors = containingClass.getConstructors();
            boolean defaultConstructor = constructors.length == 0;
            for (PsiMethod constructor : constructors) {
                if (!constructor.getParameterList().isEmpty()) continue;
                defaultConstructor = true;
                break;
            }
            if (!defaultConstructor) {
                return;
            }
            ArrayList targets = new ArrayList();
            JavaFxRelatedItemLineMarkerProvider.collectTargets(field, targets, GotoRelatedItem::new, true);
            if (targets.isEmpty()) {
                return;
            }
            result.add(new RelatedItemLineMarkerInfo((PsiElement)((PsiIdentifier)element), element.getTextRange(), AllIcons.FileTypes.Xml, null, (GutterIconNavigationHandler)new JavaFXIdIconNavigationHandler(), GutterIconRenderer.Alignment.LEFT, () -> targets));
        }
    }

    private static <T> void collectTargets(PsiField field, List<T> targets, Function<PsiElement, T> fun, boolean stopAtFirst) {
        PsiClass containingClass = field.getContainingClass();
        LOG.assertTrue(containingClass != null);
        String qualifiedName = containingClass.getQualifiedName();
        LOG.assertTrue(qualifiedName != null);
        List<VirtualFile> fxmls = JavaFxControllerClassIndex.findFxmlsWithController(field.getProject(), qualifiedName);
        if (fxmls.isEmpty()) {
            return;
        }
        ReferencesSearch.search((PsiElement)field, (SearchScope)GlobalSearchScope.filesScope((Project)field.getProject(), fxmls)).forEach(reference -> {
            PsiElement referenceElement = reference.getElement();
            PsiFile containingFile = referenceElement.getContainingFile();
            if (containingFile == null) {
                return true;
            }
            if (!JavaFxFileTypeFactory.isFxml(containingFile)) {
                return true;
            }
            if (!(referenceElement instanceof XmlAttributeValue)) {
                return true;
            }
            XmlAttributeValue attributeValue = (XmlAttributeValue)referenceElement;
            PsiElement parent = attributeValue.getParent();
            if (!(parent instanceof XmlAttribute)) {
                return true;
            }
            XmlAttribute attribute = (XmlAttribute)parent;
            if (!"fx:id".equals(attribute.getName())) {
                return true;
            }
            targets.add(fun.fun((Object)parent));
            return !stopAtFirst;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxRelatedItemLineMarkerProvider";
        objectArray[2] = "collectNavigationMarkers";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class JavaFXIdIconNavigationHandler
    implements GutterIconNavigationHandler<PsiIdentifier> {
        private JavaFXIdIconNavigationHandler() {
        }

        public void navigate(MouseEvent e, PsiIdentifier fieldName) {
            ArrayList relatedItems = new ArrayList();
            PsiElement f = fieldName.getParent();
            if (f instanceof PsiField) {
                JavaFxRelatedItemLineMarkerProvider.collectTargets((PsiField)f, relatedItems, Functions.id(), false);
            }
            if (relatedItems.size() == 1) {
                NavigationUtil.activateFileWithPsiElement((PsiElement)((PsiElement)relatedItems.get(0)));
                return;
            }
            JBPopup popup = NavigationUtil.getPsiElementPopup((PsiElement[])relatedItems.toArray(PsiElement.EMPTY_ARRAY), (String)JavaFXBundle.message("popup.title.choose.component.with.fx.id", fieldName.getText()));
            popup.show(new RelativePoint(e));
        }
    }
}

