/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.async;

import com.intellij.execution.configurations.ConfigurationWithAlternativeJre;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.SdkVersionUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.profiler.MisConfiguredException;
import com.intellij.profiler.MisConfiguredExceptionKt;
import com.intellij.profiler.api.configurations.ProfilerConfigurationState;
import com.intellij.profiler.ultimate.settings.JVMProfilerConfigurable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002\u001a\u0016\u0010\f\u001a\u0004\u0018\u00010\u00032\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0000\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a8\u0006\u000f"}, d2={"validateAgentPath", "Lcom/intellij/profiler/MisConfiguredException;", "path", "", "project", "Lcom/intellij/openapi/project/Project;", "state", "Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;", "isOpenJ9", "", "configuration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "getJdkHome", "jdkVersion", "Lorg/jetbrains/jps/model/java/JdkVersionDetector$JdkVersionInfo;", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nAsyncProfilerConfigurationExtensionBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncProfilerConfigurationExtensionBase.kt\ncom/intellij/profiler/ultimate/async/AsyncProfilerConfigurationExtensionBaseKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n1#2:182\n*E\n"})
public final class AsyncProfilerConfigurationExtensionBaseKt {
    @Nullable
    public static final MisConfiguredException validateAgentPath(@NotNull String path, @NotNull Project project, @NotNull ProfilerConfigurationState state) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return MisConfiguredExceptionKt.validateLocalPath((String)path, (String)"profiler agent", (Project)project, JVMProfilerConfigurable.class, arg_0 -> AsyncProfilerConfigurationExtensionBaseKt.validateAgentPath$lambda$0(state, arg_0));
    }

    private static final boolean isOpenJ9(RunConfigurationBase<?> configuration) {
        JdkVersionDetector.JdkVersionInfo jdkVersionInfo;
        String jdkHome;
        String string = jdkHome = AsyncProfilerConfigurationExtensionBaseKt.getJdkHome(configuration);
        if (string != null) {
            String it = string;
            boolean bl = false;
            jdkVersionInfo = SdkVersionUtil.getJdkVersionInfo((String)it);
        } else {
            jdkVersionInfo = null;
        }
        JdkVersionDetector.JdkVersionInfo version = jdkVersionInfo;
        return version != null && AsyncProfilerConfigurationExtensionBaseKt.isOpenJ9(version);
    }

    @Nullable
    public static final String getJdkHome(@NotNull RunConfigurationBase<?> configuration) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        String jdkHome = null;
        if (configuration instanceof ConfigurationWithAlternativeJre && ((ConfigurationWithAlternativeJre)configuration).isAlternativeJrePathEnabled()) {
            jdkHome = ((ConfigurationWithAlternativeJre)configuration).getAlternativeJrePath();
        }
        if (jdkHome == null) {
            Sdk sdk = ProjectRootManager.getInstance((Project)configuration.getProject()).getProjectSdk();
            jdkHome = sdk != null ? sdk.getHomePath() : null;
        }
        return jdkHome;
    }

    public static final boolean isOpenJ9(@NotNull JdkVersionDetector.JdkVersionInfo jdkVersion) {
        Intrinsics.checkNotNullParameter((Object)jdkVersion, (String)"jdkVersion");
        Object[] objectArray = new JdkVersionDetector.Variant[]{JdkVersionDetector.Variant.AdoptOpenJdk_J9, JdkVersionDetector.Variant.Semeru, JdkVersionDetector.Variant.IBM};
        return CollectionsKt.listOf((Object[])objectArray).contains(jdkVersion.variant);
    }

    private static final Unit validateAgentPath$lambda$0(ProfilerConfigurationState $state, Configurable it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            JVMProfilerConfigurable jVMProfilerConfigurable = it instanceof JVMProfilerConfigurable ? (JVMProfilerConfigurable)it : null;
            if (jVMProfilerConfigurable == null || (jVMProfilerConfigurable = jVMProfilerConfigurable.getComponent()) == null) break block0;
            jVMProfilerConfigurable.selectNodeInTree($state);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$isOpenJ9(RunConfigurationBase configuration) {
        return AsyncProfilerConfigurationExtensionBaseKt.isOpenJ9(configuration);
    }
}

