/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jfr;

import com.intellij.profiler.ultimate.jfr.ReadingJfrProgressStep;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openjdk.jmc.flightrecorder.parser.ByteBufferWrapper;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u0012\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0000H\u0016J\u0006\u0010\u0012\u001a\u00020\u0005J\u0011\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0096\u0002J#\u0010\u0013\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u001aH\u0016J\u0011\u0010\u0013\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0005H\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u0005H\u0016J\b\u0010\u001e\u001a\u00020\u0005H\u0016J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0016J\b\u0010\u001f\u001a\u00020\u000bH\u0016J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0005H\u0016J\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u0005H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u001b\u001a\u00020\u0005H\u0016J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u0005H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006&"}, d2={"Lcom/intellij/profiler/ultimate/jfr/ByteBufferTrackingWrapper;", "Lorg/openjdk/jmc/flightrecorder/parser/ByteBufferWrapper;", "buffer", "Ljava/nio/ByteBuffer;", "chunkSize", "", "progressTracker", "Lcom/intellij/profiler/ultimate/jfr/ReadingJfrProgressStep;", "<init>", "(Ljava/nio/ByteBuffer;ILcom/intellij/profiler/ultimate/jfr/ReadingJfrProgressStep;)V", "value", "", "totalBytesRead", "getTotalBytesRead", "()J", "view", "size", "slice", "position", "get", "bytes", "", "", "dst", "off", "len", "", "index", "getShort", "", "getInt", "getLong", "getFloat", "", "getDouble", "", "advance", "bytesRead", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nByteBufferTrackingWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteBufferTrackingWrapper.kt\ncom/intellij/profiler/ultimate/jfr/ByteBufferTrackingWrapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1#2:63\n*E\n"})
public final class ByteBufferTrackingWrapper
extends ByteBufferWrapper {
    @NotNull
    private final ReadingJfrProgressStep progressTracker;
    private long totalBytesRead;

    public ByteBufferTrackingWrapper(@NotNull ByteBuffer buffer, int chunkSize, @NotNull ReadingJfrProgressStep progressTracker) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)progressTracker, (String)"progressTracker");
        super(buffer);
        this.progressTracker = progressTracker;
        if (chunkSize >= 256) {
            this.progressTracker.registerBuffer(this);
        }
    }

    public final long getTotalBytesRead() {
        return this.totalBytesRead;
    }

    @Override
    @NotNull
    public ByteBufferTrackingWrapper view(int size) {
        ByteBuffer byteBuffer = this.getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"getBuffer(...)");
        return new ByteBufferTrackingWrapper(byteBuffer, size, this.progressTracker);
    }

    @Override
    @NotNull
    public ByteBufferTrackingWrapper slice() {
        ByteBuffer newBuffer = this.getBuffer().slice();
        Intrinsics.checkNotNull((Object)newBuffer);
        return new ByteBufferTrackingWrapper(newBuffer, newBuffer.limit(), this.progressTracker);
    }

    public final int position() {
        return this.getBuffer().position();
    }

    @Override
    @NotNull
    public ByteBuffer get(@NotNull byte[] bytes) {
        ByteBuffer byteBuffer;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        ByteBuffer it = byteBuffer = super.get(bytes);
        boolean bl = false;
        this.advance(bytes.length);
        ByteBuffer byteBuffer2 = byteBuffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"also(...)");
        return byteBuffer2;
    }

    @Override
    public void get(@Nullable byte[] dst, int off, int len) {
        super.get(dst, off, len);
        this.advance(len);
    }

    @Override
    public byte get() {
        byte by;
        byte it = by = super.get();
        boolean bl = false;
        this.advance(1);
        return by;
    }

    @Override
    public byte get(int index) {
        byte by;
        byte it = by = super.get(index);
        boolean bl = false;
        this.advance(1);
        return by;
    }

    @Override
    public short getShort() {
        short s;
        short it = s = super.getShort();
        boolean bl = false;
        this.advance(2);
        return s;
    }

    @Override
    public short getShort(int index) {
        short s;
        short it = s = super.getShort(index);
        boolean bl = false;
        this.advance(2);
        return s;
    }

    @Override
    public int getInt() {
        int n;
        int it = n = super.getInt();
        boolean bl = false;
        this.advance(4);
        return n;
    }

    @Override
    public int getInt(int index) {
        int n;
        int it = n = super.getInt(index);
        boolean bl = false;
        this.advance(4);
        return n;
    }

    @Override
    public long getLong() {
        long l;
        long it = l = super.getLong();
        boolean bl = false;
        this.advance(8);
        return l;
    }

    @Override
    public long getLong(int index) {
        long l;
        long it = l = super.getLong(index);
        boolean bl = false;
        this.advance(8);
        return l;
    }

    @Override
    public float getFloat() {
        float f;
        float it = f = super.getFloat();
        boolean bl = false;
        this.advance(4);
        return f;
    }

    @Override
    public float getFloat(int index) {
        float f;
        float it = f = super.getFloat(index);
        boolean bl = false;
        this.advance(4);
        return f;
    }

    @Override
    public double getDouble() {
        double d;
        double it = d = super.getDouble();
        boolean bl = false;
        this.advance(8);
        return d;
    }

    @Override
    public double getDouble(int index) {
        double d;
        double it = d = super.getDouble(index);
        boolean bl = false;
        this.advance(8);
        return d;
    }

    private final void advance(int bytesRead) {
        this.totalBytesRead += (long)bytesRead;
    }
}

