/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jfr.events;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\u0004\b\t\u0010\nJ&\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010 J,\u0010!\u001a\u00020\u001c2\u001e\u0010\"\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0#H\u0086\b\u00f8\u0001\u0000J!\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&H\u0000\u00a2\u0006\u0004\b'\u0010(R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006)"}, d2={"Lcom/intellij/profiler/ultimate/jfr/events/JfrThreadTimestampInfoStorage;", "T", "", "size", "", "areEventsDurational", "", "eventInterval", "Lkotlin/Function1;", "<init>", "(IZLkotlin/jvm/functions/Function1;)V", "getSize", "()I", "getEventInterval", "()Lkotlin/jvm/functions/Function1;", "timestampStarts", "Lit/unimi/dsi/fastutil/ints/IntArrayList;", "getTimestampStarts", "()Lit/unimi/dsi/fastutil/ints/IntArrayList;", "timestampEnds", "getTimestampEnds", "infos", "Ljava/util/ArrayList;", "getInfos", "()Ljava/util/ArrayList;", "isEmpty", "()Z", "set", "", "timestampStart", "timestampEnd", "info", "(IILjava/lang/Object;)V", "forEach", "action", "Lkotlin/Function3;", "merge", "wallClockIntervalMs", "", "merge$intellij_profiler_ultimate", "(Ljava/lang/Double;)Lcom/intellij/profiler/ultimate/jfr/events/JfrThreadTimestampInfoStorage;", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nJfrEventType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JfrEventType.kt\ncom/intellij/profiler/ultimate/jfr/events/JfrThreadTimestampInfoStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,843:1\n1068#2:844\n*S KotlinDebug\n*F\n+ 1 JfrEventType.kt\ncom/intellij/profiler/ultimate/jfr/events/JfrThreadTimestampInfoStorage\n*L\n212#1:844\n*E\n"})
public final class JfrThreadTimestampInfoStorage<T> {
    private final int size;
    @NotNull
    private final Function1<T, Integer> eventInterval;
    @NotNull
    private final IntArrayList timestampStarts;
    @Nullable
    private final IntArrayList timestampEnds;
    @NotNull
    private final ArrayList<T> infos;

    public JfrThreadTimestampInfoStorage(int size, boolean areEventsDurational, @NotNull Function1<? super T, Integer> eventInterval) {
        Intrinsics.checkNotNullParameter(eventInterval, (String)"eventInterval");
        this.size = size;
        this.eventInterval = eventInterval;
        this.timestampStarts = new IntArrayList(this.size);
        this.timestampEnds = areEventsDurational ? new IntArrayList(this.size) : null;
        this.infos = new ArrayList(this.size);
    }

    public final int getSize() {
        return this.size;
    }

    @NotNull
    public final Function1<T, Integer> getEventInterval() {
        return this.eventInterval;
    }

    @NotNull
    public final IntArrayList getTimestampStarts() {
        return this.timestampStarts;
    }

    @Nullable
    public final IntArrayList getTimestampEnds() {
        return this.timestampEnds;
    }

    @NotNull
    public final ArrayList<T> getInfos() {
        return this.infos;
    }

    public final boolean isEmpty() {
        return this.infos.isEmpty();
    }

    public final void set(int timestampStart, int timestampEnd, T info) {
        this.timestampStarts.add(timestampStart);
        IntArrayList intArrayList = this.timestampEnds;
        if (intArrayList != null) {
            intArrayList.add(timestampEnd);
        }
        this.infos.add(info);
    }

    public final void forEach(@NotNull Function3<? super Integer, ? super Integer, ? super T, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$forEach = false;
        int n = ((Collection)this.getTimestampStarts()).size();
        for (int i = 0; i < n; ++i) {
            T info = this.getInfos().get(i);
            int interval = ((Number)this.getEventInterval().invoke(info)).intValue();
            int start2 = this.getTimestampStarts().getInt(i);
            int actualStart = start2 - interval / 2;
            IntArrayList intArrayList = this.getTimestampEnds();
            int actualEnd = (intArrayList != null ? intArrayList.getInt(i) : start2) + interval / 2;
            action.invoke((Object)actualStart, (Object)actualEnd, info);
        }
    }

    @NotNull
    public final JfrThreadTimestampInfoStorage<T> merge$intellij_profiler_ultimate(@Nullable Double wallClockIntervalMs) {
        if (wallClockIntervalMs == null) {
            return this;
        }
        int mergingInterval = (int)(wallClockIntervalMs * (double)2);
        Iterable $this$sortedBy$iv = CollectionsKt.zip((Iterable)((Iterable)this.timestampStarts), (Iterable)this.infos);
        boolean $i$f$sortedBy = false;
        List sortedTimestamps = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Integer)it.getFirst();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getFirst()));
            }
        });
        List starts = new ArrayList();
        List ends = new ArrayList();
        List infos = new ArrayList();
        int currentStart = Integer.MIN_VALUE;
        int currentEnd = Integer.MIN_VALUE;
        Object currentInfo = null;
        Object object = sortedTimestamps.iterator();
        while (object.hasNext()) {
            Pair pair = (Pair)object.next();
            Integer start2 = (Integer)pair.component1();
            Object info = pair.component2();
            Object ci = currentInfo;
            if (info == currentInfo && Math.abs(start2 - currentEnd) < mergingInterval) {
                Intrinsics.checkNotNull((Object)start2);
                currentEnd = start2;
                continue;
            }
            if (ci != null) {
                ((Collection)starts).add(currentStart);
                ((Collection)ends).add(currentEnd);
                ((Collection)infos).add(ci);
            }
            Intrinsics.checkNotNull((Object)start2);
            currentStart = start2;
            currentEnd = start2;
            currentInfo = info;
        }
        if (currentInfo != null) {
            ((Collection)starts).add(currentStart);
            ((Collection)ends).add(currentEnd);
            ((Collection)infos).add(currentInfo);
        }
        Object $this$merge_u24lambda_u242 = object = new JfrThreadTimestampInfoStorage<T>(starts.size(), true, arg_0 -> JfrThreadTimestampInfoStorage.merge$lambda$1(wallClockIntervalMs, arg_0));
        boolean bl = false;
        int n = ((JfrThreadTimestampInfoStorage)$this$merge_u24lambda_u242).size;
        for (int i = 0; i < n; ++i) {
            ((JfrThreadTimestampInfoStorage)$this$merge_u24lambda_u242).set(((Number)starts.get(i)).intValue(), ((Number)ends.get(i)).intValue(), infos.get(i));
        }
        return object;
    }

    public static /* synthetic */ JfrThreadTimestampInfoStorage merge$intellij_profiler_ultimate$default(JfrThreadTimestampInfoStorage jfrThreadTimestampInfoStorage, Double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = null;
        }
        return jfrThreadTimestampInfoStorage.merge$intellij_profiler_ultimate(d);
    }

    private static final int merge$lambda$1(Double $wallClockIntervalMs, Object it) {
        return (int)$wallClockIntervalMs.doubleValue();
    }
}

