/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.functional.logical;

import com.intellij.ide.presentation.Presentation;
import com.intellij.ide.structureView.logical.ContainerElementsProvider;
import com.intellij.microservices.endpoints.presentation.HttpMethodPresentation;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.model.logical.SpringBeanLogicalModel;
import com.intellij.spring.mvc.functional.logical.SpringFunctionalEndpointsPresentationProvider;
import com.intellij.spring.mvc.functional.logical.SpringFunctionalMappingPresentationLogicalMapping;
import com.intellij.spring.mvc.functional.utils.SpringMvcFunctionalUtil;
import com.intellij.spring.mvc.jam.RequestMethod;
import com.intellij.spring.mvc.mapping.UrlMappingElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Presentation(provider=SpringFunctionalEndpointsPresentationProvider.class)
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/spring/mvc/functional/logical/SpringFunctionalRouteEndpointsProvider;", "Lcom/intellij/ide/structureView/logical/ContainerElementsProvider;", "Lcom/intellij/spring/model/logical/SpringBeanLogicalModel;", "Lcom/intellij/spring/mvc/functional/logical/SpringFunctionalMappingPresentationLogicalMapping;", "<init>", "()V", "isApplicable", "", "parent", "getElements", "", "intellij.spring.mvc.impl"})
@SourceDebugExtension(value={"SMAP\nSpringFunctionalRouteEndpointsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringFunctionalRouteEndpointsProvider.kt\ncom/intellij/spring/mvc/functional/logical/SpringFunctionalRouteEndpointsProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n11705#2:59\n12052#2,3:60\n1021#3,2:63\n*S KotlinDebug\n*F\n+ 1 SpringFunctionalRouteEndpointsProvider.kt\ncom/intellij/spring/mvc/functional/logical/SpringFunctionalRouteEndpointsProvider\n*L\n40#1:59\n40#1:60,3\n45#1:63,2\n*E\n"})
public final class SpringFunctionalRouteEndpointsProvider
implements ContainerElementsProvider<SpringBeanLogicalModel, SpringFunctionalMappingPresentationLogicalMapping> {
    public boolean isApplicable(@NotNull SpringBeanLogicalModel parent) {
        String springBean;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        PsiType psiType = parent.getSpringBean().getBeanType();
        String string = springBean = psiType != null ? psiType.getCanonicalText() : null;
        if (springBean == null) {
            return false;
        }
        return StringsKt.startsWith$default((String)springBean, (String)"org.springframework.web.servlet.function.RouterFunction", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)springBean, (String)"org.springframework.web.reactive.function.server.RouterFunction", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<SpringFunctionalMappingPresentationLogicalMapping> getElements(@NotNull SpringBeanLogicalModel parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        boolean isReactive = "org.springframework.web.reactive.function.server.RouterFunction".equals(parent.getSpringBean().getBeanType());
        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
        Module module = parent.getSpringBean().getModule();
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        SpringMvcFunctionalUtil.processRouterFunctionUrlMappings(parent.getSpringBean(), isReactive, module, (Processor<UrlMappingElement>)((Processor)collectProcessor));
        ArrayList<SpringFunctionalMappingPresentationLogicalMapping> mappings = new ArrayList<SpringFunctionalMappingPresentationLogicalMapping>();
        for (UrlMappingElement urlMappingElement : collectProcessor.getResults()) {
            List list;
            List list2;
            String pathPresentation = UrlMappingElement.getPathPresentation(urlMappingElement);
            if (pathPresentation == null) continue;
            if (urlMappingElement.getMethod() != null) {
                void $this$mapTo$iv$iv;
                RequestMethod[] $this$map$iv;
                boolean $i$f$map = false;
                RequestMethod[] requestMethodArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var19_20 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.name());
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = list = null;
            }
            if (list2 == null) {
                list = CollectionsKt.emptyList();
            }
            List httpMethods = list;
            HttpMethodPresentation http = new HttpMethodPresentation(pathPresentation, httpMethods, null, SpringApiIcons.RequestMapping, null);
            mappings.add(new SpringFunctionalMappingPresentationLogicalMapping(http, urlMappingElement.getNavigationTarget()));
        }
        List $this$sortBy$iv = mappings;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    SpringFunctionalMappingPresentationLogicalMapping it = (SpringFunctionalMappingPresentationLogicalMapping)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(PsiTreeUtilKt.getStartOffset((PsiElement)it.getNavigationElement()));
                    it = (SpringFunctionalMappingPresentationLogicalMapping)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(PsiTreeUtilKt.getStartOffset((PsiElement)it.getNavigationElement())));
                }
            });
        }
        return mappings;
    }
}

