/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.functional.utils;

import com.intellij.openapi.module.Module;
import com.intellij.patterns.uast.UCallExpressionPattern;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.SearchScope;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringFunctionalSearchersUtils;
import com.intellij.spring.mvc.functional.utils.FunctionalMvcProcessingContext;
import com.intellij.spring.mvc.functional.utils.SpringMvcFunctionalPatterns;
import com.intellij.spring.mvc.functional.utils.SpringMvcFunctionalSearchers;
import com.intellij.spring.mvc.functional.utils.SpringMvcFunctionalUtil;
import com.intellij.spring.mvc.mapping.UrlMappingElement;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UastUtils;

public final class SpringWebfluxKotlinDslUtil {
    public static boolean processKotlinDsl(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context) {
        if (processor == null) {
            SpringWebfluxKotlinDslUtil.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SpringWebfluxKotlinDslUtil.$$$reportNull$$$0(1);
        }
        if (!SpringWebfluxKotlinDslUtil.processReactiveKotlinDsl(processor, context)) {
            return false;
        }
        return SpringWebfluxKotlinDslUtil.processServletKotlinDsl(processor, context);
    }

    private static boolean processReactiveKotlinDsl(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context) {
        if (processor == null) {
            SpringWebfluxKotlinDslUtil.$$$reportNull$$$0(2);
        }
        if (context == null) {
            SpringWebfluxKotlinDslUtil.$$$reportNull$$$0(3);
        }
        PsiClass requestPredicatesClass = SpringWebfluxKotlinDslUtil.findRequestPredicatesDslClass(context.module, "org.springframework.web.reactive.function.server.RouterFunctionDsl");
        PsiClass requestCoPredicatesClass = SpringWebfluxKotlinDslUtil.findRequestPredicatesDslClass(context.module, "org.springframework.web.reactive.function.server.CoRouterFunctionDsl");
        if (requestPredicatesClass == null && requestCoPredicatesClass == null) {
            return true;
        }
        return SpringMvcFunctionalUtil.processRouterPredicates(processor, context, requestPredicatesClass, SpringWebfluxKotlinDslUtil.getReactiveKotlinDslNestCallExpressions(context)) && SpringMvcFunctionalUtil.processRouterPredicates(processor, context, requestCoPredicatesClass, SpringWebfluxKotlinDslUtil.getCoroutineReactiveKotlinDslNestCallExpressions(context));
    }

    private static boolean processServletKotlinDsl(@NotNull Processor<UrlMappingElement> processor, @NotNull FunctionalMvcProcessingContext context) {
        if (processor == null) {
            SpringWebfluxKotlinDslUtil.$$$reportNull$$$0(4);
        }
        if (context == null) {
            SpringWebfluxKotlinDslUtil.$$$reportNull$$$0(5);
        }
        PsiClass requestPredicatesClass = SpringWebfluxKotlinDslUtil.findRequestPredicatesDslClass(context.module, "org.springframework.web.servlet.function.RouterFunctionDsl");
        PsiClass requestCoPredicatesClass = SpringWebfluxKotlinDslUtil.findRequestPredicatesDslClass(context.module, "org.springframework.web.servlet.function.CoRouterFunctionDsl");
        if (requestPredicatesClass == null && requestCoPredicatesClass == null) {
            return true;
        }
        return SpringMvcFunctionalUtil.processRouterPredicates(processor, context, requestPredicatesClass, SpringWebfluxKotlinDslUtil.getServletKotlinDslNestCallExpressions(context)) && SpringMvcFunctionalUtil.processRouterPredicates(processor, context, requestCoPredicatesClass, SpringWebfluxKotlinDslUtil.getCoroutineServletKotlinDslNestCallExpressions(context));
    }

    public static Stream<UCallExpression> getKotlinDslNestCallExpressions(@NotNull FunctionalMvcProcessingContext context) {
        if (context == null) {
            SpringWebfluxKotlinDslUtil.$$$reportNull$$$0(6);
        }
        return Stream.of(SpringWebfluxKotlinDslUtil.getReactiveKotlinDslNestCallExpressions(context), SpringWebfluxKotlinDslUtil.getServletKotlinDslNestCallExpressions(context), SpringWebfluxKotlinDslUtil.getCoroutineReactiveKotlinDslNestCallExpressions(context), SpringWebfluxKotlinDslUtil.getCoroutineServletKotlinDslNestCallExpressions(context)).flatMap(Collection::stream);
    }

    @NotNull
    private static Set<UCallExpression> getReactiveKotlinDslNestCallExpressions(@NotNull FunctionalMvcProcessingContext context) {
        if (context == null) {
            SpringWebfluxKotlinDslUtil.$$$reportNull$$$0(7);
        }
        return SpringWebfluxKotlinDslUtil.getKotlinDslNestCallExpressions(context, SpringMvcFunctionalSearchers.findReactiveRouterFunctionDslNestMethods(context.module), SpringMvcFunctionalPatterns.ROUTER_DSL_METHOD_PATTERN);
    }

    @NotNull
    private static Set<UCallExpression> getServletKotlinDslNestCallExpressions(@NotNull FunctionalMvcProcessingContext context) {
        if (context == null) {
            SpringWebfluxKotlinDslUtil.$$$reportNull$$$0(8);
        }
        return SpringWebfluxKotlinDslUtil.getKotlinDslNestCallExpressions(context, SpringMvcFunctionalSearchers.findServletRouterFunctionDslNestMethods(context.module), SpringMvcFunctionalPatterns.ROUTER_DSL_METHOD_PATTERN);
    }

    @NotNull
    private static Set<UCallExpression> getCoroutineReactiveKotlinDslNestCallExpressions(@NotNull FunctionalMvcProcessingContext context) {
        if (context == null) {
            SpringWebfluxKotlinDslUtil.$$$reportNull$$$0(9);
        }
        return SpringWebfluxKotlinDslUtil.getKotlinDslNestCallExpressions(context, SpringMvcFunctionalSearchers.findReactiveCoRouterFunctionDslNestMethods(context.module), SpringMvcFunctionalPatterns.COROUTER_DSL_METHOD_PATTERN);
    }

    @NotNull
    private static Set<UCallExpression> getCoroutineServletKotlinDslNestCallExpressions(@NotNull FunctionalMvcProcessingContext context) {
        if (context == null) {
            SpringWebfluxKotlinDslUtil.$$$reportNull$$$0(10);
        }
        return SpringWebfluxKotlinDslUtil.getKotlinDslNestCallExpressions(context, SpringMvcFunctionalSearchers.findServletCoRouterFunctionDslNestMethods(context.module), SpringMvcFunctionalPatterns.COROUTER_DSL_METHOD_PATTERN);
    }

    @NotNull
    private static Set<UCallExpression> getKotlinDslNestCallExpressions(@NotNull FunctionalMvcProcessingContext context, PsiMethod[] nestMethods, UCallExpressionPattern dslMethodPattern) {
        if (context == null) {
            SpringWebfluxKotlinDslUtil.$$$reportNull$$$0(11);
        }
        HashSet<UCallExpression> nestDefinitions = new HashSet<UCallExpression>();
        for (PsiMethod nestMethod : nestMethods) {
            for (UCallExpression uCallExpression : SpringFunctionalSearchersUtils.findMethodCallsWithSearchService((PsiMethod)nestMethod, (SearchScope)context.localSearchScope)) {
                UCallExpression callExpression;
                ULambdaExpression uLambdaExpression = (ULambdaExpression)UastUtils.getParentOfType((UElement)uCallExpression, ULambdaExpression.class);
                if (uLambdaExpression == null || (callExpression = (UCallExpression)UastUtils.getParentOfType((UElement)uCallExpression, UCallExpression.class)) == null || !dslMethodPattern.accepts((Object)callExpression)) continue;
                nestDefinitions.add(uCallExpression);
            }
        }
        HashSet<UCallExpression> hashSet = nestDefinitions;
        if (hashSet == null) {
            SpringWebfluxKotlinDslUtil.$$$reportNull$$$0(12);
        }
        return hashSet;
    }

    private static PsiClass findRequestPredicatesDslClass(@Nullable Module module, @NotNull String fqn) {
        if (fqn == null) {
            SpringWebfluxKotlinDslUtil.$$$reportNull$$$0(13);
        }
        return module == null ? null : SpringCommonUtils.findLibraryClass((Module)module, (String)fqn);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/functional/utils/SpringWebfluxKotlinDslUtil";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/functional/utils/SpringWebfluxKotlinDslUtil";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getKotlinDslNestCallExpressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processKotlinDsl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processReactiveKotlinDsl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processServletKotlinDsl";
                break;
            }
            case 6: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getKotlinDslNestCallExpressions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getReactiveKotlinDslNestCallExpressions";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getServletKotlinDslNestCallExpressions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCoroutineReactiveKotlinDslNestCallExpressions";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCoroutineServletKotlinDslNestCallExpressions";
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findRequestPredicatesDslClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12 -> new IllegalStateException(string);
        };
    }
}

