/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.debugger.agent;

import com.intellij.rt.debugger.agent.CaptureAgent;
import com.intellij.rt.debugger.agent.ClassTransformer;
import com.intellij.rt.debugger.agent.LogCaptureStorage;
import java.io.FileOutputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.security.ProtectionDomain;
import org.jetbrains.capture.org.objectweb.asm.ClassVisitor;
import org.jetbrains.capture.org.objectweb.asm.MethodVisitor;

class LogCaptureTransformer
implements ClassFileTransformer {
    static final String CLASS_NAME = CaptureAgent.getInternalClsName(FileOutputStream.class);

    LogCaptureTransformer() {
    }

    public static void init(Instrumentation instrumentation) {
        if (!Boolean.getBoolean("debugger.agent.enable.log.capture")) {
            return;
        }
        if (!LogCaptureStorage.init()) {
            return;
        }
        instrumentation.addTransformer(new LogCaptureTransformer(), true);
        for (Class aClass : instrumentation.getAllLoadedClasses()) {
            if (!CLASS_NAME.equals(CaptureAgent.getInternalClsName(aClass))) continue;
            try {
                instrumentation.retransformClasses(aClass);
            }
            catch (UnmodifiableClassException e) {
                System.err.println("Debugger agent, log capture: cannot retransform class " + aClass.getName());
                e.printStackTrace(System.err);
            }
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        if (CLASS_NAME.equals(className)) {
            try {
                ClassTransformer transformer = new ClassTransformer(className, classfileBuffer, 2, loader);
                return transformer.accept(new ClassVisitor(589824, transformer.writer){

                    @Override
                    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                        boolean isWithOffset;
                        MethodVisitor superMethodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
                        if (!"write".equals(name)) {
                            return superMethodVisitor;
                        }
                        switch (descriptor) {
                            case "([B)V": {
                                isWithOffset = false;
                                break;
                            }
                            case "([BII)V": {
                                isWithOffset = true;
                                break;
                            }
                            default: {
                                return superMethodVisitor;
                            }
                        }
                        return new MethodVisitor(this.api, superMethodVisitor){

                            @Override
                            public void visitCode() {
                                super.visitCode();
                                this.mv.visitVarInsn(25, 0);
                                this.mv.visitFieldInsn(180, "java/io/FileOutputStream", "fd", "Ljava/io/FileDescriptor;");
                                this.mv.visitVarInsn(25, 1);
                                if (isWithOffset) {
                                    this.mv.visitVarInsn(21, 2);
                                    this.mv.visitVarInsn(21, 3);
                                }
                                this.mv.visitMethodInsn(184, CaptureAgent.getInternalClsName(LogCaptureStorage.class), "capture", "(Ljava/io/FileDescriptor;[B" + (isWithOffset ? "II" : "") + ")V", false);
                            }
                        };
                    }
                }, 0, true);
            }
            catch (Exception e) {
                System.err.println("Capture agent: failed to instrument " + className);
                e.printStackTrace(System.err);
            }
        }
        return null;
    }
}

