/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.debugger.agent;

import com.intellij.rt.debugger.agent.CaptureAgent;
import com.intellij.rt.debugger.agent.ClassTransformer;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import org.jetbrains.capture.org.objectweb.asm.ClassVisitor;
import org.jetbrains.capture.org.objectweb.asm.MethodVisitor;
import org.jetbrains.capture.org.objectweb.asm.Type;

public class TailCallContinuationTransformer {
    public static void init(Instrumentation instrumentation) {
        if (Boolean.getBoolean("debugger.agent.enable.coroutines")) {
            instrumentation.addTransformer(new TailCallTransformer(), true);
        }
    }

    private static class TailCallTransformer
    implements ClassFileTransformer {
        private static final String WRAP_CONTINUATION_REAL_DESC = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I[Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Lkotlin/coroutines/Continuation;";

        private TailCallTransformer() {
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
            if (!"kotlin/coroutines/jvm/internal/TailCallAsyncStackTraceEntryKt".equals(className)) {
                return classfileBuffer;
            }
            try {
                ClassTransformer transformer = new ClassTransformer(className, classfileBuffer, 2, loader);
                final boolean[] wrapContinuationRealIsPresent = new boolean[]{false};
                byte[] bytes = transformer.accept(new ClassVisitor(589824, transformer.writer){

                    @Override
                    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                        MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
                        switch (name) {
                            case "wrapContinuationReal": {
                                if (descriptor.equals(TailCallTransformer.WRAP_CONTINUATION_REAL_DESC)) {
                                    wrapContinuationRealIsPresent[0] = true;
                                    break;
                                }
                            }
                            case "wrapContinuation": {
                                int argumentCount = Type.getArgumentCount(descriptor);
                                if (argumentCount != 6) {
                                    System.err.println("TailCallContinuationTransformer: expected 6 arguments in TailCallAsyncStackTraceEntryKt#wrapContinuation, but got " + argumentCount + ", descriptor = " + descriptor);
                                    break;
                                }
                                return new MethodVisitor(this.api, mv){

                                    @Override
                                    public void visitCode() {
                                        super.visitCode();
                                        this.mv.visitVarInsn(25, 0);
                                        this.mv.visitVarInsn(25, 1);
                                        this.mv.visitVarInsn(25, 2);
                                        this.mv.visitVarInsn(21, 3);
                                        this.mv.visitVarInsn(25, 4);
                                        this.mv.visitVarInsn(25, 5);
                                        this.mv.visitMethodInsn(184, "kotlin/coroutines/jvm/internal/TailCallAsyncStackTraceEntryKt", "wrapContinuationReal", TailCallTransformer.WRAP_CONTINUATION_REAL_DESC, false);
                                        this.mv.visitInsn(176);
                                        this.mv.visitFrame(3, 0, null, 0, null);
                                        this.mv.visitMaxs(2, 6);
                                        this.mv.visitEnd();
                                    }
                                };
                            }
                        }
                        return mv;
                    }
                }, 0, false);
                if (!wrapContinuationRealIsPresent[0]) {
                    return classfileBuffer;
                }
                CaptureAgent.storeClassForDebug(className, bytes);
                return bytes;
            }
            catch (Exception e) {
                System.out.println("TailCallContinuationTransformer: failed to instrument " + className);
                e.printStackTrace();
                return null;
            }
        }
    }
}

