/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.util.containers.CollectionFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.Mappings;
import org.jetbrains.debugger.sourcemap.NestedMappingEntry;
import org.jetbrains.debugger.sourcemap.NestedMappings;
import org.jetbrains.debugger.sourcemap.SourceFileResolver;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.debugger.sourcemap.SourceResolver;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001dH\u0016J4\u0010(\u001a\u00020'2\u0006\u0010,\u001a\u00020\f2\b\u0010)\u001a\u0004\u0018\u00010*2\u0010\u0010-\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010/\u0018\u00010.2\u0006\u0010+\u001a\u00020\u001dH\u0016J\u001e\u00100\u001a\b\u0012\u0004\u0012\u00020\u0014012\u0006\u0010&\u001a\u00020'2\u0006\u00102\u001a\u00020'H\u0016J\u0012\u00103\u001a\u0004\u0018\u00010\u00192\u0006\u00104\u001a\u00020\u0014H\u0016J\u0012\u00105\u001a\u0004\u0018\u00010\u00192\u0006\u00104\u001a\u00020\u0014H\u0016J\u0012\u00105\u001a\u0004\u0018\u00010\u00192\u0006\u0010&\u001a\u00020'H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011RV\u0010\u0012\u001aJ\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u0014\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u0014 \u0015*#\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u0014\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u00140\u0017\u00a2\u0006\u0002\b\u00160\u0013\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001b\u0010 \u001a\u00020\u00108VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b!\u0010\"\u00a8\u00066"}, d2={"Lorg/jetbrains/debugger/sourcemap/NestedSourceMap;", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "childMap", "parentMap", "<init>", "(Lorg/jetbrains/debugger/sourcemap/SourceMap;Lorg/jetbrains/debugger/sourcemap/SourceMap;)V", "sourceResolver", "Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "getSourceResolver", "()Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "sources", "", "Lcom/intellij/util/Url;", "getSources", "()[Lcom/intellij/util/Url;", "sourceIndexToSourceMappings", "Lorg/jetbrains/debugger/sourcemap/Mappings;", "[Lorg/jetbrains/debugger/sourcemap/Mappings;", "childMappingToTransformed", "", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "outFile", "", "getOutFile", "()Ljava/lang/String;", "hasNameMappings", "", "getHasNameMappings", "()Z", "generatedMappings", "getGeneratedMappings", "()Lorg/jetbrains/debugger/sourcemap/Mappings;", "generatedMappings$delegate", "Lkotlin/Lazy;", "findSourceMappings", "sourceIndex", "", "findSourceIndex", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "localFileUrlOnly", "sourceUrl", "resolver", "Lkotlin/Lazy;", "Lorg/jetbrains/debugger/sourcemap/SourceFileResolver;", "getSourceMappingsInLine", "", "sourceLine", "getRawSource", "entry", "getSourceContent", "intellij.platform.scriptDebugger.backend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nNestedSourceMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NestedSourceMap.kt\norg/jetbrains/debugger/sourcemap/NestedSourceMap\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,109:1\n1391#2:110\n1480#2,2:111\n1482#2,3:120\n383#3,7:113\n*S KotlinDebug\n*F\n+ 1 NestedSourceMap.kt\norg/jetbrains/debugger/sourcemap/NestedSourceMap\n*L\n49#1:110\n49#1:111,2\n49#1:120,3\n56#1:113,7\n*E\n"})
public final class NestedSourceMap
implements SourceMap {
    @NotNull
    private final SourceMap childMap;
    @NotNull
    private final SourceMap parentMap;
    @NotNull
    private final Mappings[] sourceIndexToSourceMappings;
    @NotNull
    private final Map<MappingEntry, MappingEntry> childMappingToTransformed;
    @NotNull
    private final Lazy generatedMappings$delegate;

    public NestedSourceMap(@NotNull SourceMap childMap, @NotNull SourceMap parentMap) {
        Intrinsics.checkNotNullParameter((Object)childMap, (String)"childMap");
        Intrinsics.checkNotNullParameter((Object)parentMap, (String)"parentMap");
        this.childMap = childMap;
        this.parentMap = parentMap;
        this.sourceIndexToSourceMappings = new Mappings[this.parentMap.getSources().length];
        Map map = CollectionFactory.createSmallMemoryFootprintMap();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"createSmallMemoryFootprintMap(...)");
        this.childMappingToTransformed = map;
        this.generatedMappings$delegate = LazyKt.lazy(() -> NestedSourceMap.generatedMappings_delegate$lambda$0(this));
    }

    @Override
    @NotNull
    public SourceResolver getSourceResolver() {
        return this.parentMap.getSourceResolver();
    }

    @Override
    @NotNull
    public Url[] getSources() {
        return this.parentMap.getSources();
    }

    @Override
    @Nullable
    public String getOutFile() {
        return this.childMap.getOutFile();
    }

    @Override
    public boolean getHasNameMappings() {
        return this.childMap.getHasNameMappings() || this.parentMap.getHasNameMappings();
    }

    @Override
    @NotNull
    public Mappings getGeneratedMappings() {
        Lazy lazy = this.generatedMappings$delegate;
        return (Mappings)lazy.getValue();
    }

    @Override
    @NotNull
    public Mappings findSourceMappings(int sourceIndex) {
        Mappings result = this.sourceIndexToSourceMappings[sourceIndex];
        if (result == null) {
            this.sourceIndexToSourceMappings[sourceIndex] = result = (Mappings)new NestedMappings(this.childMap.findSourceMappings(sourceIndex), this.parentMap.findSourceMappings(sourceIndex), true);
        }
        return result;
    }

    @Override
    public int findSourceIndex(@NotNull VirtualFile sourceFile, boolean localFileUrlOnly) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        return this.parentMap.findSourceIndex(sourceFile, localFileUrlOnly);
    }

    @Override
    public int findSourceIndex(@NotNull Url sourceUrl, @Nullable VirtualFile sourceFile, @Nullable Lazy<? extends SourceFileResolver> resolver, boolean localFileUrlOnly) {
        Intrinsics.checkNotNullParameter((Object)sourceUrl, (String)"sourceUrl");
        return this.parentMap.findSourceIndex(sourceUrl, sourceFile, resolver, localFileUrlOnly);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<MappingEntry> getSourceMappingsInLine(int sourceIndex, int sourceLine) {
        void $this$flatMapTo$iv$iv;
        Mappings childSourceMappings = this.childMap.findSourceMappings(sourceIndex);
        Mappings mappings = this.parentMap.findSourceMappings(sourceIndex);
        Intrinsics.checkNotNull((Object)mappings, (String)"null cannot be cast to non-null type org.jetbrains.debugger.sourcemap.MappingList");
        Iterable<MappingEntry> $this$flatMap$iv = ((MappingList)mappings).getMappingsInLine(sourceLine);
        boolean $i$f$flatMap = false;
        Iterable<MappingEntry> iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.iterator();
        if (iterator.hasNext()) {
            Object object;
            void $this$getOrPut$iv;
            Object element$iv$iv = iterator.next();
            MappingEntry entry = (MappingEntry)element$iv$iv;
            boolean bl = false;
            int childIndex = childSourceMappings.indexOf(entry.getGeneratedLine(), entry.getGeneratedColumn());
            if (childIndex == -1) {
                return CollectionsKt.emptyList();
            }
            MappingEntry childEntry = childSourceMappings.getByIndex(childIndex);
            Map<MappingEntry, MappingEntry> map = this.childMappingToTransformed;
            MappingEntry key$iv = childEntry;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                MappingEntry answer$iv = new NestedMappingEntry(childEntry, entry);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return CollectionsKt.listOf(object);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public String getRawSource(@NotNull MappingEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        return this.parentMap.getRawSource(entry);
    }

    @Override
    @Nullable
    public String getSourceContent(@NotNull MappingEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        return this.parentMap.getSourceContent(entry);
    }

    @Override
    @Nullable
    public String getSourceContent(int sourceIndex) {
        return this.parentMap.getSourceContent(sourceIndex);
    }

    private static final NestedMappings generatedMappings_delegate$lambda$0(NestedSourceMap this$0) {
        return new NestedMappings(this$0.childMap.getGeneratedMappings(), this$0.parentMap.getGeneratedMappings(), false);
    }
}

