/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.util;

import com.openhtmltopdf.util.LogMessageId;
import java.util.logging.Level;

public class Diagnostic {
    private final Level level;
    private final LogMessageId logMessageId;
    private final Object[] args;
    private final Throwable error;

    Diagnostic(Level level, LogMessageId logMessageId, boolean hasError, Object[] args) {
        this.level = level;
        this.logMessageId = logMessageId;
        this.args = args;
        this.error = hasError ? (Throwable)args[args.length - 1] : null;
    }

    public LogMessageId getLogMessageId() {
        return this.logMessageId;
    }

    public Level getLevel() {
        return this.level;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public Throwable getError() {
        return this.error;
    }

    public String getFormattedMessage() {
        return this.logMessageId.formatMessage(this.args);
    }

    public Object[] getArgs() {
        return this.args;
    }
}

