/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.explorer.structure;

import com.intellij.database.Dbms;
import com.intellij.database.explorer.structure.DbTreeNodeDecoration;
import com.intellij.database.explorer.structure.DvDecorationExtension;
import com.intellij.database.explorer.structure.DvTreeStoreyLayer;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0015\u0010\u0010\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/explorer/structure/DvTreePresentationLayer;", "Lcom/intellij/database/explorer/structure/DvTreeStoreyLayer;", "<init>", "()V", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "getName", "()Ljava/lang/String;", "parentOf", "Lcom/intellij/database/model/basic/BasicNode;", "node", "childrenOf", "Lkotlin/sequences/Sequence;", "isAlwaysLeaf", "", "presentableNameOf", "decorationOf", "Lcom/intellij/database/explorer/structure/DbTreeNodeDecoration;", "getPrimaryDecoration", "getPrimaryDecorationFor", "element", "Lcom/intellij/database/model/basic/BasicElement;", "askExtensionPoints", "decoration", "clearAll", "", "intellij.database.core.impl"})
public final class DvTreePresentationLayer
extends DvTreeStoreyLayer {
    @NotNull
    private final String name;

    public DvTreePresentationLayer() {
        this.name = "Presentation";
    }

    @Override
    @NotNull
    protected String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public BasicNode parentOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.getBase().parentOf(node);
    }

    @Override
    @NotNull
    public Sequence<BasicNode> childrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.getBase().childrenOf(node);
    }

    @Override
    public boolean isAlwaysLeaf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.getBase().isAlwaysLeaf(node);
    }

    @Override
    @NotNull
    public String presentableNameOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.getBase().presentableNameOf(node);
    }

    @Override
    @NotNull
    public DbTreeNodeDecoration decorationOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        DbTreeNodeDecoration primary = this.getPrimaryDecoration(node);
        DbTreeNodeDecoration decoration = this.askExtensionPoints(node, primary);
        return decoration;
    }

    private final DbTreeNodeDecoration getPrimaryDecoration(BasicNode node) {
        DbTreeNodeDecoration primaryDecoration = node instanceof BasicElement ? this.getPrimaryDecorationFor((BasicElement)node) : null;
        DbTreeNodeDecoration dbTreeNodeDecoration = primaryDecoration;
        if (dbTreeNodeDecoration == null) {
            dbTreeNodeDecoration = DbTreeNodeDecoration.PLAIN;
        }
        return dbTreeNodeDecoration;
    }

    private final DbTreeNodeDecoration getPrimaryDecorationFor(BasicElement element) {
        BasicModel basicModel = element.getModel();
        if (basicModel == null || (basicModel = basicModel.getDbms()) == null) {
            return null;
        }
        BasicModel dbms = basicModel;
        DescriptionService descriptionService = ModelFacade.forDbms((Dbms)dbms).getDescriptionService();
        Intrinsics.checkNotNullExpressionValue((Object)descriptionService, (String)"getDescriptionService(...)");
        DescriptionService descriptionService2 = descriptionService;
        DbTreeNodeDecoration primaryDecoration = descriptionService2.getNodeDecoration(element, this.getContext().vo);
        return primaryDecoration;
    }

    private final DbTreeNodeDecoration askExtensionPoints(BasicNode node, DbTreeNodeDecoration decoration) {
        List extensions = DvDecorationExtension.Companion.getEP().getExtensionList();
        DbTreeNodeDecoration theDecoration = decoration;
        for (DvDecorationExtension extension : extensions) {
            DbTreeNodeDecoration d = extension.decorate(node, decoration);
            if (d == null) continue;
            theDecoration = d;
        }
        return theDecoration;
    }

    @Override
    public void clearAll() {
    }
}

