/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.modulith.highlighting.quickFix;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.spring.modulith.SpringModulithBundle;
import com.intellij.spring.modulith.highlighting.quickFix.SpringModulithHighlightingFixService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\r\u0010\r\u001a\u00070\u0003\u00a2\u0006\u0002\b\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/spring/modulith/highlighting/quickFix/SpringModulithAddAllowedDependencyFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "moduleId", "", "dependency", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "previewDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "applyFix", "", "descriptor", "intellij.spring.modulith"})
public final class SpringModulithAddAllowedDependencyFix
implements LocalQuickFix {
    @NotNull
    private final String moduleId;
    @NotNull
    private final String dependency;

    public SpringModulithAddAllowedDependencyFix(@NotNull String moduleId, @NotNull String dependency) {
        Intrinsics.checkNotNullParameter((Object)moduleId, (String)"moduleId");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        this.moduleId = moduleId;
        this.dependency = dependency;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{this.dependency, this.moduleId};
        return SpringModulithBundle.message("quickfix.add.allowed.dependency", objectArray);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)descriptor.getPsiElement());
        if (module == null) {
            return;
        }
        Module module2 = module;
        SpringModulithHighlightingFixService.Companion.getInstance(project).addAllowedDependency$intellij_spring_modulith(this.moduleId, this.dependency, module2);
    }
}

