/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.modulith.structure.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.util.PsiUtilCore;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lcom/intellij/spring/modulith/structure/model/SpringModulithNamedInterfaceModel;", "Lcom/intellij/psi/PsiTarget;", "name", "", "basePackage", "types", "", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lcom/intellij/openapi/module/Module;)V", "getName", "()Ljava/lang/String;", "getBasePackage", "getTypes", "()Ljava/util/List;", "getModule", "()Lcom/intellij/openapi/module/Module;", "isValid", "", "getNavigationElement", "Lcom/intellij/psi/PsiElement;", "intellij.spring.modulith"})
public final class SpringModulithNamedInterfaceModel
implements PsiTarget {
    @NotNull
    private final String name;
    @NotNull
    private final String basePackage;
    @NotNull
    private final List<String> types;
    @NotNull
    private final Module module;

    public SpringModulithNamedInterfaceModel(@NotNull String name, @NotNull String basePackage, @NotNull List<String> types, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)basePackage, (String)"basePackage");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.name = name;
        this.basePackage = basePackage;
        this.types = types;
        this.module = module;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getBasePackage() {
        return this.basePackage;
    }

    @NotNull
    public final List<String> getTypes() {
        return this.types;
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    public boolean isValid() {
        return true;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)this.module.getProject()).findPackage(this.basePackage);
        if (psiPackage == null) {
            PsiElement psiElement = PsiUtilCore.NULL_PSI_ELEMENT;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"NULL_PSI_ELEMENT");
            return psiElement;
        }
        return (PsiElement)psiPackage;
    }
}

