/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javascript.jest.JestConfigurationType;
import com.intellij.javascript.jest.JestDetector;
import com.intellij.javascript.jest.JestRunConfiguration;
import com.intellij.javascript.jest.JestRunSettings;
import com.intellij.javascript.jest.JestUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.JsTestElementPath;
import com.intellij.javascript.testing.runConfiguration.JsTestRunConfigurationProducer;
import com.intellij.javascript.testing.runScope.JsTestRunScope;
import com.intellij.javascript.testing.runScope.JsTestRunScopeKind;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonCommonUtil;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 /2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003-./B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u001e\u0010\u0016\u001a\b\u0018\u00010\u0017R\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0014H\u0002J\u001e\u0010\u001a\u001a\b\u0018\u00010\u0017R\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\u001dH\u0002J\u0016\u0010\u001e\u001a\b\u0018\u00010\u0017R\u00020\u00002\u0006\u0010\f\u001a\u00020\u001dH\u0002J\u0016\u0010\u001f\u001a\b\u0018\u00010\u0017R\u00020\u00002\u0006\u0010\f\u001a\u00020\u001dH\u0002J\u0016\u0010 \u001a\b\u0018\u00010\u0017R\u00020\u00002\u0006\u0010\f\u001a\u00020\u001dH\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0018\u001a\u00020\u0010H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0018\u001a\u00020\u0010H\u0002J\u0018\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020&J \u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002\u00a8\u00060"}, d2={"Lcom/intellij/javascript/jest/JestRunConfigurationProducer;", "Lcom/intellij/javascript/testing/runConfiguration/JsTestRunConfigurationProducer;", "Lcom/intellij/javascript/jest/JestRunConfiguration;", "<init>", "()V", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "getTestFrameworkDetector", "Lcom/intellij/javascript/jest/JestDetector;", "setupConfigurationFromCompatibleContext", "", "configuration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "isConfigurationFromCompatibleContext", "areConfigFilesEffectivelySame", "generatedSettings", "Lcom/intellij/javascript/jest/JestRunSettings;", "existingSettings", "buildContextSettings", "Lcom/intellij/javascript/jest/JestRunConfigurationProducer$ExtendedSettings;", "element", "templateRunSettings", "buildDirectorySettings", "psiDirectory", "Lcom/intellij/psi/PsiDirectory;", "Lcom/intellij/javascript/jest/JestRunConfigurationProducer$Context;", "buildSuiteOrTestSettings", "buildConfigSettings", "buildTestFileSettings", "findContextSuiteOrTestPath", "Lcom/intellij/javascript/testFramework/JsTestElementPath;", "getContainingJsFile", "Lcom/intellij/lang/javascript/psi/JSFile;", "guessWorkingDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "contextFile", "fixWorkingDir", "settings", "contextFileOrDir", "ExtendedSettings", "Context", "Companion", "intellij.javascript.ultimate"})
public class JestRunConfigurationProducer
extends JsTestRunConfigurationProducer<JestRunConfiguration> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        JestConfigurationType jestConfigurationType = JestConfigurationType.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)jestConfigurationType), (String)"getInstance(...)");
        return (ConfigurationFactory)jestConfigurationType;
    }

    @NotNull
    public JestDetector getTestFrameworkDetector() {
        return JestDetector.Companion.getInstance();
    }

    protected boolean setupConfigurationFromCompatibleContext(@NotNull JestRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        PsiElement element = context.getPsiLocation();
        if (element == null || !this.isTestRunnerAvailableFor(element, context)) {
            return false;
        }
        JestRunSettings jestRunSettings = configuration.getRunSettings();
        Intrinsics.checkNotNullExpressionValue((Object)jestRunSettings, (String)"getRunSettings(...)");
        ExtendedSettings extendedSettings = this.buildContextSettings(element, jestRunSettings);
        if (extendedSettings == null) {
            return false;
        }
        ExtendedSettings extendedSettings2 = extendedSettings;
        configuration.setRunSettings(extendedSettings2.getSettings());
        sourceElement.set((Object)extendedSettings2.getEnclosingElement());
        configuration.setGeneratedName();
        return true;
    }

    protected boolean isConfigurationFromCompatibleContext(@NotNull JestRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PsiElement psiElement = context.getPsiLocation();
        if (psiElement == null) {
            return false;
        }
        PsiElement element = psiElement;
        RunConfiguration runConfiguration = this.cloneTemplateConfiguration(context).getConfiguration();
        JestRunConfiguration jestRunConfiguration = runConfiguration instanceof JestRunConfiguration ? (JestRunConfiguration)runConfiguration : null;
        if (jestRunConfiguration == null) {
            return false;
        }
        JestRunConfiguration templateConfiguration = jestRunConfiguration;
        JestRunSettings jestRunSettings = templateConfiguration.getRunSettings();
        Intrinsics.checkNotNullExpressionValue((Object)jestRunSettings, (String)"getRunSettings(...)");
        ExtendedSettings extendedSettings = this.buildContextSettings(element, jestRunSettings);
        if (extendedSettings == null) {
            return false;
        }
        ExtendedSettings extendedSettings2 = extendedSettings;
        JestRunSettings thisRunSettings = extendedSettings2.getSettings();
        JestRunSettings jestRunSettings2 = configuration.getRunSettings();
        Intrinsics.checkNotNullExpressionValue((Object)jestRunSettings2, (String)"getRunSettings(...)");
        JestRunSettings thatRunSettings = jestRunSettings2;
        return this.areConfigFilesEffectivelySame(thisRunSettings, thatRunSettings) && Intrinsics.areEqual((Object)thisRunSettings.getWorkingDirSystemDependentPath(), (Object)thatRunSettings.getWorkingDirSystemDependentPath()) && Intrinsics.areEqual((Object)thisRunSettings.getScope().normalize(), (Object)thatRunSettings.getScope().normalize());
    }

    private final boolean areConfigFilesEffectivelySame(JestRunSettings generatedSettings, JestRunSettings existingSettings) {
        return Intrinsics.areEqual((Object)generatedSettings.getConfigFileSystemDependentPath(), (Object)existingSettings.getConfigFileSystemDependentPath()) || ((CharSequence)generatedSettings.getConfigFileSystemDependentPath()).length() == 0 && ((CharSequence)existingSettings.getConfigFileSystemDependentPath()).length() > 0;
    }

    private final ExtendedSettings buildContextSettings(PsiElement element, JestRunSettings templateRunSettings) {
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (virtualFile == null) {
            return null;
        }
        Context context = new Context(element, element.getContainingFile(), virtualFile, templateRunSettings);
        if (element instanceof PsiDirectory) {
            return this.buildDirectorySettings((PsiDirectory)element, context);
        }
        ExtendedSettings extendedSettings = this.buildSuiteOrTestSettings(context);
        if (extendedSettings != null) {
            ExtendedSettings it = extendedSettings;
            boolean bl = false;
            return it;
        }
        extendedSettings = this.buildConfigSettings(context);
        if (extendedSettings != null) {
            ExtendedSettings it = extendedSettings;
            boolean bl = false;
            return it;
        }
        return this.buildTestFileSettings(context);
    }

    private final ExtendedSettings buildDirectorySettings(PsiDirectory psiDirectory, Context context) {
        VirtualFile virtualFile = context.getFile();
        Project project = psiDirectory.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (Intrinsics.areEqual((Object)virtualFile, (Object)ProjectUtil.guessProjectDir((Project)project)) || Companion.findDefaultConfigFile(context.getFile()) != null) {
            return new ExtendedSettings(context.getTemplateRunSettings().builder().scope((Function1<? super JsTestRunScope.Builder, Unit>)((Function1)JestRunConfigurationProducer::buildDirectorySettings$lambda$0)).build(), context.getFile(), (PsiElement)psiDirectory);
        }
        JestDetector jestDetector = this.getTestFrameworkDetector();
        Project project2 = psiDirectory.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        if (jestDetector.hasTestsUnderDirectory(project2, context.getFile())) {
            return new ExtendedSettings(context.getTemplateRunSettings().builder().scope((Function1<? super JsTestRunScope.Builder, Unit>)((Function1)arg_0 -> JestRunConfigurationProducer.buildDirectorySettings$lambda$1(context, arg_0))).build(), context.getFile(), (PsiElement)psiDirectory);
        }
        return null;
    }

    private final ExtendedSettings buildSuiteOrTestSettings(Context context) {
        JsTestElementPath jsTestElementPath = this.findContextSuiteOrTestPath(context.getElement());
        if (jsTestElementPath == null) {
            return null;
        }
        JsTestElementPath testPath = jsTestElementPath;
        JestRunSettings.Builder builder = context.getTemplateRunSettings().builder();
        JsTestRunScope.Builder builder2 = builder.getScope().builder();
        String string = context.getFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        builder.setScope(builder2.testFilePath(string).build());
        String testName = testPath.getTestName();
        if (testName == null) {
            JsTestRunScope.Builder builder3 = builder.getScope().builder().kind(JsTestRunScopeKind.SUITE);
            List list = testPath.getSuiteNames();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSuiteNames(...)");
            builder.setScope(builder3.testNames(list).build());
        } else {
            JsTestRunScope.Builder builder4 = builder.getScope().builder().kind(JsTestRunScopeKind.TEST);
            List list = testPath.getSuiteNames();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSuiteNames(...)");
            builder.setScope(builder4.testNames(CollectionsKt.plus((Collection)list, (Object)testName)).build());
        }
        JestRunSettings jestRunSettings = builder.build();
        VirtualFile virtualFile = context.getFile();
        PsiElement psiElement = testPath.getTestElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getTestElement(...)");
        return new ExtendedSettings(jestRunSettings, virtualFile, psiElement);
    }

    private final ExtendedSettings buildConfigSettings(Context context) {
        JsonProperty jestProp;
        if (context.getPsiFile() != null && JestUtil.isJestConfigFile(context.getFile().getName())) {
            JestRunSettings settings = context.getTemplateRunSettings().builder().scope((Function1<? super JsTestRunScope.Builder, Unit>)((Function1)JestRunConfigurationProducer::buildConfigSettings$lambda$0)).build();
            return new ExtendedSettings(settings, context.getFile(), (PsiElement)context.getPsiFile());
        }
        if (PackageJsonCommonUtil.isPackageJsonFile((PsiFile)context.getPsiFile()) && (jestProp = PackageJsonCommonUtil.findContainingTopLevelProperty((PsiElement)context.getElement())) != null && Intrinsics.areEqual((Object)"jest", (Object)jestProp.getName())) {
            JestRunSettings settings = context.getTemplateRunSettings().builder().scope((Function1<? super JsTestRunScope.Builder, Unit>)((Function1)JestRunConfigurationProducer::buildConfigSettings$lambda$1)).build();
            return new ExtendedSettings(settings, context.getFile(), (PsiElement)jestProp);
        }
        return null;
    }

    private final ExtendedSettings buildTestFileSettings(Context context) {
        PsiFile psiFile = context.getPsiFile();
        JSFile jSFile = psiFile instanceof JSFile ? (JSFile)psiFile : null;
        if (jSFile == null) {
            return null;
        }
        JSFile jsFile = jSFile;
        if (this.getTestFrameworkDetector().hasTestsInFile(jsFile)) {
            JestRunSettings.Builder builder = context.getTemplateRunSettings().builder().scope((Function1<? super JsTestRunScope.Builder, Unit>)((Function1)arg_0 -> JestRunConfigurationProducer.buildTestFileSettings$lambda$0(context, arg_0)));
            return new ExtendedSettings(builder.build(), context.getFile(), (PsiElement)context.getPsiFile());
        }
        return null;
    }

    private final JsTestElementPath findContextSuiteOrTestPath(PsiElement element) {
        AbstractTestFileStructure jestTestStructure;
        if (element instanceof PsiFileSystemItem) {
            return null;
        }
        JSFile jSFile = this.getContainingJsFile(element);
        if (jSFile == null) {
            return null;
        }
        JSFile jsFile = jSFile;
        TextRange textRange = element.getTextRange();
        if (textRange == null) {
            return null;
        }
        TextRange textRange2 = textRange;
        AbstractTestFileStructure abstractTestFileStructure = jestTestStructure = this.getTestFrameworkDetector().findTestsStructure(jsFile);
        return abstractTestFileStructure != null ? abstractTestFileStructure.findTestElementPath(textRange2) : null;
    }

    private final JSFile getContainingJsFile(PsiElement element) {
        PsiFile psiFile = element.getContainingFile();
        return psiFile instanceof JSFile ? (JSFile)psiFile : null;
    }

    @Nullable
    public final VirtualFile guessWorkingDir(@NotNull Project project, @NotNull VirtualFile contextFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
        Ref ref = Ref.create();
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"create(...)");
        Ref firstPackageJsonDir = ref;
        AtomicBoolean basedOnJestDeclaredDependency = new AtomicBoolean(false);
        VirtualFile workingDir = (VirtualFile)JSProjectUtil.processDirectoriesUpToContentRootAndFindFirst((Project)project, (VirtualFile)contextFile, arg_0 -> JestRunConfigurationProducer.guessWorkingDir$lambda$1(arg_0 -> JestRunConfigurationProducer.guessWorkingDir$lambda$0(firstPackageJsonDir, this, basedOnJestDeclaredDependency, project, arg_0), arg_0));
        VirtualFile firstPackageJson = (VirtualFile)firstPackageJsonDir.get();
        if (firstPackageJson != null && !Intrinsics.areEqual((Object)firstPackageJson, (Object)workingDir) && basedOnJestDeclaredDependency.get()) {
            return firstPackageJson;
        }
        return workingDir;
    }

    private final JestRunSettings fixWorkingDir(JestRunSettings settings, VirtualFile contextFileOrDir, Project project) {
        VirtualFile virtualFile;
        if (StringsKt.isBlank((CharSequence)settings.getWorkingDirSystemDependentPath()) && (virtualFile = this.guessWorkingDir(project, contextFileOrDir)) != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            JestRunSettings.Builder builder = settings.builder();
            String string = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            return builder.setWorkingDir(string).build();
        }
        return settings;
    }

    private static final Unit buildDirectorySettings$lambda$0(JsTestRunScope.Builder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.kind(JsTestRunScopeKind.ALL);
        return Unit.INSTANCE;
    }

    private static final Unit buildDirectorySettings$lambda$1(Context $context, JsTestRunScope.Builder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.kind(JsTestRunScopeKind.DIRECTORY);
        String string = $context.getFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        it.testDirectoryPath(string);
        return Unit.INSTANCE;
    }

    private static final Unit buildConfigSettings$lambda$0(JsTestRunScope.Builder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setKind(JsTestRunScopeKind.ALL);
        return Unit.INSTANCE;
    }

    private static final Unit buildConfigSettings$lambda$1(JsTestRunScope.Builder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setKind(JsTestRunScopeKind.ALL);
        return Unit.INSTANCE;
    }

    private static final Unit buildTestFileSettings$lambda$0(Context $context, JsTestRunScope.Builder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.kind(JsTestRunScopeKind.TEST_FILE);
        String string = $context.getFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        it.testFilePath(string);
        return Unit.INSTANCE;
    }

    private static final VirtualFile guessWorkingDir$lambda$0(Ref $firstPackageJsonDir, JestRunConfigurationProducer this$0, AtomicBoolean $basedOnJestDeclaredDependency, Project $project, VirtualFile dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        VirtualFile defaultConfigFile = Companion.findDefaultConfigFile(dir);
        if (defaultConfigFile != null) {
            return dir;
        }
        VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile((VirtualFile)dir);
        if (packageJson != null) {
            $firstPackageJsonDir.setIfNull((Object)dir);
            PackageJsonData packageJsonData = PackageJsonData.getOrCreate((VirtualFile)packageJson);
            Intrinsics.checkNotNullExpressionValue((Object)packageJsonData, (String)"getOrCreate(...)");
            PackageJsonData data = packageJsonData;
            JestDetector detector = this$0.getTestFrameworkDetector();
            if (detector.getPackageDescriptor().isFrameworkDeclaredInPackageJson(data)) {
                $basedOnJestDeclaredDependency.set(true);
                return dir;
            }
            if (JsTestRunConfigurationProducer.Companion.hasTestScript($project, packageJson, data)) {
                return dir;
            }
        }
        return null;
    }

    private static final VirtualFile guessWorkingDir$lambda$1(Function1 $tmp0, Object p0) {
        return (VirtualFile)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/javascript/jest/JestRunConfigurationProducer$Companion;", "", "<init>", "()V", "findDefaultConfigFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "dir", "intellij.javascript.ultimate"})
    @SourceDebugExtension(value={"SMAP\nJestRunConfigurationProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JestRunConfigurationProducer.kt\ncom/intellij/javascript/jest/JestRunConfigurationProducer$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,213:1\n184#2,2:214\n*S KotlinDebug\n*F\n+ 1 JestRunConfigurationProducer.kt\ncom/intellij/javascript/jest/JestRunConfigurationProducer$Companion\n*L\n207#1:214,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final VirtualFile findDefaultConfigFile(@NotNull VirtualFile dir) {
            Object v1;
            block1: {
                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                List<String> list = JestUtil.DEFAULT_CONFIG_FILE_NAMES;
                Intrinsics.checkNotNullExpressionValue(list, (String)"DEFAULT_CONFIG_FILE_NAMES");
                Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), arg_0 -> Companion.findDefaultConfigFile$lambda$0(dir, arg_0));
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl = false;
                    if (!(it != null && !it.isDirectory())) continue;
                    v1 = element$iv;
                    break block1;
                }
                v1 = null;
            }
            return v1;
        }

        private static final VirtualFile findDefaultConfigFile$lambda$0(VirtualFile $dir, String it) {
            return $dir.findChild(it);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/javascript/jest/JestRunConfigurationProducer$Context;", "", "element", "Lcom/intellij/psi/PsiElement;", "psiFile", "Lcom/intellij/psi/PsiFile;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "templateRunSettings", "Lcom/intellij/javascript/jest/JestRunSettings;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/javascript/jest/JestRunSettings;)V", "getElement", "()Lcom/intellij/psi/PsiElement;", "getPsiFile", "()Lcom/intellij/psi/PsiFile;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getTemplateRunSettings", "()Lcom/intellij/javascript/jest/JestRunSettings;", "intellij.javascript.ultimate"})
    private static final class Context {
        @NotNull
        private final PsiElement element;
        @Nullable
        private final PsiFile psiFile;
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final JestRunSettings templateRunSettings;

        public Context(@NotNull PsiElement element, @Nullable PsiFile psiFile, @NotNull VirtualFile file, @NotNull JestRunSettings templateRunSettings) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)templateRunSettings, (String)"templateRunSettings");
            this.element = element;
            this.psiFile = psiFile;
            this.file = file;
            this.templateRunSettings = templateRunSettings;
        }

        @NotNull
        public final PsiElement getElement() {
            return this.element;
        }

        @Nullable
        public final PsiFile getPsiFile() {
            return this.psiFile;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        @NotNull
        public final JestRunSettings getTemplateRunSettings() {
            return this.templateRunSettings;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/javascript/jest/JestRunConfigurationProducer$ExtendedSettings;", "", "initialSettings", "Lcom/intellij/javascript/jest/JestRunSettings;", "contextFileOrDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "enclosingElement", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/javascript/jest/JestRunConfigurationProducer;Lcom/intellij/javascript/jest/JestRunSettings;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/psi/PsiElement;)V", "getEnclosingElement", "()Lcom/intellij/psi/PsiElement;", "settings", "getSettings", "()Lcom/intellij/javascript/jest/JestRunSettings;", "intellij.javascript.ultimate"})
    private final class ExtendedSettings {
        @NotNull
        private final PsiElement enclosingElement;
        @NotNull
        private final JestRunSettings settings;

        public ExtendedSettings(@NotNull JestRunSettings initialSettings, @NotNull VirtualFile contextFileOrDir, PsiElement enclosingElement) {
            Intrinsics.checkNotNullParameter((Object)initialSettings, (String)"initialSettings");
            Intrinsics.checkNotNullParameter((Object)contextFileOrDir, (String)"contextFileOrDir");
            Intrinsics.checkNotNullParameter((Object)enclosingElement, (String)"enclosingElement");
            this.enclosingElement = enclosingElement;
            Project project = this.enclosingElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            this.settings = JestRunConfigurationProducer.this.fixWorkingDir(initialSettings, contextFileOrDir, project).modify((Function1<? super JestRunSettings.Builder, Unit>)((Function1)ExtendedSettings::settings$lambda$0));
        }

        @NotNull
        public final PsiElement getEnclosingElement() {
            return this.enclosingElement;
        }

        @NotNull
        public final JestRunSettings getSettings() {
            return this.settings;
        }

        private static final Unit settings$lambda$0(JestRunSettings.Builder it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.setScope(it.getScope().normalize());
            return Unit.INSTANCE;
        }
    }
}

