/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.utils;

import com.intellij.openapi.util.TextRange;
import com.intellij.util.text.PlaceholderTextRanges;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u00a8\u0006\u0006"}, d2={"substituteUrlVariables", "", "urlPattern", "prefix", "suffix", "replacement", "intellij.platform.lang"})
@JvmName(name="PlaceholderReplaceUtils")
public final class PlaceholderReplaceUtils {
    @NotNull
    public static final String substituteUrlVariables(@NotNull String urlPattern, @NotNull String prefix, @NotNull String suffix, @NotNull String replacement) {
        Intrinsics.checkNotNullParameter((Object)urlPattern, (String)"urlPattern");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        String url = urlPattern;
        Set set = PlaceholderTextRanges.getPlaceholderRanges((String)url, (String)prefix, (String)suffix, (boolean)false, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getPlaceholderRanges(...)");
        Set ranges2 = set;
        if (ranges2.isEmpty()) {
            return url;
        }
        StringBuilder builder = new StringBuilder(url.length());
        int offset = 0;
        for (TextRange range : ranges2) {
            builder.append(url, offset, range.getStartOffset() - prefix.length());
            builder.append(replacement);
            offset = range.getEndOffset() + suffix.length();
        }
        String string = url.substring(offset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        builder.append(string);
        String string2 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        url = string2;
        return url;
    }
}

