/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.loader;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.ZipFileSystemAccessor;
import org.jetbrains.kotlin.konan.file.ZipFileSystemInPlaceAccessor;
import org.jetbrains.kotlin.library.KotlinAbiVersion;
import org.jetbrains.kotlin.library.loader.DefaultKlibLibraryProvider;
import org.jetbrains.kotlin.library.loader.KlibLibraryProvider;
import org.jetbrains.kotlin.library.loader.KlibLoaderImpl;
import org.jetbrains.kotlin.library.loader.KlibLoaderResult;
import org.jetbrains.kotlin.library.loader.KlibLoaderSpec;
import org.jetbrains.kotlin.library.loader.KlibManifestTransformer;
import org.jetbrains.kotlin.library.loader.KlibPlatformChecker;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001e\u0012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0016\u001a\u00020\u0017R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\r0\tj\b\u0012\u0004\u0012\u00020\r`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/library/loader/KlibLoader;", "", "init", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/library/loader/KlibLoaderSpec;", "", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)V", "libraryPaths", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "libraryProviders", "Lorg/jetbrains/kotlin/library/loader/KlibLibraryProvider;", "manifestTransformer", "Lorg/jetbrains/kotlin/library/loader/KlibManifestTransformer;", "maxPermittedAbiVersion", "Lorg/jetbrains/kotlin/library/KotlinAbiVersion;", "platformChecker", "Lorg/jetbrains/kotlin/library/loader/KlibPlatformChecker;", "zipFileSystemAccessor", "Lorg/jetbrains/kotlin/konan/file/ZipFileSystemAccessor;", "load", "Lorg/jetbrains/kotlin/library/loader/KlibLoaderResult;", "kotlin-util-klib"})
public final class KlibLoader {
    @NotNull
    private final ArrayList<KlibLibraryProvider> libraryProviders;
    @NotNull
    private final ArrayList<String> libraryPaths;
    @Nullable
    private KlibPlatformChecker platformChecker;
    @Nullable
    private KotlinAbiVersion maxPermittedAbiVersion;
    @Nullable
    private ZipFileSystemAccessor zipFileSystemAccessor;
    @Nullable
    private KlibManifestTransformer manifestTransformer;

    public KlibLoader(@NotNull Function1<? super KlibLoaderSpec, Unit> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        this.libraryProviders = new ArrayList();
        this.libraryPaths = new ArrayList();
        init.invoke((Object)new KlibLoaderSpec(){

            @Override
            public void libraryProviders(List<? extends KlibLibraryProvider> providers) {
                Intrinsics.checkNotNullParameter(providers, (String)"providers");
                CollectionsKt.addAll((Collection)libraryProviders, (Iterable)providers);
            }

            @Override
            public void libraryProviders(KlibLibraryProvider ... providers) {
                Intrinsics.checkNotNullParameter((Object)providers, (String)"providers");
                CollectionsKt.addAll((Collection)libraryProviders, (Object[])providers);
            }

            @Override
            public void libraryPaths(List<String> paths) {
                Intrinsics.checkNotNullParameter(paths, (String)"paths");
                libraryPaths.addAll((Collection)paths);
            }

            @Override
            public void libraryPaths(String ... paths) {
                Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
                CollectionsKt.addAll((Collection)libraryPaths, (Object[])paths);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void libraryPaths(File ... paths) {
                void $this$mapTo$iv;
                Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
                File[] fileArray = paths;
                Collection destination$iv = libraryPaths;
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv;
                    void var8_8 = item$iv = $this$mapTo$iv[i];
                    Collection collection = destination$iv;
                    boolean bl = false;
                    collection.add(it.getPath());
                }
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void libraryPaths(Path ... paths) {
                void $this$mapTo$iv;
                Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
                Path[] pathArray = paths;
                Collection destination$iv = libraryPaths;
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv;
                    void var8_8 = item$iv = $this$mapTo$iv[i];
                    Collection collection = destination$iv;
                    boolean bl = false;
                    collection.add(it.toString());
                }
            }

            @Override
            public void platformChecker(KlibPlatformChecker checker) {
                Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
                platformChecker = checker;
            }

            @Override
            public void maxPermittedAbiVersion(KotlinAbiVersion abiVersion) {
                Intrinsics.checkNotNullParameter((Object)abiVersion, (String)"abiVersion");
                maxPermittedAbiVersion = abiVersion;
            }

            @Override
            public void zipFileSystemAccessor(ZipFileSystemAccessor accessor) {
                Intrinsics.checkNotNullParameter((Object)accessor, (String)"accessor");
                zipFileSystemAccessor = accessor;
            }

            @Override
            public void manifestTransformer(KlibManifestTransformer transformer) {
                Intrinsics.checkNotNullParameter((Object)transformer, (String)"transformer");
                manifestTransformer = transformer;
            }
        });
    }

    @NotNull
    public final KlibLoaderResult load() {
        List list;
        List $this$load_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        ((Collection)$this$load_u24lambda_u240).add(new DefaultKlibLibraryProvider((List<String>)this.libraryPaths));
        CollectionsKt.addAll((Collection)$this$load_u24lambda_u240, (Iterable)this.libraryProviders);
        List libraryProviders = CollectionsKt.build((List)list);
        ZipFileSystemAccessor zipFileSystemAccessor = this.zipFileSystemAccessor;
        if (zipFileSystemAccessor == null) {
            zipFileSystemAccessor = ZipFileSystemInPlaceAccessor.INSTANCE;
        }
        return new KlibLoaderImpl(libraryProviders, this.platformChecker, this.maxPermittedAbiVersion, zipFileSystemAccessor, this.manifestTransformer).loadLibraries();
    }
}

