/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parsing;

import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.psi.utils.ConstantExpressionUtils;

@Metadata(mv={2, 4, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0004\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0005\u001a\u000e\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\r"}, d2={"hasIllegalUnderscore", "", "text", "", "elementType", "Lcom/intellij/psi/tree/IElementType;", "hasLongSuffix", "hasUnsignedSuffix", "hasUnsignedLongSuffix", "parseNumericLiteral", "", "type", "parseBoolean", "parser"})
public final class ParseUtilsKt {
    public static final boolean hasIllegalUnderscore(@NotNull String text, @NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        return elementType == KtNodeTypes.INTEGER_CONSTANT ? ConstantExpressionUtils.hasIllegallyPositionedUnderscore(text, false) : ConstantExpressionUtils.hasIllegallyPositionedUnderscore(text, true);
    }

    public static final boolean hasLongSuffix(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return ConstantExpressionUtils.hasLongNumericLiteralSuffix(text);
    }

    public static final boolean hasUnsignedSuffix(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return ConstantExpressionUtils.hasUnsignedNumericLiteralSuffix(text);
    }

    public static final boolean hasUnsignedLongSuffix(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return ConstantExpressionUtils.hasUnsignedLongNumericLiteralSuffix(text);
    }

    @Nullable
    public static final Number parseNumericLiteral(@NotNull String text, @NotNull IElementType type) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        IElementType iElementType = type;
        return Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.INTEGER_CONSTANT) ? (Number)ConstantExpressionUtils.parseNumericLiteral(text, false) : (Number)(Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.FLOAT_CONSTANT) ? ConstantExpressionUtils.parseNumericLiteral(text, true) : null);
    }

    public static final boolean parseBoolean(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return ConstantExpressionUtils.parseBooleanLiteral(text);
    }
}

