/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.installPlugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PendingDynamicPluginInstall;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginInstallOperation;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BW\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0010\u0010\u000f\u001a\f\u0012\u0006\b\u0000\u0012\u00020\n\u0018\u00010\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\f\u0012\u0006\b\u0000\u0012\u00020\n\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ide/startup/importSettings/installPlugins/TransferSettingsDownloadPluginsTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "project", "Lcom/intellij/openapi/project/Project;", "plugins", "", "Lcom/intellij/ide/plugins/PluginNode;", "customPlugins", "", "allowInstallWithoutRestart", "", "pluginEnabler", "Lcom/intellij/ide/plugins/PluginEnabler;", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "function", "Ljava/util/function/Consumer;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/util/Collection;ZLcom/intellij/ide/plugins/PluginEnabler;Lcom/intellij/openapi/application/ModalityState;Ljava/util/function/Consumer;)V", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.ide.startup.importSettings"})
public final class TransferSettingsDownloadPluginsTask
extends Task.Backgroundable {
    @NotNull
    private final List<PluginNode> plugins;
    @NotNull
    private final Collection<PluginNode> customPlugins;
    private final boolean allowInstallWithoutRestart;
    @NotNull
    private final PluginEnabler pluginEnabler;
    @NotNull
    private final ModalityState modalityState;
    @Nullable
    private final Consumer<? super Boolean> function;

    public TransferSettingsDownloadPluginsTask(@Nullable Project project, @NotNull List<PluginNode> plugins2, @NotNull Collection<PluginNode> customPlugins, boolean allowInstallWithoutRestart, @NotNull PluginEnabler pluginEnabler, @NotNull ModalityState modalityState, @Nullable Consumer<? super Boolean> function) {
        Intrinsics.checkNotNullParameter(plugins2, (String)"plugins");
        Intrinsics.checkNotNullParameter(customPlugins, (String)"customPlugins");
        Intrinsics.checkNotNullParameter((Object)pluginEnabler, (String)"pluginEnabler");
        Intrinsics.checkNotNullParameter((Object)modalityState, (String)"modalityState");
        super(project, IdeBundle.message((String)"progress.download.plugins", (Object[])new Object[0]), true);
        this.plugins = plugins2;
        this.customPlugins = customPlugins;
        this.allowInstallWithoutRestart = allowInstallWithoutRestart;
        this.pluginEnabler = pluginEnabler;
        this.modalityState = modalityState;
        this.function = function;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Ref.BooleanRef success = new Ref.BooleanRef();
        success.element = true;
        try {
            PluginInstallOperation operation = new PluginInstallOperation(this.plugins, this.customPlugins, this.pluginEnabler, indicator);
            operation.setAllowInstallWithoutRestart(this.allowInstallWithoutRestart);
            operation.run();
            success.element = operation.isSuccess();
            if (success.element) {
                ApplicationManager.getApplication().invokeLater(() -> TransferSettingsDownloadPluginsTask.run$lambda$0(this, operation, success), this.modalityState);
            }
        }
        finally {
            ApplicationManager.getApplication().invokeLater(() -> TransferSettingsDownloadPluginsTask.run$lambda$1(this, success), this.modalityState);
        }
    }

    private static final void run$lambda$0(TransferSettingsDownloadPluginsTask this$0, PluginInstallOperation $operation, Ref.BooleanRef $success) {
        if (this$0.allowInstallWithoutRestart) {
            for (PendingDynamicPluginInstall pendingDynamicPluginInstall : $operation.getPendingDynamicPluginInstalls()) {
                Path file = pendingDynamicPluginInstall.component1();
                IdeaPluginDescriptorImpl pluginDescriptor = pendingDynamicPluginInstall.component2();
                $success.element &= PluginInstaller.installAndLoadDynamicPlugin((Path)file, (IdeaPluginDescriptorImpl)pluginDescriptor);
            }
        }
    }

    private static final void run$lambda$1(TransferSettingsDownloadPluginsTask this$0, Ref.BooleanRef $success) {
        block0: {
            Consumer<? super Boolean> consumer = this$0.function;
            if (consumer == null) break block0;
            consumer.accept((Boolean)$success.element);
        }
    }
}

