/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001BC\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\nH\u0002J\b\u0010\"\u001a\u0004\u0018\u00010\u0005J\u0006\u0010-\u001a\u00020\nR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0012R\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u001e\u0010\u0007\u001a\u0004\u0018\u00010\b@\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001b\u0010\u0019\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001a\u0010\u0016R\u001d\u0010\u001d\u001a\u0004\u0018\u00010\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u001c\u001a\u0004\b\u001e\u0010\u0016R\u001b\u0010#\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u001c\u001a\u0004\b$\u0010\u0016R\u0011\u0010&\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0012R\u0011\u0010'\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0016R\u0011\u0010)\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u0006."}, d2={"Lorg/jetbrains/builtInWebServer/PathInfo;", "", "ioFile", "Ljava/nio/file/Path;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "root", "moduleName", "", "isLibrary", "", "isRootNameOptionalInPath", "<init>", "(Ljava/nio/file/Path;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;ZZ)V", "getIoFile", "()Ljava/nio/file/Path;", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "()Z", "value", "getFile", "getModuleName", "()Ljava/lang/String;", "setModuleName", "(Ljava/lang/String;)V", "path", "getPath", "path$delegate", "Lkotlin/Lazy;", "rootLessPathIfPossible", "getRootLessPathIfPossible", "rootLessPathIfPossible$delegate", "buildPath", "useRootName", "getOrResolveVirtualFile", "filePath", "getFilePath", "filePath$delegate", "isValid", "name", "getName", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "getFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "isDirectory", "intellij.platform.builtInServer"})
public final class PathInfo {
    @Nullable
    private final Path ioFile;
    @NotNull
    private final VirtualFile root;
    private final boolean isLibrary;
    private final boolean isRootNameOptionalInPath;
    @Nullable
    private VirtualFile file;
    @Nullable
    private String moduleName;
    @NotNull
    private final Lazy path$delegate;
    @NotNull
    private final Lazy rootLessPathIfPossible$delegate;
    @NotNull
    private final Lazy filePath$delegate;

    public PathInfo(@Nullable Path ioFile, @Nullable VirtualFile file, @NotNull VirtualFile root, @Nullable String moduleName, boolean isLibrary, boolean isRootNameOptionalInPath) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.ioFile = ioFile;
        this.root = root;
        this.isLibrary = isLibrary;
        this.isRootNameOptionalInPath = isRootNameOptionalInPath;
        this.file = file;
        this.moduleName = moduleName;
        this.path$delegate = LazyKt.lazy(() -> PathInfo.path_delegate$lambda$0(this));
        this.rootLessPathIfPossible$delegate = LazyKt.lazy(() -> PathInfo.rootLessPathIfPossible_delegate$lambda$0(this));
        this.filePath$delegate = LazyKt.lazy(() -> PathInfo.filePath_delegate$lambda$0(this, file));
    }

    public /* synthetic */ PathInfo(Path path, VirtualFile virtualFile, VirtualFile virtualFile2, String string, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        this(path, virtualFile, virtualFile2, string, bl, bl2);
    }

    @Nullable
    public final Path getIoFile() {
        return this.ioFile;
    }

    @NotNull
    public final VirtualFile getRoot() {
        return this.root;
    }

    public final boolean isLibrary() {
        return this.isLibrary;
    }

    public final boolean isRootNameOptionalInPath() {
        return this.isRootNameOptionalInPath;
    }

    @Nullable
    public final VirtualFile getFile() {
        return this.file;
    }

    @Nullable
    public final String getModuleName() {
        return this.moduleName;
    }

    @ApiStatus.Internal
    public final void setModuleName(@Nullable String string) {
        this.moduleName = string;
    }

    @NotNull
    public final String getPath() {
        Lazy lazy = this.path$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getRootLessPathIfPossible() {
        Lazy lazy = this.rootLessPathIfPossible$delegate;
        return (String)lazy.getValue();
    }

    private final String buildPath(boolean useRootName) {
        VirtualFile relativeTo;
        StringBuilder builder = new StringBuilder();
        if (this.moduleName != null) {
            builder.append(this.moduleName).append('/');
        }
        if (this.isLibrary) {
            builder.append(this.root.getName()).append('/');
        }
        if (useRootName) {
            v0 = this.root;
        } else {
            v0 = this.root.getParent();
            if (v0 == null) {
                v0 = relativeTo = this.root;
            }
        }
        if (this.file == null) {
            String string = relativeTo.getPath();
            Path path = this.ioFile;
            Intrinsics.checkNotNull((Object)path);
            v3 = builder.append(FileUtilRt.getRelativePath((String)string, (String)StringsKt.replace$default((String)((Object)path).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null), (char)'/'));
        } else {
            VirtualFile virtualFile = this.file;
            Intrinsics.checkNotNull((Object)virtualFile);
            v3 = builder.append(VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)relativeTo, (char)'/'));
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final VirtualFile getOrResolveVirtualFile() {
        VirtualFile virtualFile;
        if (this.file == null) {
            void var1_1;
            VirtualFile result;
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            Path path = this.ioFile;
            Intrinsics.checkNotNull((Object)path);
            this.file = result = localFileSystem.findFileByPath(PathsKt.getInvariantSeparatorsPathString((Path)path));
            virtualFile = var1_1;
        } else {
            virtualFile = this.file;
        }
        return virtualFile;
    }

    @NotNull
    public final String getFilePath() {
        Lazy lazy = this.filePath$delegate;
        return (String)lazy.getValue();
    }

    public final boolean isValid() {
        boolean bl;
        if (this.ioFile == null) {
            VirtualFile virtualFile = this.file;
            Intrinsics.checkNotNull((Object)virtualFile);
            bl = virtualFile.isValid();
        } else {
            bl = Files.exists(this.ioFile, new LinkOption[0]);
        }
        return bl;
    }

    @NotNull
    public final String getName() {
        Object object = this.ioFile;
        if (object == null || (object = object.getFileName()) == null || (object = object.toString()) == null) {
            VirtualFile virtualFile = this.file;
            Intrinsics.checkNotNull((Object)virtualFile);
            String string = virtualFile.getName();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        }
        return object;
    }

    @NotNull
    public final FileType getFileType() {
        FileType fileType;
        if (this.ioFile == null) {
            VirtualFile virtualFile = this.file;
            Intrinsics.checkNotNull((Object)virtualFile);
            FileType fileType2 = virtualFile.getFileType();
            fileType = fileType2;
            Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"getFileType(...)");
        } else {
            FileType fileType3 = FileTypeManager.getInstance().getFileTypeByFileName(((Object)this.ioFile.getFileName()).toString());
            fileType = fileType3;
            Intrinsics.checkNotNullExpressionValue((Object)fileType3, (String)"getFileTypeByFileName(...)");
        }
        return fileType;
    }

    public final boolean isDirectory() {
        boolean bl;
        Path path = this.ioFile;
        if (path != null) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            bl = Files.isDirectory(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        } else {
            VirtualFile virtualFile = this.file;
            Intrinsics.checkNotNull((Object)virtualFile);
            bl = virtualFile.isDirectory();
        }
        return bl;
    }

    private static final String path_delegate$lambda$0(PathInfo this$0) {
        return this$0.buildPath(true);
    }

    private static final String rootLessPathIfPossible_delegate$lambda$0(PathInfo this$0) {
        return this$0.isRootNameOptionalInPath ? this$0.buildPath(false) : null;
    }

    private static final String filePath_delegate$lambda$0(PathInfo this$0, VirtualFile $file) {
        Object object = this$0.ioFile;
        if (object == null || (object = object.toString()) == null) {
            VirtualFile virtualFile = $file;
            Intrinsics.checkNotNull((Object)virtualFile);
            String string = FileUtilRt.toSystemDependentName((String)virtualFile.getPath());
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
        }
        return object;
    }
}

